/*
 * Decompiled with CFR 0.152.
 */
package quicktime;

import quicktime.QTException;
import quicktime.QTNullPointerException;
import quicktime.QTObjectManagement;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.jdirect.QTNative;
import quicktime.std.clocks.QTCallBack;
import quicktime.std.movies.media.Media;

public abstract class QTObject {
    private static final boolean doSecurityCheck = QTSession.hasSecurityRestrictions();
    static boolean qtIsNOTInitialized = true;
    private transient int nativeRep = 0;
    private transient Object ref = null;
    protected final transient int sessionAllocated = QTSession.sessionID;

    public static final int ID(QTObject qTObject) {
        return qTObject == null ? 0 : qTObject.nativeRep;
    }

    protected QTObject(int n) {
        this(n, 0);
    }

    protected QTObject(int n, Object object) {
        this(n, object, 0);
    }

    protected QTObject(int n, Object object, int n2) {
        this._doSC();
        this.nativeRep = n;
        this.ref = object;
        if (object == null) {
            if (n == 0) {
                throw new QTNullPointerException("The QT native object represented by this QTJava object is not valid:" + this.getClass().getName());
            }
            QTObjectManagement.add(this, this.nativeRep, n2);
        }
    }

    protected QTObject(int n, int n2) {
        if (n == 0) {
            throw new QTNullPointerException("The QT native object represented by this QTJava object is not valid:" + this.getClass().getName());
        }
        this._doSC();
        this.nativeRep = n;
        QTObjectManagement.add(this, this.nativeRep, n2);
    }

    protected final int _ID() {
        if (qtIsNOTInitialized || this.nativeRep == 0 || this.sessionAllocated != QTSession.sessionID) {
            String string = this.getClass().getName();
            if (qtIsNOTInitialized) {
                throw new QTNullPointerException("QuickTime MUST be initialized:" + string);
            }
            if (this.nativeRep == 0) {
                throw new QTNullPointerException("The QT native object represented by this QTJava object is no longer valid:" + string);
            }
            throw new QTNullPointerException("This QTJava object was allocated in a previous QTSession and is no longer valid:" + string);
        }
        return this.nativeRep;
    }

    protected boolean stillValid() {
        return QTObjectManagement.isMember(this.nativeRep) && this.sessionAllocated == QTSession.sessionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        try {
            Object object = QTSession.terminationLock();
            synchronized (object) {
                if (QTSession.isInitialized() && this.nativeRep != 0 && this.ref == null && this.sessionAllocated == QTSession.sessionID) {
                    if (QTObjectManagement.isMember(this.nativeRep)) {
                        this._dispose();
                        Object object2 = QTNative.globalsLock;
                        synchronized (object2) {
                            QTObjectManagement.remove(this.nativeRep, this);
                        }
                    } else {
                        this._dispose();
                    }
                }
            }
        }
        finally {
            this.nativeRep = 0;
            super.finalize();
        }
    }

    public void disposeQTObject() throws QTException {
        try {
            this.finalize();
        }
        catch (Throwable throwable) {
            throw new QTException(throwable.toString());
        }
    }

    protected void _dispose() throws QTException {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof QTObject) {
            return this.nativeRep == QTObject.ID((QTObject)object);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.nativeRep);
    }

    private final void _doSC() {
        if (doSecurityCheck && !(this instanceof QTCallBack) && !(this instanceof Media) && this.getClass().getClassLoader() != null && !this.getClass().getName().startsWith("quicktime.")) {
            throw new SecurityException(this.getClass().getName() + " cannot be constructed with current Security settings");
        }
    }

    protected final void setNR(int n) {
        if (this.ref == null) {
            throw new QTRuntimeException("Cannot reset a disposable reference " + this.getClass().getName());
        }
        if (this.nativeRep == n) {
            return;
        }
        this.nativeRep = n;
    }
}

