/*
 * Decompiled with CFR 0.152.
 */
package quicktime;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTSession;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QTStreamingLib;
import quicktime.jdirect.QuickDraw3DLib;
import quicktime.jdirect.QuickTimeLib;
import quicktime.jdirect.QuickTimeVRLib;
import quicktime.qd.ColorTable;
import quicktime.qd.Pict;
import quicktime.qd.PixMap;
import quicktime.qd.Polygon;
import quicktime.qd.Region;
import quicktime.sound.SPBDevice;
import quicktime.sound.SndChannel;
import quicktime.std.anim.SpriteWorld;
import quicktime.std.clocks.TimeBase;
import quicktime.std.comp.Component;
import quicktime.std.image.CSequence;
import quicktime.std.image.DSequence;
import quicktime.std.movies.AtomContainer;
import quicktime.std.movies.Movie;
import quicktime.std.movies.MovieController;
import quicktime.std.movies.MovieEditState;
import quicktime.std.movies.TrackEditState;
import quicktime.std.movies.media.UserData;
import quicktime.std.music.NoteChannel;
import quicktime.std.sg.SGDeviceList;
import quicktime.streaming.Presentation;
import quicktime.streaming.Stream;
import quicktime.util.QTHandleRef;
import quicktime.util.QTPointerRef;

final class QTObjectManagement
implements QuickTimeLib,
QuickTimeVRLib,
QuickDraw3DLib,
QTStreamingLib {
    private static Object linkage;
    static final boolean debug = false;
    static final boolean addDebug = false;
    static final boolean removeDebug = false;
    static int addCount;
    static int removeCount;
    private static boolean lock;
    private static Hashtable qtObjs;
    private static final String atomContainerName = "AtomContainer";
    private static final String componentName = "Component";
    private static final String cdSequence = "CDSequence";
    private static final String codecNameListName = "CodecNameList";
    private static final String colorTableName = "ColorTable";
    private static final String qtHandleRefName = "QTHandleRef";
    private static final String movieName = "Movie";
    private static final String movieEditStateName = "MovieEditState";
    private static final String movieControllerName = "MovieController";
    private static final String noteChannelName = "NoteChannel";
    private static final String pictName = "Pict";
    private static final String pixMapName = "PixMap";
    private static final String presentationName = "Presentation";
    private static final String qtPointerRefName = "QTPointerRef";
    private static final String qdGraphics = "QDGraphics";
    private static final String regionName = "Region";
    private static final String polygonName = "Polygon";
    private static final String sndChannelName = "SndChannel";
    private static final String spbDeviceName = "SPBDevice";
    private static final String sgDeviceListName = "SGDeviceList";
    private static final String spriteWorldName = "SpriteWorld";
    private static final String streamName = "Stream";
    private static final String timeBaseName = "TimeBase";
    private static final String trackEditStateName = "TrackEditState";
    private static final String userDataName = "UserData";
    static /* synthetic */ Class class$quicktime$QTObjectManagement;

    private QTObjectManagement() {
    }

    static boolean isMember(int n) {
        while (lock) {
            Thread.yield();
        }
        if (qtObjs == null) {
            return false;
        }
        Integer n2 = new Integer(n);
        return qtObjs.containsKey(n2);
    }

    static boolean add(QTObject qTObject, int n, int n2) {
        if (qTObject == null || n == 0) {
            return false;
        }
        if (qtObjs == null) {
            qtObjs = new Hashtable();
        }
        if (qtObjs.containsKey(new Integer(n))) {
            return false;
        }
        String string = null;
        if (qTObject instanceof Component) {
            string = qTObject instanceof MovieController ? movieControllerName : componentName;
        } else if (qTObject instanceof QTHandleRef) {
            string = qTObject instanceof Region ? regionName : (qTObject instanceof Polygon ? polygonName : (qTObject instanceof Pict ? pictName : (qTObject instanceof AtomContainer ? atomContainerName : (qTObject instanceof ColorTable ? colorTableName : (qTObject instanceof PixMap ? pixMapName : (qTObject instanceof SGDeviceList ? sgDeviceListName : qtHandleRefName))))));
        } else if (qTObject instanceof QTPointerRef) {
            String string2 = qTObject.getClass().getName();
            string = string2.endsWith(qdGraphics) ? qdGraphics : (string2.endsWith(codecNameListName) ? codecNameListName : qtPointerRefName);
        } else if (qTObject instanceof DSequence || qTObject instanceof CSequence) {
            string = cdSequence;
        } else if (qTObject instanceof Movie) {
            string = movieName;
        } else if (qTObject instanceof SpriteWorld) {
            string = spriteWorldName;
        } else if (qTObject instanceof MovieEditState) {
            string = movieEditStateName;
        } else if (qTObject instanceof SPBDevice) {
            string = spbDeviceName;
        } else if (qTObject instanceof SndChannel) {
            string = sndChannelName;
        } else if (qTObject instanceof TimeBase) {
            string = timeBaseName;
        } else if (qTObject instanceof TrackEditState) {
            string = trackEditStateName;
        } else if (qTObject instanceof UserData) {
            string = userDataName;
        } else if (qTObject instanceof NoteChannel) {
            string = noteChannelName;
        } else if (!QTSession.hasSecurityRestrictions() && !QTSession.isCurrentOS(2)) {
            if (qTObject instanceof Presentation) {
                string = presentationName;
            } else if (qTObject instanceof Stream) {
                string = streamName;
            }
        }
        if (string == null) {
            return false;
        }
        if (n2 != 0) {
            string = string + "_" + Integer.toString(n2);
        }
        qtObjs.put(new Integer(n), string);
        return true;
    }

    static boolean remove(int n, QTObject qTObject) throws QTException {
        Integer n2 = new Integer(n);
        if (qtObjs.containsKey(n2)) {
            try {
                QTObjectManagement.disposeSessionObject(n, (String)qtObjs.get(n2), qTObject);
            }
            catch (QTException qTException) {
                throw qTException;
            }
            finally {
                qtObjs.remove(n2);
            }
            return true;
        }
        return false;
    }

    static void removeAll() {
        Integer n;
        Object object;
        Serializable serializable;
        if (qtObjs == null) {
            return;
        }
        while (lock) {
            Thread.yield();
        }
        lock = true;
        Enumeration<Object> enumeration = qtObjs.keys();
        while (enumeration.hasMoreElements()) {
            serializable = (Integer)enumeration.nextElement();
            object = (String)qtObjs.get(serializable);
            if (((String)object).startsWith(sgDeviceListName)) {
                try {
                    QTObjectManagement.disposeSessionObject((Integer)serializable, sgDeviceListName);
                }
                catch (QTException qTException) {
                    qTException.printStackTrace();
                }
            }
            if (((String)object).startsWith(noteChannelName)) {
                try {
                    QTObjectManagement.disposeSessionObject((Integer)serializable, noteChannelName);
                }
                catch (QTException qTException) {
                    qTException.printStackTrace();
                }
            }
            if (((String)object).startsWith(spriteWorldName)) {
                try {
                    QTObjectManagement.disposeSessionObject((Integer)serializable, spriteWorldName);
                }
                catch (QTException qTException) {
                    qTException.printStackTrace();
                }
            }
            if (!((String)object).startsWith(cdSequence)) continue;
            try {
                QTObjectManagement.disposeSessionObject((Integer)serializable, cdSequence);
            }
            catch (QTException qTException) {
                qTException.printStackTrace();
            }
        }
        enumeration = qtObjs.keys();
        serializable = new Vector();
        object = new Vector();
        while (enumeration.hasMoreElements()) {
            n = (Integer)enumeration.nextElement();
            String string = (String)qtObjs.get(n);
            if (string.startsWith(movieName) && !string.startsWith(movieControllerName) && !string.startsWith(movieEditStateName)) {
                ((Vector)serializable).addElement(n);
                continue;
            }
            if (string.startsWith(qdGraphics)) {
                ((Vector)object).addElement(n);
                continue;
            }
            if (string.startsWith(sgDeviceListName) || string.startsWith(noteChannelName) || string.startsWith(spriteWorldName) || string.startsWith(cdSequence)) continue;
            try {
                QTObjectManagement.disposeSessionObject(n, string);
            }
            catch (QTException qTException) {
                qTException.printStackTrace();
            }
        }
        enumeration = ((Vector)serializable).elements();
        while (enumeration.hasMoreElements()) {
            n = (Integer)enumeration.nextElement();
            try {
                QTObjectManagement.disposeSessionObject(n, movieName);
            }
            catch (QTException qTException) {
                qTException.printStackTrace();
            }
        }
        enumeration = ((Vector)object).elements();
        while (enumeration.hasMoreElements()) {
            n = (Integer)enumeration.nextElement();
            try {
                QTObjectManagement.disposeSessionObject(n, qdGraphics);
            }
            catch (QTException qTException) {
                qTException.printStackTrace();
            }
        }
        qtObjs.clear();
        lock = false;
        qtObjs = null;
        ((Vector)serializable).removeAllElements();
        serializable = null;
        ((Vector)object).removeAllElements();
        object = null;
    }

    private static int pullIDFromName(String string) {
        int n = string.lastIndexOf("_");
        if (n != -1) {
            String string2 = string.substring(n + 1);
            return new Integer(string2);
        }
        return 0;
    }

    private static void disposeSessionObject(int n, String string, Object object) throws QTException {
        if (object == null) {
            QTObjectManagement.disposeSessionObject(n, string);
        } else if (object instanceof SndChannel) {
            boolean bl = ((SndChannel)object).isQuietNow();
            short s = QTObjectManagement.SndDisposeChannel(n, (byte)(bl ? 1 : 0));
            QTException.checkError(s);
        } else {
            QTObjectManagement.disposeSessionObject(n, string);
        }
    }

    private static void disposeSessionObject(int n, String string) throws QTException {
        Object var2_2 = null;
        int n2 = 0;
        if (string.startsWith(atomContainerName)) {
            n2 = QTObjectManagement.QTDisposeAtomContainer(n);
        } else if (string.startsWith(componentName)) {
            n2 = QTObjectManagement.CloseComponent(n);
        } else if (string.startsWith(cdSequence)) {
            n2 = QTObjectManagement.CDSequenceEnd(n);
        } else if (string.startsWith(codecNameListName)) {
            n2 = QTObjectManagement.DisposeCodecNameList(n);
        } else if (string.startsWith(colorTableName)) {
            QTObjectManagement.DisposeCTable(n);
        } else if (string.startsWith(qdGraphics)) {
            QTObjectManagement.DisposeGWorld(n);
        } else if (string.startsWith(qtHandleRefName)) {
            QTObjectManagement.DisposeHandle(n);
        } else if (string.startsWith(movieEditStateName)) {
            n2 = QTObjectManagement.DisposeMovieEditState(n);
        } else if (string.startsWith(movieControllerName)) {
            QTObjectManagement.DisposeMovieController(n);
        } else if (string.startsWith(movieName)) {
            QTObjectManagement.DisposeMovie(n);
        } else if (string.startsWith(noteChannelName)) {
            int n3 = QTObjectManagement.pullIDFromName(string);
            if (n3 != 0) {
                n2 = QTObjectManagement.NADisposeNoteChannel(n3, n);
            }
        } else if (string.startsWith(pictName)) {
            QTObjectManagement.KillPicture(n);
        } else if (string.startsWith(pixMapName)) {
            QTObjectManagement.DisposeMatte(n);
        } else if (string.startsWith(qtPointerRefName)) {
            QTObjectManagement.DisposePtr(n);
        } else if (string.startsWith(regionName)) {
            QTObjectManagement.DisposeRgn(n);
        } else if (string.startsWith(polygonName)) {
            QTObjectManagement.KillPoly(n);
        } else if (string.startsWith(presentationName)) {
            n2 = QTObjectManagement.QTSDisposePresentation(n, 0);
        } else if (string.startsWith(sndChannelName)) {
            n2 = QTObjectManagement.SndDisposeChannel(n, (byte)1);
        } else if (string.startsWith(spbDeviceName)) {
            QTObjectManagement.SPBCloseDevice(n);
        } else if (string.startsWith(sgDeviceListName)) {
            int n4 = QTObjectManagement.pullIDFromName(string);
            if (n4 != 0) {
                n2 = QTObjectManagement.SGDisposeDeviceList(n4, n);
            }
        } else if (string.startsWith(spriteWorldName)) {
            QTObjectManagement.DisposeSpriteWorld(n);
        } else if (string.startsWith(streamName)) {
            n2 = QTObjectManagement.QTSDisposeStream(n, 0);
        } else if (string.startsWith(timeBaseName)) {
            QTObjectManagement.DisposeTimeBase(n);
        } else if (string.startsWith(trackEditStateName)) {
            n2 = QTObjectManagement.DisposeTrackEditState(n);
        } else if (string.startsWith(userDataName)) {
            n2 = QTObjectManagement.DisposeUserData(n);
        }
        QTException.checkError(n2);
    }

    private static native short QTDisposeAtomContainer(int var0);

    private static native void DisposeCTable(int var0);

    private static native void DisposeHandle(int var0);

    private static native void DisposeRgn(int var0);

    private static native short DisposeCodecNameList(int var0);

    private static native void DisposeMatte(int var0);

    private static native void DisposePtr(int var0);

    private static native short DisposeMovieEditState(int var0);

    private static native void DisposeTimeBase(int var0);

    private static native short DisposeTrackEditState(int var0);

    private static native short DisposeUserData(int var0);

    private static native void DisposeMovieController(int var0);

    private static native void DisposeMovie(int var0);

    private static native short CloseComponent(int var0);

    private static native short CDSequenceEnd(int var0);

    private static native void DisposeSpriteWorld(int var0);

    private static native void KillPicture(int var0);

    private static native void KillPoly(int var0);

    private static native void DisposeGWorld(int var0);

    private static native short SPBCloseDevice(int var0);

    private static native short SndDisposeChannel(int var0, byte var1);

    private static native int NADisposeNoteChannel(int var0, int var1);

    private static native int SGDisposeDeviceList(int var0, int var1);

    private static native short QTSDisposePresentation(int var0, int var1);

    private static native short QTSDisposeStream(int var0, int var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$QTObjectManagement == null ? (class$quicktime$QTObjectManagement = QTObjectManagement.class$("quicktime.QTObjectManagement")) : class$quicktime$QTObjectManagement);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
        addCount = 0;
        removeCount = 0;
        lock = false;
    }
}

