/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app;

import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.display.QTDrawable;
import quicktime.app.image.GraphicsImporterDrawer;
import quicktime.app.players.QTPlayer;
import quicktime.std.image.GraphicsImporter;
import quicktime.std.movies.Movie;
import quicktime.std.movies.MovieController;

public class QTDrawableMaker {
    public QTDrawable fromGraphicsImporter(GraphicsImporter graphicsImporter) throws QTException {
        return new GraphicsImporterDrawer(graphicsImporter);
    }

    public QTDrawable fromMovie(Movie movie) throws QTException {
        MovieController movieController = new MovieController(movie);
        movieController.setKeysEnabled(true);
        return new QTPlayer(movieController);
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

