/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.QTDrawableMaker;
import quicktime.app.display.QTDrawable;
import quicktime.io.OpenMovieFile;
import quicktime.io.QTFile;
import quicktime.std.StdQTException;
import quicktime.std.image.GraphicsImporter;
import quicktime.std.movies.Movie;
import quicktime.std.movies.Track;
import quicktime.std.movies.media.DataRef;
import quicktime.std.movies.media.Media;
import quicktime.std.qtcomponents.MovieImporter;
import quicktime.util.QTHandle;
import quicktime.util.QTUtils;

public final class QTFactory {
    private static Vector classPaths;
    private static final boolean debug = false;

    private static void buildClassPathsVector() throws IOException {
        classPaths = new Vector(8);
        String string = System.getProperty("java.class.path");
        while (string != null) {
            int n = string.indexOf(File.pathSeparatorChar);
            String string2 = null;
            if (n == -1) {
                string2 = string;
                string = null;
            } else {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
            }
            if ((string2 = QTFactory.returnExistingFile(string2)) == null || classPaths.contains(string2 = string2.substring(0, string2.lastIndexOf(File.separatorChar) + 1)) || string2.length() <= 0) continue;
            classPaths.addElement(string2);
        }
        String string3 = System.getProperty("user.dir");
        if ((string3 = QTFactory.returnExistingFile(string3)) != null) {
            classPaths.addElement(string3);
        }
    }

    private static String returnExistingFile(String string) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        if (file.isDirectory() && string.charAt(string.length() - 1) != File.separatorChar) {
            return string + File.separatorChar;
        }
        return file.getCanonicalPath();
    }

    public static File findInSystemPaths(String string) throws IOException {
        if (classPaths == null) {
            QTFactory.buildClassPathsVector();
        }
        return QTFactory._doFISP(string, false);
    }

    private static File _doFISP(String string, boolean bl) throws IOException {
        String string2 = string;
        int n = string2.length();
        while (n > 0) {
            String string3 = (n = string2.substring(0, n).lastIndexOf(47)) == -1 || n == 0 ? string2 : string2.substring(n + 1);
            for (int i = classPaths.size() - 1; i >= 0; --i) {
                String string4 = (String)classPaths.elementAt(i);
                String string5 = QTFactory.returnExistingFile(string4 + string3);
                if (string5 == null) continue;
                return new File(string5);
            }
        }
        throw new FileNotFoundException(string);
    }

    public static void addDirectory(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException(file + ",does not exist");
        }
        if (!file.isDirectory()) {
            throw new IOException(file + ",must be a directory");
        }
        if (classPaths == null) {
            QTFactory.buildClassPathsVector();
        }
        String string = file.getCanonicalPath();
        if ((string = string.replace('/', File.separatorChar)).charAt(string.length() - 1) != '/') {
            string = string + "/";
        }
        if (classPaths.contains(string)) {
            return;
        }
        classPaths.addElement(string);
    }

    public static void removeDirectory(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        if (classPaths == null) {
            return;
        }
        String string = file.getCanonicalPath();
        if ((string = string.replace('/', File.separatorChar)).charAt(string.length() - 1) != '/') {
            string = string + "/";
        }
        classPaths.removeElement(string);
    }

    public static File findAbsolutePath(String string) throws IOException {
        string = string.replace('/', File.separatorChar);
        if (classPaths == null) {
            QTFactory.buildClassPathsVector();
        }
        Enumeration enumeration = classPaths.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = QTFactory.returnExistingFile(string2 + string);
            if (string3 == null) continue;
            return new File(string3);
        }
        throw new FileNotFoundException(string);
    }

    public static QTDrawable makeDrawable(QTFile qTFile) throws IOException, QTException {
        return QTFactory.makeDrawable(qTFile, new QTDrawableMaker());
    }

    public static QTDrawable makeDrawable(QTFile qTFile, QTDrawableMaker qTDrawableMaker) throws IOException, QTException {
        QTObject qTObject;
        Movie movie;
        if (!qTFile.exists()) {
            throw new FileNotFoundException(qTFile.getName());
        }
        String string = QTFactory.getFileExtension(qTFile.getAbsolutePath());
        if (("mid".equalsIgnoreCase(string) || "smf".equalsIgnoreCase(string) || "midi".equalsIgnoreCase(string) || "kar".equalsIgnoreCase(string)) && (movie = QTFactory.importMovie(qTObject = QTFactory.readBytesIntoHandle(new FileInputStream(qTFile)), QTUtils.toOSType("Midi"))) != null) {
            return qTDrawableMaker.fromMovie(movie);
        }
        qTObject = QTFactory.openAsImage(qTFile);
        movie = null;
        if (qTObject != null) {
            movie = QTFactory.checkIfMovie(qTFile);
            if (movie == null) {
                return qTDrawableMaker.fromGraphicsImporter((GraphicsImporter)qTObject);
            }
            return qTDrawableMaker.fromMovie(movie);
        }
        movie = QTFactory.openAsMovie(qTFile);
        if (movie != null) {
            return qTDrawableMaker.fromMovie(movie);
        }
        throw new QTException(-2003);
    }

    public static QTDrawable makeDrawable(InputStream inputStream, int n, String string) throws IOException, QTException {
        return QTFactory.makeDrawable(inputStream, n, string, new QTDrawableMaker());
    }

    public static QTDrawable makeDrawable(InputStream inputStream, int n, String string, QTDrawableMaker qTDrawableMaker) throws IOException, QTException {
        QTObject qTObject;
        QTHandle qTHandle = QTFactory.readBytesIntoHandle(inputStream);
        DataRef dataRef = new DataRef(qTHandle, n, string);
        if (string != null && ("mid".equalsIgnoreCase(string) || "smf".equalsIgnoreCase(string) || "midi".equalsIgnoreCase(string) || "kar".equalsIgnoreCase(string)) && (qTObject = QTFactory.importMovie(qTHandle, QTUtils.toOSType("Midi"))) != null) {
            return qTDrawableMaker.fromMovie((Movie)qTObject);
        }
        qTObject = QTFactory.importImage(dataRef);
        Movie movie = null;
        if (qTObject != null) {
            movie = QTFactory.checkIfMovie(dataRef);
            if (movie == null) {
                return qTDrawableMaker.fromGraphicsImporter((GraphicsImporter)qTObject);
            }
            return qTDrawableMaker.fromMovie(movie);
        }
        movie = QTFactory.openAsMovie(dataRef);
        if (movie != null) {
            return qTDrawableMaker.fromMovie(movie);
        }
        throw new QTException(-2003);
    }

    public static QTDrawable makeDrawable(String string) throws QTException {
        return QTFactory.makeDrawable(string, new QTDrawableMaker());
    }

    public static QTDrawable makeDrawable(String string, QTDrawableMaker qTDrawableMaker) throws QTException {
        if (string.startsWith("file:")) {
            string = string.substring(5);
            while (string.charAt(0) == '/' && string.charAt(1) == '/') {
                string = string.substring(1);
            }
            try {
                return QTFactory.makeDrawable(new QTFile(string), qTDrawableMaker);
            }
            catch (IOException iOException) {
                throw new QTException(-43);
            }
        }
        DataRef dataRef = new DataRef(string);
        GraphicsImporter graphicsImporter = QTFactory.importImage(dataRef);
        Movie movie = null;
        if (graphicsImporter != null) {
            movie = QTFactory.checkIfMovie(dataRef);
            if (movie == null) {
                return qTDrawableMaker.fromGraphicsImporter(graphicsImporter);
            }
            return qTDrawableMaker.fromMovie(movie);
        }
        movie = QTFactory.openAsMovie(dataRef);
        if (movie != null) {
            return qTDrawableMaker.fromMovie(movie);
        }
        throw new QTException(-2003);
    }

    private static String getFileExtension(String string) {
        int n = string.lastIndexOf(46);
        return n == -1 ? "" : string.substring(n + 1);
    }

    private static QTHandle readBytesIntoHandle(InputStream inputStream) throws IOException, QTException {
        byte[] byArray = new byte[inputStream.available()];
        int n = inputStream.read(byArray);
        if (n < 0 || n != byArray.length) {
            throw new IOException("Problem in reading bytes from InputStream");
        }
        return new QTHandle(byArray);
    }

    private static GraphicsImporter openAsImage(QTFile qTFile) throws QTException {
        try {
            return new GraphicsImporter(qTFile);
        }
        catch (StdQTException stdQTException) {
            return null;
        }
    }

    private static GraphicsImporter openAsImage(DataRef dataRef) throws QTException {
        try {
            return new GraphicsImporter(dataRef);
        }
        catch (StdQTException stdQTException) {
            return null;
        }
    }

    private static GraphicsImporter importImage(DataRef dataRef) throws QTException {
        try {
            GraphicsImporter graphicsImporter = new GraphicsImporter(dataRef);
            return graphicsImporter;
        }
        catch (QTException qTException) {
            return null;
        }
    }

    private static Movie checkIfMovie(QTFile qTFile) throws QTException {
        return QTFactory.checkMovie(Movie.fromFile(OpenMovieFile.asRead(qTFile), 0, null));
    }

    private static Movie checkIfMovie(DataRef dataRef) throws QTException {
        try {
            return QTFactory.checkMovie(Movie.fromDataRef(dataRef, 0));
        }
        catch (QTException qTException) {
            return null;
        }
    }

    private static Movie checkMovie(Movie movie) throws QTException {
        try {
            if (movie.getTrackCount() > 1) {
                return movie;
            }
            Track track = movie.getIndTrack(1);
            Media media = Media.getTrackMedia(track);
            if (media.getSampleCount() > 1) {
                movie.setActive(true);
                return movie;
            }
            media.disposeQTObject();
            track.disposeQTObject();
            movie.disposeQTObject();
        }
        catch (QTException qTException) {
            // empty catch block
        }
        return null;
    }

    private static Movie openAsMovie(QTFile qTFile) throws QTException {
        OpenMovieFile openMovieFile = OpenMovieFile.asRead(qTFile);
        try {
            return Movie.fromFile(openMovieFile);
        }
        catch (StdQTException stdQTException) {
            return null;
        }
    }

    private static Movie openAsMovie(DataRef dataRef) throws QTException {
        try {
            return Movie.fromDataRef(dataRef, 1);
        }
        catch (QTException qTException) {
            return null;
        }
    }

    private static Movie importMovie(QTHandle qTHandle, int n) throws QTException {
        if (n == 0) {
            throw new QTException(-2003);
        }
        try {
            MovieImporter movieImporter = new MovieImporter(n);
            Movie movie = new Movie(1);
            movie.setDefaultDataRef(new DataRef(new QTHandle()));
            movieImporter.fromHandle(qTHandle, movie, null, 0, 1);
            return movie;
        }
        catch (QTException qTException) {
            return null;
        }
    }

    private QTFactory() {
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

