/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.actions;

import java.awt.event.MouseEvent;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.actions.MouseController;

public abstract class MouseResponder {
    public static final int kNoModifiersMask = 0;
    public static final int kAnyModifiersMask = 0;
    public static final int kNoModifiers = -1;
    public static final int kAnyModifiers = -2;
    public static final int kAnyOneOfModifiers = -3;
    public static final int kModifiersDisregarded = -4;
    public static final int kModifiersExactMatch = -5;
    public static final int kSpecifiedModifiersOrNone = -6;
    public static final int kClickEvents = 1;
    public static final int kPressReleaseEvents = 2;
    public static final int kDragEvents = 4;
    public static final int kMoveEvents = 8;
    public static final int kEnterEvents = 16;
    public static final int kExitEvents = 32;
    public static final int kTargetMoveEvents = 64;
    public static final int kMouseEvents = 51;
    public static final int kMouseMotionEvents = 12;
    public static final int kQTMouseMotionEvents = 76;
    public static final int kRolloverEvents = 100;
    public static final int kMouseOrMouseMotionEvents = 63;
    public static final int kAnyMouseEvent = 127;
    private int activationEvent = 0;
    public int modifierKeyMask;
    public int modifierTestConditions;
    private int eventInterests = 0;
    MouseController controller;

    protected MouseResponder(int n, int n2, int n3) {
        this.modifierKeyMask = n;
        this.modifierTestConditions = n2;
        this.eventInterests = n3;
    }

    protected abstract void setTargetSpace(Object var1);

    public MouseController getMouseController() {
        return this.controller;
    }

    public boolean isInterested(int n) {
        return (this.eventInterests & n) != 0;
    }

    public boolean isInterested(int n, int n2) {
        return (this.eventInterests & n) != 0 && this.doModifiersTest(n2);
    }

    private boolean doModifiersTest(int n) {
        n &= 0xF;
        switch (this.modifierTestConditions) {
            case -6: {
                return n == 0 || n == this.modifierKeyMask;
            }
            case -3: {
                return (n & this.modifierKeyMask) != 0;
            }
            case -4: {
                return true;
            }
            case -2: {
                return n != 0;
            }
            case -1: {
                return n == 0;
            }
            case -5: {
                return n == this.modifierKeyMask;
            }
        }
        return false;
    }

    void activate(int n) {
        this.activationEvent = n;
    }

    protected abstract void setTarget(Object var1);

    protected abstract void removeTarget();

    public abstract boolean isAppropriate(Object var1);

    public int activationEventType() {
        return this.activationEvent;
    }

    public boolean isActive() {
        return this.activationEvent != 0;
    }

    protected void deactivate() {
        this.activationEvent = 0;
        this.removeTarget();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEnteredTarget(MouseEvent mouseEvent) {
    }

    public void mouseExitedTarget(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

