/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.actions;

import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.actions.Actionable;
import quicktime.app.time.Ticklish;

public abstract class PeriodicAction
implements Ticklish {
    private static final boolean doPrint = false;
    protected Actionable actor;
    protected boolean reschedule = true;
    private int lastTime;
    private int scale = 1;
    private int period = 1;
    private float multiplier;
    private int triggerCondition = 3;

    protected PeriodicAction(int n, int n2) {
        this.setScale(n);
        this.setPeriod(n2);
    }

    public void timeChanged(int n) throws QTException {
        this.lastTime = n;
    }

    public boolean tickle(float f, int n) throws QTException {
        if (this.period == 0) {
            this.lastTime = n;
            this.doAction(f, n);
            if (this.actor != null && this.constraintReached()) {
                this.actor.trigger();
            }
            return this.reschedule;
        }
        int n2 = (int)(this.multiplier / f);
        int n3 = this.lastTime + n2;
        if (n2 < 0 && n <= n3 && (this.triggerCondition | 2) != 0 || n2 > 0 && n >= n3 && (this.triggerCondition | 1) != 0) {
            this.lastTime = n;
            this.doAction(f, n);
            if (this.actor != null && this.constraintReached()) {
                this.actor.trigger();
            }
        }
        return this.reschedule;
    }

    protected abstract void doAction(float var1, int var2) throws QTException;

    protected abstract boolean constraintReached();

    public void setActionable(Actionable actionable) {
        this.actor = actionable;
    }

    public Actionable getActionable() {
        return this.actor;
    }

    public void setPeriod(int n) {
        this.period = n;
        this.doMultiplier();
    }

    public int getPeriod() {
        return this.period;
    }

    public void setScale(int n) {
        if (n < 1) {
            n = 1;
        }
        this.scale = n;
        this.doMultiplier();
    }

    public int getScale() {
        return this.scale;
    }

    public int getTriggerCondition() {
        return this.triggerCondition;
    }

    public void setTriggerCondition(int n) {
        this.triggerCondition = n;
    }

    public String toString() {
        return super.toString() + "[scale=" + this.getScale() + ",period=" + this.getPeriod() + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof PeriodicAction) {
            PeriodicAction periodicAction = (PeriodicAction)object;
            if (this.reschedule != periodicAction.reschedule || this.lastTime != periodicAction.lastTime || this.scale != periodicAction.scale || this.period != periodicAction.period || this.triggerCondition != periodicAction.triggerCondition) {
                return false;
            }
            return this == object;
        }
        return false;
    }

    private void doMultiplier() {
        this.multiplier = (float)this.period / (float)this.scale * 1000.0f;
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

