/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.audio;

import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.audio.MusicPart;
import quicktime.std.movies.media.MusicMediaHandler;
import quicktime.std.music.NoteChannel;
import quicktime.std.music.TunePlayer;

public class MusicPartControl
implements MusicPart {
    private TunePlayer tp;
    private boolean muted;
    private float vol;
    private int part;

    public MusicPartControl(MusicMediaHandler musicMediaHandler, int n) throws QTException {
        this.tp = musicMediaHandler.getIndexedTunePlayer(1);
        this.part = n;
        this.muted = this.getNoteChannel().getController(7) <= 0.0f;
        this.vol = this.getVolume();
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void setMuted(boolean bl) throws QTException {
        this.muted = bl;
        if (this.muted) {
            this.getNoteChannel().setController(7, 0.0f);
        } else {
            this.getNoteChannel().setController(7, this.vol * 128.0f);
        }
    }

    public void setVolume(float f) throws QTException {
        this.vol = f;
        this.getNoteChannel().setController(7, this.vol * 128.0f);
    }

    public float getVolume() throws QTException {
        return this.muted ? 0.0f : this.getNoteChannel().getController(7) / 128.0f;
    }

    public void setBalance(float f) throws QTException {
        if (f == 0.0f) {
            this.getNoteChannel().setController(10, f);
        } else {
            this.getNoteChannel().setController(10, f / 2.0f + 1.5f);
        }
    }

    public float getBalance() throws QTException {
        float f = this.getNoteChannel().getController(10);
        if (f == 0.0f) {
            return f;
        }
        return (f - 1.5f) * 2.0f;
    }

    public String getInstrumentName() throws QTException {
        return this.getNoteChannel().getNoteRequest().getToneDescription().getInstrumentName();
    }

    public void selectInstrument(String string) throws QTException {
        this.getNoteChannel().pickEditInstrument(string, 16);
    }

    public final NoteChannel getNoteChannel() throws QTException {
        return this.tp.getIndexedNoteChannel(this.part);
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

