/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.audio;

import java.util.Enumeration;
import java.util.Vector;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.audio.MusicPart;
import quicktime.app.time.Ticklish;
import quicktime.app.time.Timer;
import quicktime.std.clocks.TimeBase;
import quicktime.std.clocks.TimeCallBack;
import quicktime.std.music.NoteChannel;

public class NoteChannelControl
implements MusicPart {
    private NoteChannel channel;
    private boolean muted;
    private float vol;
    private Timer t;
    private Vector activeNotes = new Vector();

    public NoteChannelControl(int n) throws QTException {
        this(n, 1);
    }

    public NoteChannelControl(int n, int n2) throws QTException {
        this(new NoteChannel(n, n2));
    }

    public NoteChannelControl(NoteChannel noteChannel) throws QTException {
        this.channel = noteChannel;
        this.muted = this.channel.getController(7) <= 0.0f;
        this.vol = this.getVolume();
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void setMuted(boolean bl) throws QTException {
        this.muted = bl;
        if (this.muted) {
            this.channel.setController(7, 0.0f);
        } else {
            this.channel.setController(7, this.vol * 128.0f);
        }
    }

    public void setVolume(float f) throws QTException {
        this.vol = f;
        if (!this.muted) {
            this.channel.setController(7, this.vol * 128.0f);
        }
    }

    public float getVolume() throws QTException {
        return this.muted ? this.vol : this.channel.getController(7) / 128.0f;
    }

    public void setBalance(float f) throws QTException {
        if (f == 0.0f) {
            this.channel.setController(10, f);
        } else {
            this.channel.setController(10, f / 2.0f + 1.5f);
        }
    }

    public float getBalance() throws QTException {
        float f = this.channel.getController(10);
        if (f == 0.0f) {
            return f;
        }
        return (f - 1.5f) * 2.0f;
    }

    public void selectInstrument(String string) throws QTException {
        this.channel.pickEditInstrument(string, 16);
    }

    public String getInstrumentName() throws QTException {
        return this.channel.getNoteRequest().getToneDescription().getInstrumentName();
    }

    public final NoteChannel getNoteChannel() {
        return this.channel;
    }

    public void playNoteFor(float f, int n, int n2) throws QTException {
        if (this.t == null) {
            this.t = new Timer(1, 1, new TurnOffNotes());
            this.t.setTickling(false);
            this.t.setActive(true);
            this.t.setRate(1.0f);
        } else {
            this.t.setActive(true);
        }
        int n3 = this.t.getTimeBase().getTime(1000);
        this.channel.playNote(f, n);
        EndNote endNote = new EndNote(this.t.getTimeBase(), 1000, n3 + n2, 1, this.channel, f);
        endNote.callMeWhen();
        this.activeNotes.addElement(endNote);
    }

    protected final void finalize() throws Throwable {
        Enumeration enumeration = this.activeNotes.elements();
        while (enumeration.hasMoreElements()) {
            ((EndNote)enumeration.nextElement()).cancelAndCleanup();
        }
        this.activeNotes.removeAllElements();
        super.finalize();
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }

    class TurnOffNotes
    implements Ticklish {
        TurnOffNotes() {
        }

        public void timeChanged(int n) throws QTException {
            Enumeration enumeration = NoteChannelControl.this.activeNotes.elements();
            while (enumeration.hasMoreElements()) {
                ((EndNote)enumeration.nextElement()).execute();
            }
        }

        public boolean tickle(float f, int n) throws QTException {
            return false;
        }
    }

    class EndNote
    extends TimeCallBack {
        float note;
        NoteChannel nc;

        EndNote(TimeBase timeBase, int n, int n2, int n3, NoteChannel noteChannel, float f) throws QTException {
            super(timeBase, n, n2, n3);
            this.note = f;
            this.nc = noteChannel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void execute() {
            block12: {
                try {
                    this.nc.playNote(this.note, 0);
                    Object var3_1 = null;
                    NoteChannelControl.this.activeNotes.removeElement(this);
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    NoteChannelControl.this.activeNotes.removeElement(this);
                    if (NoteChannelControl.this.activeNotes.isEmpty()) {
                        try {
                            NoteChannelControl.this.t.setActive(false);
                        }
                        catch (QTException qTException) {
                            NoteChannelControl.this.t = null;
                        }
                    }
                    this.cancelAndCleanup();
                    throw throwable;
                }
                if (NoteChannelControl.this.activeNotes.isEmpty()) {
                    try {
                        NoteChannelControl.this.t.setActive(false);
                    }
                    catch (QTException qTException) {
                        NoteChannelControl.this.t = null;
                    }
                }
                this.cancelAndCleanup();
                {
                    break block12;
                    catch (QTException qTException) {
                        qTException.printStackTrace();
                        Object var3_2 = null;
                        NoteChannelControl.this.activeNotes.removeElement(this);
                        if (NoteChannelControl.this.activeNotes.isEmpty()) {
                            try {
                                NoteChannelControl.this.t.setActive(false);
                            }
                            catch (QTException qTException2) {
                                NoteChannelControl.this.t = null;
                            }
                        }
                        this.cancelAndCleanup();
                    }
                }
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof EndNote) {
                EndNote endNote = (EndNote)object;
                return this.value == endNote.value && this.note == endNote.note && this.nc.equals(endNote.nc);
            }
            return false;
        }
    }
}

