/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.display;

import java.awt.event.MouseEvent;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.actions.MouseController;
import quicktime.app.actions.MouseResponder;
import quicktime.app.display.GroupDrawable;
import quicktime.app.display.QTDrawable;
import quicktime.app.spaces.Space;
import quicktime.qd.Region;

public class GroupController
extends MouseController {
    private GroupDrawable group;
    private QTDrawable current;
    private boolean isActive = false;

    public GroupController(MouseResponder mouseResponder, boolean bl) {
        super(mouseResponder, bl);
    }

    public Space getSpace() {
        return this.group;
    }

    protected void setTargetSpace(Space space) {
        this.group = (GroupDrawable)space;
    }

    protected Object getSelected(MouseEvent mouseEvent) throws QTException {
        this.current = (QTDrawable)this.group.hitTest(mouseEvent.getX(), mouseEvent.getY());
        if (this.isWholespace() || this.hasMember(this.current)) {
            return this.current;
        }
        return null;
    }

    protected void deactivateResponder() {
        this.current = null;
        this.isActive = false;
        super.deactivateResponder();
    }

    protected void responderActivated() {
        this.isActive = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.isActive) {
            return;
        }
        try {
            GroupDrawable groupDrawable = this.group;
            synchronized (groupDrawable) {
                MouseResponder mouseResponder = this.getResponder();
                if (mouseResponder.isInterested(4) && mouseResponder.isActive()) {
                    QTDrawable qTDrawable = this.current;
                    this.doDragTarget(mouseEvent);
                    this.current = qTDrawable;
                    Region region = new Region(this.current.getDisplayBounds());
                    mouseResponder.mouseDragged(mouseEvent);
                    Region region2 = new Region(this.current.getDisplayBounds());
                    Region region3 = region.union(region2).diff(region2);
                    if (!region3.empty()) {
                        this.group.redrawMember(this.current, region3);
                    }
                    if (!this.group.hasMember(this.current)) {
                        this.deactivateResponder();
                    }
                }
            }
        }
        catch (QTException qTException) {
            QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this, "mouseDragged");
        }
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

