/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.display;

import java.awt.AWTEventMulticaster;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.MacDirectColorModel;
import java.awt.image.MemoryImageSource;
import javax.swing.JComponent;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.anim.Compositor;
import quicktime.app.anim.SWCompositor;
import quicktime.app.display.DrawingListener;
import quicktime.app.display.DrawingNotifier;
import quicktime.app.display.QTDrawable;
import quicktime.app.image.QTImageProducer;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.util.RawEncodedImage;

public class JQTCanvas
extends JComponent
implements DrawingListener {
    public static final int kIntegralResize = 1;
    public static final int kInitialSize = 2;
    public static final int kFreeResize = 3;
    public static final int kAspectResize = 4;
    public static final int kPerformanceResize = 5;
    public static final int kHorizontalResize = 6;
    public static final int kVerticalResize = 7;
    public static final int kInitialSizeNoResize = 8;
    public static boolean flashScaling;
    public static boolean useMacOSXAcceleration;
    transient QTDrawable client;
    int initialWidth = 0;
    int initialHeight = 0;
    int currentWidth;
    int currentHeight;
    private int currentX;
    private int currentY;
    private int resizeFlag;
    private transient boolean inited = false;
    private boolean debug = false;
    private boolean paintlock = false;
    DirectColorModel colorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, 0);
    public QTImageProducer ip;
    Image image;
    QDGraphics gw = null;
    QDRect gwBounds;
    int[] pixels;
    private ComponentListener clientListener;

    public JQTCanvas() {
        this(3, 0.0f, 0.0f);
    }

    public JQTCanvas(int n, float f, float f2) {
        this.resizeFlag = n;
        this.setAlignmentX(f);
        this.setAlignmentY(f2);
        this.initialWidth = 1;
        this.initialHeight = 1;
        this.setMinimumSize(new Dimension(1, 1));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
    }

    public void paint(Graphics graphics) {
        if (!this.inited && this.client != null) {
            this.client.addedTo(this);
            this.inited = true;
            super.paint(graphics);
            return;
        }
        if (this.image != null) {
            Dimension dimension = this.getSize();
            graphics.drawImage(this.image, 0, 0, dimension.width, dimension.height, this);
        }
    }

    public void setFlashScaling(boolean bl) {
        flashScaling = bl;
    }

    public boolean isFlashScaling() {
        return flashScaling;
    }

    Image imageFromEncodedImage(RawEncodedImage rawEncodedImage, QDRect qDRect) {
        rawEncodedImage.copyToArray(0, this.pixels, 0, this.pixels.length);
        MemoryImageSource memoryImageSource = new MemoryImageSource(qDRect.getWidth(), qDRect.getHeight(), (ColorModel)this.colorModel, this.pixels, 0, rawEncodedImage.getRowBytes() / 4);
        return this.getToolkit().createImage(memoryImageSource);
    }

    public void setClient(QTDrawable qTDrawable, boolean bl) throws QTException {
        this.doSetClient(qTDrawable, qTDrawable != null ? qTDrawable.getDisplayBounds() : null, this.getMinimumSize(), this.getMaximumSize(), bl);
    }

    public synchronized void setClient(QTDrawable qTDrawable, QDRect qDRect) throws QTException {
        this.doSetClient(qTDrawable, qDRect, this.getMinimumSize(), this.getMaximumSize(), true);
    }

    public final void removeClient() {
        if (this.client instanceof DrawingNotifier) {
            ((DrawingNotifier)((Object)this.client)).removeDrawingListener(this);
        }
        this.client.removedFrom(this);
        this.client = null;
        if (QTSession.isCurrentOS(4)) {
            this.gw = null;
        }
        this.image = null;
        this.repaint();
    }

    private void doSetClient(QTDrawable qTDrawable, QDRect qDRect, Dimension dimension, Dimension dimension2, boolean bl) throws QTException {
        if (qTDrawable == this.client) {
            return;
        }
        if (this.client != null) {
            this.removeClient();
        }
        if (qTDrawable != null) {
            this.client = qTDrawable;
            if (bl) {
                this.setMinimumSize(dimension);
                this.setMaximumSize(dimension2);
                this.setPreferredSize(new Dimension(qDRect.getWidth(), qDRect.getHeight()));
                this.initialWidth = qDRect.getWidth();
                this.initialHeight = qDRect.getHeight();
                this.currentX = qDRect.getX();
                this.currentY = qDRect.getY();
                this.currentWidth = this.initialWidth;
                this.currentHeight = this.initialHeight;
                this.doParentLayout();
            }
            if (qTDrawable instanceof SWCompositor || qTDrawable instanceof Compositor) {
                SWCompositor sWCompositor = (SWCompositor)qTDrawable;
                this.gwBounds = sWCompositor.getDisplayBounds();
                this.gw = sWCompositor.getGWorld();
                if (this.gw == null) {
                    this.gw = new QDGraphics(this.gwBounds);
                    sWCompositor.setGWorld(this.gw);
                }
                if (QTSession.isCurrentOS(4) && useMacOSXAcceleration) {
                    boolean bl2 = false;
                    this.image = MacDirectColorModel.GetWrappedGWorldImage((int)QTObject.ID(this.gw), (int)32, (int)this.gwBounds.getWidth(), (int)this.gwBounds.getHeight(), (boolean)bl2);
                } else {
                    this.pixels = new int[((RawEncodedImage)sWCompositor.getImage()).getRowBytes() / 4 * qDRect.getHeight()];
                    this.image = this.imageFromEncodedImage((RawEncodedImage)sWCompositor.getImage(), sWCompositor.getDescription().getBounds());
                }
                this.prepareImage(this.image, this);
                sWCompositor.addDrawingListener(this);
            } else {
                qTDrawable.redraw(null);
                this.ip = new QTImageProducer(this.client, new Dimension(qDRect.getWidth(), qDRect.getHeight()));
                this.image = this.createImage(this.ip);
                this.prepareImage(this.image, this);
            }
            if (qTDrawable instanceof DrawingNotifier) {
                ((DrawingNotifier)((Object)qTDrawable)).addDrawingListener(this);
            }
        }
        this.repaint();
    }

    public Image createImage(ImageProducer imageProducer) {
        if (QTSession.isCurrentOS(4) && useMacOSXAcceleration) {
            QDGraphics qDGraphics;
            boolean bl = false;
            QTImageProducer qTImageProducer = (QTImageProducer)imageProducer;
            Dimension dimension = qTImageProducer.getSize();
            this.gw = qDGraphics = qTImageProducer.getGWorld();
            BufferedImage bufferedImage = MacDirectColorModel.GetWrappedGWorldImage((int)QTObject.ID(qDGraphics), (int)32, (int)dimension.width, (int)dimension.height, (boolean)bl);
            return bufferedImage;
        }
        return super.createImage(imageProducer);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (this.debug) {
            System.out.println("setBounds( " + n + ", " + n2 + ", " + n3 + ", " + n4 + ")");
        }
        Dimension dimension = this.setCurrentWidthHeight(n3, n4);
        if (flashScaling) {
            this.setPreferredSize(dimension);
            this.initialWidth = n3;
            this.initialHeight = n4;
            try {
                if (this.client instanceof SWCompositor || this.client instanceof Compositor) {
                    SWCompositor sWCompositor = (SWCompositor)this.client;
                    this.gwBounds = new QDRect(this.getX(), this.getY(), n3, n4);
                    this.gw = new QDGraphics(this.gwBounds);
                    sWCompositor.setGWorld(this.gw);
                    if (QTSession.isCurrentOS(4) && useMacOSXAcceleration) {
                        n6 = 0;
                        this.image = MacDirectColorModel.GetWrappedGWorldImage((int)QTObject.ID(this.gw), (int)32, (int)this.gwBounds.getWidth(), (int)this.gwBounds.getHeight(), n6 != 0);
                    } else {
                        this.pixels = new int[((RawEncodedImage)sWCompositor.getImage()).getRowBytes() / 4 * this.gwBounds.getHeight()];
                        this.image = this.imageFromEncodedImage((RawEncodedImage)sWCompositor.getImage(), this.gwBounds);
                    }
                    this.prepareImage(this.image, this);
                } else {
                    this.client.redraw(null);
                    this.ip = new QTImageProducer(this.client, dimension);
                    this.image = this.createImage(this.ip);
                    this.prepareImage(this.image, this);
                }
            }
            catch (QTException qTException) {
                qTException.printStackTrace();
            }
            this.repaint();
        }
        if ((n5 = n3 - this.currentWidth) < 0) {
            n5 = 0;
        }
        if ((n6 = n4 - this.currentHeight) < 0) {
            n6 = 0;
        }
        this.currentX = n + (int)(this.getAlignmentX() * (float)n5);
        this.currentY = n2 + (int)(this.getAlignmentY() * (float)n6);
        if (this.debug) {
            System.out.println("setBounds(" + n + ", " + n2 + ", " + n3 + ", " + n4 + ")");
            System.out.println("Alignment x: " + this.getAlignmentX() + ", y: " + this.getAlignmentY());
            System.out.println("widthDiff: " + n5);
            System.out.println("heightDiff: " + n6);
            System.out.println("currentX:" + this.currentX);
            System.out.println("currentY:" + this.currentY);
        }
        super.reshape(this.currentX, this.currentY, dimension.width, dimension.height);
    }

    public void setBounds(Rectangle rectangle) {
        if (this.debug) {
            System.out.println("setBounds( " + rectangle + ")");
        }
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setSize(Dimension dimension) {
        if (this.debug) {
            System.out.println("setSize( " + dimension + ")");
        }
        this.setSize(dimension.width, dimension.height);
    }

    public void setSize(int n, int n2) {
        if (this.debug) {
            System.out.println("setSize( " + n + ", " + n2 + ")");
        }
        this.setBounds(this.currentX, this.currentY, n, n2);
    }

    public final void reshape(int n, int n2, int n3, int n4) {
        if (this.debug) {
            System.out.println("reshape( " + n + ", " + n2 + ", " + n3 + ", " + n4 + ")");
        }
        this.setBounds(n, n2, n3, n4);
    }

    private final void doParentLayout() {
        Container container;
        if (this.debug) {
            System.out.println("doParentLayout()");
        }
        if ((container = this.getParent()) != null) {
            this.invalidate();
            container.validate();
            return;
        }
        super.reshape(this.currentX, this.currentY, this.getWidth(), this.getHeight());
    }

    private Dimension setCurrentWidthHeight(int n, int n2) {
        if (this.debug) {
            System.out.println("setCurrentWidthHeight( " + n + ", " + n2 + "), flag " + this.getResizeFlag());
        }
        Dimension dimension = this.getMinimumSize();
        Dimension dimension2 = this.getMaximumSize();
        int n3 = dimension.width;
        int n4 = dimension.height;
        int n5 = dimension2.width;
        int n6 = dimension2.height;
        switch (this.getResizeFlag()) {
            case 2: {
                this.currentWidth = this.initialWidth;
                this.currentHeight = this.initialHeight;
                if (this.currentWidth < n3) {
                    this.currentWidth = n3;
                } else if (this.currentWidth > n5) {
                    this.currentWidth = n5;
                }
                if (this.currentHeight < n4) {
                    this.currentHeight = n4;
                } else if (this.currentHeight > n6) {
                    this.currentHeight = n6;
                }
                if (this.currentWidth <= n && this.currentHeight <= n2) break;
                Dimension dimension3 = this.getAspectSize(n, n2);
                this.currentWidth = dimension3.width;
                this.currentHeight = dimension3.height;
                break;
            }
            case 4: {
                Dimension dimension4 = this.getAspectSize(n, n2);
                this.currentWidth = dimension4.width;
                this.currentHeight = dimension4.height;
                break;
            }
            case 6: {
                this.currentWidth = n;
                this.currentHeight = this.initialHeight;
                if (this.currentWidth < n3) {
                    this.currentWidth = n3;
                } else if (this.currentWidth > n5) {
                    this.currentWidth = n5;
                }
                if (this.currentHeight < n4) {
                    this.currentHeight = n4;
                } else if (this.currentHeight > n6) {
                    this.currentHeight = n6;
                }
                if (this.currentHeight <= n2) break;
                Dimension dimension5 = this.getAspectSize(n, n2);
                this.currentHeight = dimension5.height;
                break;
            }
            case 7: {
                this.currentWidth = this.initialWidth;
                this.currentHeight = n2;
                if (this.currentWidth < n3) {
                    this.currentWidth = n3;
                } else if (this.currentWidth > n5) {
                    this.currentWidth = n5;
                }
                if (this.currentHeight < n4) {
                    this.currentHeight = n4;
                } else if (this.currentHeight > n6) {
                    this.currentHeight = n6;
                }
                if (this.currentWidth <= n) break;
                Dimension dimension6 = this.getAspectSize(n, n2);
                this.currentWidth = dimension6.width;
                break;
            }
            case 5: {
                if (n < n3) {
                    n = n3;
                } else if (n > n5) {
                    n = n5;
                }
                if (n2 < n4) {
                    n2 = n4;
                } else if (n2 > n6) {
                    n2 = n6;
                }
                boolean bl = false;
                int n7 = 2;
                while (!bl) {
                    boolean bl2;
                    int n8;
                    int n9;
                    if (n < this.initialWidth || n2 < this.initialHeight) {
                        n9 = this.initialWidth / n7;
                        n8 = this.initialHeight / n7;
                        if (n9 <= n && n8 <= n2) {
                            bl = true;
                            bl2 = false;
                            this.currentWidth = n9;
                            this.currentHeight = n8;
                            while (bl2) {
                                if (this.currentWidth >= n3 && this.currentHeight >= n4) {
                                    bl2 = true;
                                }
                                this.currentWidth *= 2;
                                this.currentHeight *= 2;
                            }
                        }
                    } else {
                        n9 = this.initialWidth * n7;
                        n8 = this.initialHeight * n7;
                        if (n9 >= n || n8 >= n2) {
                            bl = true;
                            if (n9 > n || n8 > n2) {
                                n9 /= 2;
                                n8 /= 2;
                            }
                            bl2 = false;
                            this.currentWidth = n9;
                            this.currentHeight = n8;
                            while (bl2) {
                                if (this.currentWidth <= n5 && this.currentHeight <= n6) {
                                    bl2 = true;
                                }
                                this.currentWidth /= 2;
                                this.currentHeight /= 2;
                            }
                        }
                    }
                    n7 *= 2;
                }
                break;
            }
            case 1: {
                if (n < n3) {
                    n = n3;
                } else if (n > n5) {
                    n = n5;
                }
                if (n2 < n4) {
                    n2 = n4;
                } else if (n2 > n6) {
                    n2 = n6;
                }
                int n10 = this.initialWidth == 0 ? 0 : n / this.initialWidth;
                int n11 = this.initialHeight == 0 ? 0 : n2 / this.initialHeight;
                int n12 = Math.min(n10, n11);
                if (n12 < 1) {
                    float f = this.initialWidth == 0 ? 0.0f : (float)n / (float)this.initialWidth;
                    float f2 = this.initialHeight == 0 ? 0.0f : (float)n2 / (float)this.initialHeight;
                    n12 = 0;
                    n12 = f <= f2 ? this.initialWidth / n + 1 : this.initialHeight / n2 + 1;
                    this.currentWidth = (int)((float)this.initialWidth * 1.0f / (float)n12);
                    this.currentHeight = (int)((float)this.initialHeight * 1.0f / (float)n12);
                    break;
                }
                this.currentWidth = this.initialWidth * n12;
                this.currentHeight = this.initialHeight * n12;
                break;
            }
            case 8: {
                this.currentWidth = this.initialWidth;
                this.currentHeight = this.initialHeight;
                if (this.currentWidth < n3) {
                    this.currentWidth = n3;
                } else if (this.currentWidth > n5) {
                    this.currentWidth = n5;
                }
                if (this.currentHeight < n4) {
                    this.currentHeight = n4;
                    break;
                }
                if (this.currentHeight <= n6) break;
                this.currentHeight = n6;
                break;
            }
            default: {
                if (n < n3) {
                    n = n3;
                } else if (n > n5) {
                    n = n5;
                }
                if (n2 < n4) {
                    n2 = n4;
                } else if (n2 > n6) {
                    n2 = n6;
                }
                this.currentWidth = n;
                this.currentHeight = n2;
            }
        }
        return new Dimension(this.currentWidth, this.currentHeight);
    }

    private Dimension getAspectSize(int n, int n2) {
        int n3;
        int n4;
        Dimension dimension = this.getMinimumSize();
        Dimension dimension2 = this.getMaximumSize();
        int n5 = dimension.width;
        int n6 = dimension.height;
        int n7 = dimension2.width;
        int n8 = dimension2.height;
        if (n < n5) {
            n = n5;
        } else if (n > n7) {
            n = n7;
        }
        if (n2 < n6) {
            n2 = n6;
        } else if (n2 > n8) {
            n2 = n8;
        }
        float f = (float)n / (float)(this.initialWidth < 1 ? 1 : this.initialWidth);
        float f2 = (float)n2 / (float)(this.initialHeight < 1 ? 1 : this.initialHeight);
        if (f < f2) {
            n4 = (int)((float)this.initialWidth * f);
            n3 = (int)((float)this.initialHeight * f);
        } else {
            n4 = (int)((float)this.initialWidth * f2);
            n3 = (int)((float)this.initialHeight * f2);
        }
        return new Dimension(n4, n3);
    }

    public void setAlignment(float f, float f2) {
        this.setAlignmentX(f);
        this.setAlignmentY(f2);
    }

    public void setResizeFlag(int n) {
        this.resizeFlag = n;
        Rectangle rectangle = this.getBounds();
        this.doParentLayout();
    }

    public int getResizeFlag() {
        return this.resizeFlag;
    }

    public void drawingComplete(QTDrawable qTDrawable) {
        if (qTDrawable instanceof SWCompositor || qTDrawable instanceof Compositor) {
            try {
                if (QTSession.isCurrentOS(4) && useMacOSXAcceleration) {
                    boolean bl = false;
                    this.image = MacDirectColorModel.GetWrappedGWorldImage((int)QTObject.ID(this.gw), (int)32, (int)this.gwBounds.getWidth(), (int)this.gwBounds.getHeight(), (boolean)bl);
                } else {
                    this.image = this.imageFromEncodedImage((RawEncodedImage)((SWCompositor)qTDrawable).getImage(), ((SWCompositor)qTDrawable).getDescription().getBounds());
                }
            }
            catch (QTException qTException) {
                qTException.printStackTrace();
            }
            this.repaint();
        } else {
            if (QTSession.isCurrentOS(4) && useMacOSXAcceleration) {
                this.repaint();
                return;
            }
            try {
                this.ip.updateConsumers(null);
            }
            catch (QTException qTException) {
                qTException.printStackTrace();
            }
        }
    }

    public void addQTClientListener(ComponentListener componentListener) {
        this.clientListener = AWTEventMulticaster.add(this.clientListener, componentListener);
    }

    public void removeQTClientListener(ComponentListener componentListener) {
        this.clientListener = AWTEventMulticaster.remove(this.clientListener, componentListener);
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
        flashScaling = false;
        useMacOSXAcceleration = true;
    }
}

