/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.event;

import java.util.EventObject;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.qd.QDPoint;

public class QTMouseEvent
extends EventObject {
    public static final int kMouseClick = 500;
    public static final int kMousePressed = 501;
    public static final int kMouseReleased = 502;
    public static final int kMouseMoved = 503;
    public static final int kMouseEntered = 504;
    public static final int kMouseExited = 505;
    public static final int kMouseDragged = 506;
    public static final int kMouseTargetEnter = 507;
    public static final int kMouseTargetExit = 508;
    int modifiers;
    int x;
    int y;
    int eventType;
    int clickCount;
    long when;
    Object target;
    private QDPoint cacheLocationPt;
    private boolean consumed = false;

    public QTMouseEvent(Object object) {
        super(object);
    }

    public QTMouseEvent(Object object, int n, int n2, int n3, long l, int n4, int n5) {
        super(object);
        this.eventType = n;
        this.modifiers = n4;
        this.x = n2;
        this.y = n3;
        this.when = l;
        this.clickCount = n5;
    }

    private QTMouseEvent(Object object, int n, int n2, int n3, long l, int n4, int n5, boolean bl) {
        super(object);
    }

    public QDPoint getLocation() {
        this.cacheLocationPt.setX(this.x);
        this.cacheLocationPt.setY(this.y);
        return this.cacheLocationPt;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object object) {
        this.target = object;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public long getWhen() {
        return this.when;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public int getEventType() {
        return this.eventType;
    }

    void setEventType(int n) {
        this.eventType = n;
    }

    public synchronized void translate(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public synchronized void initialiseEventProfile(int n, int n2, int n3, long l, int n4, int n5) {
        this.eventType = n;
        this.modifiers = n4;
        this.x = n2;
        this.y = n3;
        this.when = l;
        this.clickCount = n5;
        this.consumed = false;
        this.target = null;
    }

    public void consume() {
        this.consumed = true;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public String toString() {
        String string = null;
        switch (this.eventType) {
            case 500: {
                string = "click";
                break;
            }
            case 501: {
                string = "pressed";
                break;
            }
            case 502: {
                string = "released";
                break;
            }
            case 503: {
                string = "moved";
                break;
            }
            case 506: {
                string = "dragged";
                break;
            }
            case 507: {
                string = "targetEnter";
                break;
            }
            case 508: {
                string = "targetExit";
                break;
            }
            case 504: {
                string = "entered";
                break;
            }
            case 505: {
                string = "exited";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        String string2 = "";
        if (this.target != null) {
            string2 = ",target=" + this.target;
        }
        return this.getClass().getName() + "[eventType=" + string + ",(" + this.x + "," + this.y + ")" + ",mods=" + this.modifiers + ",when=" + this.when + ",clicks=" + this.clickCount + ",consumed=" + this.consumed + ",source=" + this.source + string2 + "]";
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

