/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.image;

import java.util.Vector;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.qd.ColorTable;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.std.image.CSequence;
import quicktime.std.image.CodecComponent;
import quicktime.std.image.CompressedFrameInfo;
import quicktime.std.image.ImageDescription;
import quicktime.util.RawEncodedImage;

public class CSequenceToMemory {
    private Vector frames;
    private CSequence seq;

    public CSequenceToMemory(int n) {
        this.frames = new Vector(n);
    }

    public CSequenceToMemory(QDGraphics qDGraphics, QDRect qDRect, int n, int n2, CodecComponent codecComponent, int n3, int n4, int n5, ColorTable colorTable, int n6) throws QTException {
        this.seq = new CSequence(qDGraphics, qDRect, n, n2, codecComponent, n3, n4, n5, colorTable, n6);
        this.frames = new Vector(16);
    }

    Vector getFrames() {
        return this.frames;
    }

    public void begin(QDGraphics qDGraphics, QDRect qDRect, int n, int n2, CodecComponent codecComponent, int n3, int n4, int n5, ColorTable colorTable, int n6) throws QTException {
        if (this.frames != null) {
            this.frames.removeAllElements();
        }
        this.seq = new CSequence(qDGraphics, qDRect, n, n2, codecComponent, n3, n4, n5, colorTable, n6);
    }

    public int compressFrame(QDGraphics qDGraphics, QDRect qDRect, int n) throws QTException {
        RawEncodedImage rawEncodedImage = new RawEncodedImage(this.seq.getMaxCompressionSize(qDGraphics), true);
        CompressedFrameInfo compressedFrameInfo = this.seq.compressFrame(qDGraphics, qDRect, n, rawEncodedImage);
        rawEncodedImage.setSize(compressedFrameInfo.getDataSize());
        try {
            int n2 = this.seq.getFrameNumber() - 1;
            if (n2 < this.frames.size()) {
                this.frames.setElementAt(rawEncodedImage, n2);
            } else if (n2 > this.frames.size()) {
                this.frames.setSize(n2);
                this.frames.setElementAt(rawEncodedImage, n2);
            } else {
                this.frames.addElement(rawEncodedImage);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new QTException(this.getClass().getName() + ": Unable to grow internal Vector object.");
        }
        return compressedFrameInfo.getSimilarity();
    }

    public ImageDescription getDescription() throws QTException {
        return this.seq.getDescription();
    }

    public CSequence getSequence() {
        return this.seq;
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

