/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.image;

import java.awt.Dimension;
import java.util.Vector;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.actions.Invalidator;
import quicktime.app.anim.SWCompositor;
import quicktime.app.anim.TwoDSprite;
import quicktime.app.display.QTDrawable;
import quicktime.app.image.CSequenceToMemory;
import quicktime.app.image.DynamicImage;
import quicktime.app.image.ImageDataSequence;
import quicktime.app.image.ImageSpec;
import quicktime.app.spaces.Sequencer;
import quicktime.qd.QDDimension;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.StdQTException;
import quicktime.std.image.CodecComponent;
import quicktime.std.image.DSequence;
import quicktime.std.image.GraphicsImporter;
import quicktime.std.image.GraphicsMode;
import quicktime.std.image.ImageDescription;
import quicktime.std.image.Matrix;
import quicktime.util.EncodedImage;
import quicktime.util.RawEncodedImage;

public class DSequenceFromMemory
extends Sequencer
implements QTDrawable,
DynamicImage {
    private DSequence seq;
    private Vector frames;
    private int initialNumElements;
    private int currentFrame = 1;
    private QDGraphics port = QDGraphics.scratch;
    private int mWidth;
    private int mHeight;
    private ImageDescription mDesc;
    private Matrix mat = new Matrix();
    private QDRect bnds;
    private Region clip = null;
    private GraphicsMode gMode;
    public int flags = 0;

    private static RawEncodedImage privateGetData(GraphicsImporter graphicsImporter) throws QTException {
        int n = graphicsImporter.getDataSize();
        RawEncodedImage rawEncodedImage = new RawEncodedImage(n, true);
        graphicsImporter.readData(rawEncodedImage, graphicsImporter.getDataOffset(), n);
        return rawEncodedImage;
    }

    public DSequenceFromMemory(GraphicsImporter graphicsImporter) throws QTException {
        this(DSequenceFromMemory.privateGetData(graphicsImporter), graphicsImporter.getImageDescription());
    }

    public DSequenceFromMemory(EncodedImage encodedImage, ImageDescription imageDescription) throws QTException {
        this.initialNumElements = 1;
        this.frames = new Vector(this.initialNumElements, this.initialNumElements);
        this.frames.addElement(encodedImage);
        this.mDesc = imageDescription;
        this.bnds = new QDRect(this.mDesc.getWidth(), this.mDesc.getHeight());
    }

    public DSequenceFromMemory(CSequenceToMemory cSequenceToMemory) throws QTException {
        this.mDesc = cSequenceToMemory.getDescription();
        this.frames = cSequenceToMemory.getFrames();
        this.bnds = new QDRect(this.mDesc.getWidth(), this.mDesc.getHeight());
    }

    public DSequenceFromMemory(ImageSpec imageSpec) throws QTException {
        if (imageSpec instanceof ImageDataSequence) {
            ImageDataSequence imageDataSequence = (ImageDataSequence)imageSpec;
            this.initialNumElements = imageDataSequence.size();
            this.frames = new Vector(this.initialNumElements, this.initialNumElements);
            for (int i = 1; i <= imageDataSequence.size(); ++i) {
                this.frames.addElement(imageDataSequence.getImage(i));
            }
            this.mDesc = imageDataSequence.getDescription();
            this.bnds = new QDRect(this.mDesc.getWidth(), this.mDesc.getHeight());
        } else {
            this.initialNumElements = 1;
            this.frames = new Vector();
            this.frames.addElement(imageSpec.getImage());
            this.mDesc = imageSpec.getDescription();
            this.bnds = new QDRect(this.mDesc.getWidth(), this.mDesc.getHeight());
        }
    }

    public void addedTo(Object object) {
    }

    public void removedFrom(Object object) {
    }

    public QDGraphics getGWorld() {
        return this.port;
    }

    public void setGWorld(QDGraphics qDGraphics) throws QTException {
        this.port = qDGraphics;
        if (!QDGraphics.scratch.equals(qDGraphics)) {
            this.seq = new DSequence(this.mDesc, this.port, null, this.getMatrix(), null, this.flags, 768, CodecComponent.bestSpeedCodec);
            if (this.gMode != null) {
                this.setGraphicsMode(this.gMode);
            }
            if (this.clip != null) {
                this.setClip(this.clip);
            }
        } else {
            this.seq = null;
        }
    }

    public void setMatrix(Matrix matrix) throws StdQTException {
        if (this.seq != null) {
            this.seq.setMatrix(matrix);
        }
        this.mat = matrix;
    }

    public Matrix getMatrix() throws StdQTException {
        return this.seq != null ? this.seq.getMatrix() : this.mat;
    }

    public Dimension getInitialSize() throws QTException {
        return new Dimension(this.mDesc.getWidth(), this.mDesc.getHeight());
    }

    public QDDimension getOriginalSize() throws QTException {
        return new QDDimension(this.mDesc.getWidth(), this.mDesc.getHeight());
    }

    public void setDisplayBounds(QDRect qDRect) throws StdQTException {
        Matrix matrix = new Matrix();
        matrix.setTx(qDRect.getX());
        matrix.setTy(qDRect.getY());
        matrix.setSx((float)qDRect.getWidth() / (float)this.mDesc.getWidth());
        matrix.setSy((float)qDRect.getHeight() / (float)this.mDesc.getHeight());
        this.mWidth = qDRect.getWidth();
        this.mHeight = qDRect.getHeight();
        if (this.seq != null) {
            this.seq.setMatrix(matrix);
        }
        this.bnds = qDRect;
    }

    public void setLocation(int n, int n2) throws QTException {
        this.bnds.setX(n);
        this.bnds.setY(n2);
        this.setDisplayBounds(this.bnds);
    }

    public QDRect getDisplayBounds() {
        return this.bnds;
    }

    public final synchronized void redraw(Region region) throws StdQTException {
        if (this.seq == null) {
            return;
        }
        if (region != null) {
            this.seq.setMask(region);
            this.drawCurrentFrame(this.flags);
            this.seq.setMask(this.clip);
        } else {
            this.drawCurrentFrame(this.flags);
        }
    }

    public Region getClip() throws StdQTException {
        return this.clip;
    }

    public void setClip(Region region) throws StdQTException {
        if (this.seq != null) {
            this.seq.setMask(region);
        }
        this.clip = region;
    }

    public ImageDescription getDescription() throws QTException {
        return this.mDesc;
    }

    public EncodedImage getImage() throws StdQTException {
        if (this.frames != null) {
            return (EncodedImage)this.frames.elementAt(this.getCurrentFrame() - 1);
        }
        return null;
    }

    public int size() {
        return this.frames != null ? this.frames.size() : 0;
    }

    public int drawCurrentFrame(int n) throws StdQTException {
        if (this.seq == null) {
            return 0;
        }
        EncodedImage encodedImage = this.getImage();
        return this.seq.decompressFrameS(encodedImage, n);
    }

    public void setGraphicsMode(GraphicsMode graphicsMode) throws QTException {
        if (this.seq != null) {
            this.seq.setGraphicsMode(graphicsMode);
        }
        this.gMode = graphicsMode;
    }

    public GraphicsMode getGraphicsMode() {
        return this.gMode;
    }

    public Invalidator addedToCompositor(SWCompositor sWCompositor, TwoDSprite twoDSprite) {
        return new SeqInvalidator(twoDSprite, this.getCurrentFrame());
    }

    public void removedFromCompositor(SWCompositor sWCompositor) {
    }

    public DSequence getSequence() {
        return this.seq;
    }

    public String toString() {
        return this.getClass().getName() + "[size=" + this.size() + "]";
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }

    class SeqInvalidator
    extends Invalidator {
        private int lastFrame;

        SeqInvalidator(TwoDSprite twoDSprite, int n) {
            super(twoDSprite);
            this.lastFrame = n;
        }

        public boolean tickle(float f, int n) throws QTException {
            if (this.lastFrame != DSequenceFromMemory.this.getCurrentFrame()) {
                DSequenceFromMemory.this.redraw(null);
                this.s.invalidate();
                this.lastFrame = DSequenceFromMemory.this.getCurrentFrame();
            }
            return true;
        }
    }
}

