/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.image;

import java.util.Enumeration;
import java.util.Vector;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.image.ImageSequencer;
import quicktime.app.image.ImageSpec;
import quicktime.app.spaces.Collection;
import quicktime.std.image.ImageDescription;
import quicktime.std.movies.Movie;
import quicktime.std.movies.Track;
import quicktime.std.movies.media.VideoMedia;
import quicktime.util.ByteEncodedImage;
import quicktime.util.EncodedImage;
import quicktime.util.IntEncodedImage;
import quicktime.util.QTHandle;
import quicktime.util.QTUtils;
import quicktime.util.RawEncodedImage;

public class ImageDataSequence
implements ImageSpec,
Collection {
    Vector imageDataVector;
    private ImageDescription imageDescription;

    public ImageDataSequence() {
        this(null);
    }

    public ImageDataSequence(ImageDescription imageDescription) {
        this(imageDescription, new Vector());
    }

    ImageDataSequence(ImageDescription imageDescription, Vector vector) {
        this.setDescription(imageDescription);
        this.imageDataVector = vector;
    }

    public ImageDescription getDescription() {
        return this.imageDescription;
    }

    public void setDescription(ImageDescription imageDescription) {
        this.imageDescription = imageDescription;
    }

    public EncodedImage getImage() {
        return this.getNth(1);
    }

    public EncodedImage getImage(int n) {
        return this.getNth(n);
    }

    public Enumeration members() {
        return this.imageDataVector.elements();
    }

    public ImageSequencer sequence() {
        return new ImageSequencer(this);
    }

    public boolean addMember(Object object) {
        if (!this.isAppropriate(object)) {
            return false;
        }
        this.append((EncodedImage)object);
        return true;
    }

    public void removeMember(Object object) {
        this.imageDataVector.removeElement(object);
    }

    public boolean isAppropriate(Object object) {
        return object instanceof EncodedImage;
    }

    public boolean hasMember(Object object) {
        return this.imageDataVector.contains(object);
    }

    public void insert(EncodedImage encodedImage, int n) {
        this.imageDataVector.insertElementAt(encodedImage, n - 1);
    }

    public void prepend(EncodedImage encodedImage) {
        this.insert(encodedImage, 1);
    }

    public void append(EncodedImage encodedImage) {
        this.insert(encodedImage, this.size() + 1);
    }

    public void remove(int n) {
        this.imageDataVector.removeElementAt(n - 1);
    }

    public void removeFirst() {
        this.remove(1);
    }

    public void removeLast() {
        this.remove(this.size() - 1);
    }

    public void removeAll() {
        this.imageDataVector.removeAllElements();
    }

    public int size() {
        return this.imageDataVector.size();
    }

    public EncodedImage getNth(int n) {
        return (EncodedImage)this.imageDataVector.elementAt(n - 1);
    }

    public boolean isEmpty() {
        return this.imageDataVector.isEmpty();
    }

    public void addToMovie(Movie movie, float f) throws QTException {
        int n;
        boolean bl = false;
        int n2 = 600;
        Track track = movie.addTrack(this.imageDescription.getWidth(), this.imageDescription.getHeight(), (float)bl);
        VideoMedia videoMedia = new VideoMedia(track, n2);
        videoMedia.beginEdits();
        for (n = 0; n < this.size(); ++n) {
            Object[] objectArray;
            EncodedImage encodedImage = this.getNth(n + 1);
            QTHandle qTHandle = null;
            if (encodedImage instanceof RawEncodedImage) {
                qTHandle = new QTHandle((RawEncodedImage)encodedImage, 0, encodedImage.getSize());
            } else if (encodedImage instanceof IntEncodedImage) {
                qTHandle = new QTHandle(encodedImage.getSize(), false);
                objectArray = ((IntEncodedImage)encodedImage).getInts();
                qTHandle.copyFromArray(0, (int[])objectArray, 0, objectArray.length);
            } else {
                qTHandle = new QTHandle(encodedImage.getSize(), false);
                objectArray = ((ByteEncodedImage)encodedImage).getBytes();
                qTHandle.copyFromArray(0, (byte[])objectArray, 0, objectArray.length);
            }
            videoMedia.addSample(qTHandle, 0, qTHandle.getSize(), (int)(600.0f / f), this.imageDescription, 1, 0);
            if (n % 5 != 0) continue;
            QTUtils.reclaimMemory();
        }
        videoMedia.endEdits();
        n = 0;
        int n3 = 0;
        boolean bl2 = true;
        track.insertMedia(n, n3, videoMedia.getDuration(), (float)bl2);
        QTUtils.reclaimMemory();
    }

    public String toString() {
        return this.getClass().getName() + "[size=" + this.size() + ",description=" + this.getDescription() + "]";
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

