/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.image;

import java.util.Vector;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.actions.Invalidator;
import quicktime.app.anim.SWCompositor;
import quicktime.app.anim.TwoDSprite;
import quicktime.app.display.DrawingListener;
import quicktime.app.display.DrawingNotifier;
import quicktime.app.image.DynamicImage;
import quicktime.app.image.ImagePresenter;
import quicktime.app.image.QTEffect;
import quicktime.app.image.QTTransition;
import quicktime.qd.PixMap;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.image.ImageDescription;

public class QTEffectPresenter
extends ImagePresenter
implements DynamicImage,
DrawingNotifier {
    private Vector listenerList = new Vector();
    private QDGraphics g;
    private QTEffect ef;
    TwoDSprite sprite;

    private static QDRect moveToZero(QDRect qDRect) {
        qDRect.move(0, 0);
        return qDRect;
    }

    public QTEffectPresenter(QTEffect qTEffect) throws QTException {
        this(qTEffect, new QDGraphics(32, qTEffect.getDisplayBounds(), 4096));
    }

    public QTEffectPresenter(QTEffect qTEffect, QDGraphics qDGraphics) throws QTException {
        super(QTEffectPresenter.moveToZero(qTEffect.getDisplayBounds()));
        this.ef = qTEffect;
        this.g = qDGraphics;
        qTEffect.setGWorld(qDGraphics);
        qTEffect.redraw(null);
        PixMap pixMap = qDGraphics.getPixMap();
        this.setImageData(pixMap.getPixelData(), new ImageDescription(pixMap));
        if (qTEffect instanceof QTTransition) {
            ((QTTransition)qTEffect).thePresenter = this;
        }
    }

    public void redraw(Region region) throws QTException {
        if (this.ef.isRedrawing()) {
            this.ef.redraw(region);
        }
        super.redraw(region);
    }

    public QTEffect getEffect() {
        return this.ef;
    }

    public void doTransition() throws QTException {
        if (this.ef instanceof QTTransition) {
            ((QTTransition)this.ef).doTransition();
        }
    }

    public Invalidator addedToCompositor(SWCompositor sWCompositor, TwoDSprite twoDSprite) {
        this.sprite = twoDSprite;
        return this.ef.isSingleFrame() ? null : new EFInvalidator(twoDSprite, this);
    }

    public void removedFromCompositor(SWCompositor sWCompositor) {
        this.sprite = null;
    }

    public synchronized void addDrawingListener(DrawingListener drawingListener) {
        if (this.listenerList.contains(drawingListener)) {
            return;
        }
        this.listenerList.addElement(drawingListener);
    }

    public synchronized void removeDrawingListener(DrawingListener drawingListener) {
        if (this.listenerList.contains(drawingListener)) {
            this.listenerList.removeElement(drawingListener);
        }
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }

    class EFInvalidator
    extends Invalidator {
        QTEffectPresenter pres;

        EFInvalidator(TwoDSprite twoDSprite, QTEffectPresenter qTEffectPresenter2) {
            super(twoDSprite);
            this.pres = qTEffectPresenter2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tickle(float f, int n) throws QTException {
            if (QTEffectPresenter.this.ef.isRedrawing()) {
                QTEffectPresenter.this.ef.redraw(null);
                QTEffectPresenter qTEffectPresenter = QTEffectPresenter.this;
                synchronized (qTEffectPresenter) {
                    for (int i = 0; i < QTEffectPresenter.this.listenerList.size(); ++i) {
                        ((DrawingListener)QTEffectPresenter.this.listenerList.elementAt(i)).drawingComplete(this.pres);
                    }
                }
                this.s.invalidate();
            }
            return true;
        }
    }
}

