/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.players;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.players.QTPlayer;
import quicktime.app.players.QTPlayerEventHandler;
import quicktime.qd.QDPoint;

public class QTPlayerAWTEventHandler
extends QTPlayerEventHandler
implements MouseListener,
KeyListener {
    private WindowAdapter wa;
    private Window parentWindow;
    protected QTPlayer player;
    protected Component component;

    protected QTPlayerAWTEventHandler(QTPlayer qTPlayer, Object object) {
        this.player = qTPlayer;
        this.component = (Component)object;
    }

    protected void addedTo() {
        Container container;
        this.component.addMouseListener(this);
        this.component.addKeyListener(this);
        Container container2 = container = this.component.getParent();
        while (container2 != null && !((container = container2) instanceof Window)) {
            container2 = container.getParent();
        }
        if (container instanceof Window) {
            this.parentWindow = (Window)container;
            this.wa = new WindowAdapter(){

                public void windowActivated(WindowEvent windowEvent) {
                    try {
                        QTPlayerAWTEventHandler.this.player.controller.activate(QTPlayerAWTEventHandler.this.player.getGWorld(), true);
                        QTPlayerAWTEventHandler.this.player.controller.activate();
                        QTPlayerAWTEventHandler.this.player.redraw(null);
                    }
                    catch (QTException qTException) {
                        // empty catch block
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void windowDeactivated(WindowEvent windowEvent) {
                    Object object = QTSession.terminationLock();
                    synchronized (object) {
                        if (QTSession.isInitialized()) {
                            try {
                                QTPlayerAWTEventHandler.this.player.controller.deactivate();
                                QTPlayerAWTEventHandler.this.player.controller.activate(QTPlayerAWTEventHandler.this.player.getGWorld(), false);
                                QTPlayerAWTEventHandler.this.player.redraw(null);
                            }
                            catch (QTException qTException) {}
                        } else {
                            QTPlayerAWTEventHandler.this.player.removedFrom(QTPlayerAWTEventHandler.this.component);
                        }
                    }
                }
            };
            this.parentWindow.addWindowListener(this.wa);
        }
    }

    protected void removedFrom() {
        this.component.removeMouseListener(this);
        this.component.removeKeyListener(this);
        if (this.parentWindow != null) {
            this.parentWindow.removeWindowListener(this.wa);
            this.parentWindow = null;
            this.wa = null;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        try {
            this.player.controller.key(keyEvent.getKeyCode(), keyEvent.getModifiers());
        }
        catch (QTException qTException) {
            QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this, "keyPressed");
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        try {
            this.player.controller.click(new QDPoint(mouseEvent.getX(), mouseEvent.getY()), mouseEvent.getModifiers());
        }
        catch (QTException qTException) {
            QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this, "mousePressed");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

