/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.sg;

import java.awt.Dimension;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.display.QTDrawable;
import quicktime.app.time.TaskThread;
import quicktime.app.time.Tasking;
import quicktime.qd.QDDimension;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.image.Matrix;
import quicktime.streaming.Presentation;

public class PresentationDrawer
extends Tasking
implements QTDrawable {
    private static TaskThread idleTasker;
    private Presentation pres;

    public PresentationDrawer(Presentation presentation) throws QTException {
        this.pres = presentation;
        this.setDefaultTasker(idleTasker);
    }

    public Presentation getPresentation() {
        return this.pres;
    }

    public void addedTo(Object object) {
    }

    public void removedFrom(Object object) {
    }

    public QDGraphics getGWorld() throws QTException {
        return this.pres.getGWorld();
    }

    public synchronized void setGWorld(QDGraphics qDGraphics) throws QTException {
        this.pres.setGWorld(qDGraphics);
    }

    public Dimension getInitialSize() throws QTException {
        QDDimension qDDimension = this.pres.getDimensions(null);
        Matrix matrix = this.pres.getMatrix(null);
        return new Dimension((int)((float)qDDimension.getWidth() / matrix.getSx()), (int)((float)qDDimension.getHeight() / matrix.getSy()));
    }

    public QDDimension getOriginalSize() throws QTException {
        QDDimension qDDimension = this.pres.getDimensions(null);
        Matrix matrix = this.pres.getMatrix(null);
        return new QDDimension((float)qDDimension.getWidth() / matrix.getSx(), (float)qDDimension.getHeight() / matrix.getSy());
    }

    public Matrix getMatrix() throws QTException {
        return this.pres.getMatrix(null);
    }

    public void setMatrix(Matrix matrix) throws QTException {
        this.pres.setMatrix(null, matrix);
    }

    public synchronized void setDisplayBounds(QDRect qDRect) throws QTException {
        QDRect qDRect2 = this.getDisplayBounds();
        Matrix matrix = new Matrix();
        matrix.setTx(qDRect.getX());
        matrix.setTy(qDRect.getY());
        matrix.setSx((float)qDRect.getWidth() / (float)qDRect2.getWidth());
        matrix.setSy((float)qDRect.getHeight() / (float)qDRect2.getHeight());
        this.setMatrix(matrix);
        this.pres.setDimensions(null, qDRect.getWidth(), qDRect.getHeight());
    }

    public void setLocation(int n, int n2) throws QTException {
        QDRect qDRect = this.getDisplayBounds();
        qDRect.setX(n);
        qDRect.setY(n2);
        this.setDisplayBounds(qDRect);
    }

    public QDRect getDisplayBounds() throws QTException {
        return new QDRect(this.pres.getDimensions(null));
    }

    public final synchronized void redraw(Region region) throws QTException {
        this.pres.invalidateRegion(region);
    }

    public Region getClip() throws QTException {
        return this.pres.getClip(null);
    }

    public void setClip(Region region) throws QTException {
        this.pres.setClip(null, region);
    }

    public final synchronized void task() throws QTException {
        this.pres.idle(null);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.pres + "]";
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
        idleTasker = new TaskThread("Default Pres Tasker", 20);
    }
}

