/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.time;

import quicktime.QTException;
import quicktime.app.time.Ticklish;
import quicktime.app.time.Timeable;
import quicktime.std.StdQTException;
import quicktime.std.clocks.RateCallBack;
import quicktime.std.clocks.TimeBase;
import quicktime.std.clocks.TimeCallBack;
import quicktime.std.clocks.TimeJumpCallBack;
import quicktime.std.clocks.TimeRecord;
import quicktime.std.movies.Movie;

public class Timer
implements Timeable {
    private static final boolean debug = false;
    private static int count = 1;
    private Movie m;
    TimeBase theTimeBase;
    private Ticklish target;
    private int whichOne;
    private boolean doesTickle = true;
    private boolean cbActive = false;
    private boolean isTimerTicking = false;
    private RC rc;
    private TC tc;
    private TJ tj;
    private float lastKnownRate;

    public Timer(int n, int n2) throws QTException {
        this(n, n2, null);
    }

    public Timer(int n, int n2, Ticklish ticklish) throws QTException {
        this(n, n2, ticklish, null);
    }

    public Timer(int n, int n2, Ticklish ticklish, Movie movie) throws QTException {
        if (n == 0) {
            throw new QTException("scale cannot be zero");
        }
        this.m = movie;
        if (this.m != null) {
            this.theTimeBase = this.m.getTimeBase();
            this.isTimerTicking = this.theTimeBase.getEffectiveRate() != 0.0f;
        } else {
            this.theTimeBase = new TimeBase();
            this.theTimeBase.setStartTime(new TimeRecord());
            TimeRecord timeRecord = new TimeRecord();
            timeRecord.setValue(86400L);
            timeRecord.setScale(1);
            this.theTimeBase.setStopTime(timeRecord);
            this.theTimeBase.setFlags(1);
        }
        this.tc = new TC(this.theTimeBase, n, Math.abs(n2), 0);
        this.tj = new TJ(this.theTimeBase);
        this.whichOne = count++;
        this.target = ticklish;
        this.rc = new RC(this.theTimeBase);
    }

    public boolean isTicking() {
        return this.isTimerTicking;
    }

    public boolean isTickling() {
        return this.doesTickle;
    }

    public void setTickling(boolean bl) throws StdQTException {
        this.doesTickle = bl;
        if (this.isActive()) {
            this.tc.cancel();
            if (this.doesTickle) {
                this.tc.value = this.theTimeBase.getTime(this.tc.scale) + this.tc.period;
                this.tc.flags = this.lastKnownRate > 0.0f ? 1 : 2;
                this.tc.callMeWhen();
            } else {
                this.tc.cancelAndCleanup();
            }
        }
    }

    public Ticklish getTicklish() {
        return this.target;
    }

    public final TimeBase getTimeBase() {
        return this.theTimeBase;
    }

    public synchronized void rescheduleTickle(int n, int n2) throws QTException {
        if (n == 0) {
            throw new QTException("scale cannot be zero");
        }
        this.tc.cancel();
        this.tc.scale = n;
        this.tc.period = n2;
        this.tc.value = this.theTimeBase.getTime(n);
        int n3 = this.tc.flags = this.lastKnownRate > 0.0f ? 1 : 2;
        if (this.cbActive) {
            this.tc.callMeWhen();
        }
        this.doesTickle = true;
    }

    public int getScale() {
        return this.tc.scale;
    }

    public int getPeriod() {
        return Math.abs(this.tc.period);
    }

    public float getRate() {
        return this.theTimeBase.getRate();
    }

    public void setRate(float f) {
        this.theTimeBase.setRate(f);
        this.isTimerTicking = f != 0.0f;
    }

    public synchronized void setActive(boolean bl) throws QTException {
        if (bl == this.cbActive) {
            return;
        }
        this.cbActive = bl;
        this.tc.cancel();
        this.tj.cancel();
        this.rc.cancel();
        if (this.cbActive) {
            this.lastKnownRate = this.theTimeBase.getEffectiveRate();
            this.rc.callMeWhen();
            this.tj.callMeWhen();
            boolean bl2 = this.isTimerTicking = this.lastKnownRate != 0.0f;
            if (this.lastKnownRate != 0.0f) {
                this.tc.period = Math.abs(this.tc.period);
                if (this.lastKnownRate < 0.0f) {
                    this.tc.period = -this.tc.period;
                }
                this.tc.value = this.theTimeBase.getTime(this.tc.scale);
                this.doTimeChanged(this.lastKnownRate, this.theTimeBase.getTime(1000));
            }
        } else {
            this.rc.cancelAndCleanup();
            this.tj.cancelAndCleanup();
            this.tc.cancelAndCleanup();
        }
    }

    public boolean isActive() {
        return this.cbActive;
    }

    public String toString() {
        return this.getClass().getName() + "[isActive=" + this.isActive() + ",whichOne=" + this.whichOne + ",rate=" + this.theTimeBase.getRate() + ",efRate=" + this.theTimeBase.getEffectiveRate() + ",scale=" + this.getScale() + "]";
    }

    protected void timeChanged(int n) throws QTException {
        if (this.target != null) {
            this.target.timeChanged(n);
        }
    }

    protected boolean tickle(float f, int n) throws QTException {
        if (this.target != null) {
            return this.target.tickle(f, n);
        }
        return false;
    }

    protected void finalize() throws Throwable {
        this.setActive(false);
        super.finalize();
    }

    private final synchronized void doTimeChanged(float f, int n) throws QTException {
        if (this.cbActive) {
            this.timeChanged(n);
            this.lastKnownRate = f;
            if (this.lastKnownRate != 0.0f && this.doesTickle && this.cbActive) {
                this.doReschedule(this.lastKnownRate, true);
            } else {
                this.tc.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doTickle(float f, int n) throws QTException {
        if (f != 0.0f) {
            Timer timer = this;
            synchronized (timer) {
                if (this.cbActive) {
                    if (this.tickle(f, n) && this.cbActive) {
                        this.doReschedule(f, false);
                    } else {
                        this.setTickling(false);
                    }
                }
            }
        }
    }

    private void doReschedule(float f, boolean bl) throws QTException {
        this.tc.cancel();
        int n = this.theTimeBase.getTime(this.tc.scale);
        if (bl) {
            this.tc.value = n;
        } else if (f > 0.0f) {
            this.tc.value += this.tc.period;
            if (this.tc.value <= n) {
                this.tc.value = n;
            }
        } else {
            this.tc.value += this.tc.period;
            if (this.tc.value > n) {
                this.tc.value = n;
            }
        }
        this.tc.callMeWhen();
    }

    private class RC
    extends RateCallBack {
        RC(TimeBase timeBase) throws QTException {
            super(timeBase, 0.0f, 0);
        }

        public void execute() {
            try {
                if (this.rateWhenCalled > 0.0f) {
                    Timer.this.isTimerTicking = true;
                    if (Timer.this.lastKnownRate <= 0.0f) {
                        Timer.this.tc.cancel();
                        ((Timer)Timer.this).tc.period = Math.abs(((Timer)Timer.this).tc.period);
                        Timer.this.doTimeChanged(this.rateWhenCalled, this.timeWhenCalledMsecs);
                    }
                } else if (this.rateWhenCalled < 0.0f) {
                    Timer.this.isTimerTicking = true;
                    if (Timer.this.lastKnownRate >= 0.0f) {
                        Timer.this.tc.cancel();
                        ((Timer)Timer.this).tc.period = Math.abs(((Timer)Timer.this).tc.period);
                        ((Timer)Timer.this).tc.period = -((Timer)Timer.this).tc.period;
                        Timer.this.doTimeChanged(this.rateWhenCalled, this.timeWhenCalledMsecs);
                    }
                } else {
                    Timer.this.isTimerTicking = false;
                    if (Timer.this.lastKnownRate != 0.0f) {
                        Timer.this.tc.cancel();
                        Timer.this.doTimeChanged(this.rateWhenCalled, this.timeWhenCalledMsecs);
                    }
                }
                this.cancel();
                if (Timer.this.isActive()) {
                    this.callMeWhen();
                }
            }
            catch (QTException qTException) {
                qTException.printStackTrace();
            }
        }
    }

    private class TJ
    extends TimeJumpCallBack {
        TJ(TimeBase timeBase) throws QTException {
            super(timeBase);
        }

        public void execute() {
            Timer.this.tc.cancel();
            try {
                Timer.this.doTimeChanged(this.rateWhenCalled, this.timeWhenCalledMsecs);
                this.cancel();
                if (Timer.this.isActive()) {
                    this.callMeWhen();
                }
            }
            catch (QTException qTException) {
                qTException.printStackTrace();
            }
        }
    }

    private class TC
    extends TimeCallBack {
        int period;

        TC(TimeBase timeBase, int n, int n2, int n3) throws QTException {
            super(timeBase, n, n2, 3);
            this.period = n2;
        }

        public void execute() {
            try {
                Timer.this.doTickle(this.rateWhenCalled, this.timeWhenCalledMsecs);
            }
            catch (QTException qTException) {
                qTException.printStackTrace();
            }
        }
    }
}

