/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.view;

import java.awt.Dimension;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;
import java.util.Vector;
import quicktime.QTException;
import quicktime.app.time.Timeable;
import quicktime.app.view.GraphicsImporterDrawer;
import quicktime.app.view.MoviePlayer;
import quicktime.app.view.Presentable;
import quicktime.jdirect.QTNative;
import quicktime.qd.PixMap;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.util.RawEncodedImage;

public class QTImageProducer
implements ImageProducer {
    private static final boolean debug = false;
    private static long msecs = 0L;
    private static final boolean profile = false;
    private Dimension size;
    private int rowInts;
    private QDGraphics gw;
    private PixMap pm;
    private int[] pixels;
    private Presentable qtSource;
    private ColorModel cm = new DirectColorModel(32, 0xFF0000, 65280, 255, 0);
    private Hashtable props = new Hashtable();
    private Vector consumers = new Vector();
    private boolean doesRedraw;
    private boolean singleFrame;

    private static boolean requiresRedrawing(Presentable presentable) {
        return presentable instanceof Timeable || !presentable.isSingleFrame();
    }

    public QTImageProducer(MoviePlayer moviePlayer, Dimension dimension) throws QTException {
        this((Presentable)moviePlayer, dimension);
    }

    public QTImageProducer(GraphicsImporterDrawer graphicsImporterDrawer, Dimension dimension) throws QTException {
        this((Presentable)graphicsImporterDrawer, dimension);
    }

    QTImageProducer(Presentable presentable, Dimension dimension) throws QTException {
        this.qtSource = presentable;
        this.setRedrawing(QTImageProducer.requiresRedrawing(presentable));
        this.singleFrame = !this.isRedrawing();
        this.size = dimension;
        this.gw = new QDGraphics(new QDRect(this.size));
        presentable.setDisplayBounds(new QDRect(this.size));
        presentable.setGWorld(this.gw);
        this.pm = this.gw.getPixMap();
        this.rowInts = this.pm.getRowBytes() / 4;
        this.pixels = new int[this.rowInts * this.size.height];
        presentable.redraw(null);
        this.copyPixels();
        if (this.isSingleFrame()) {
            this.gw.disposeQTObject();
            this.gw = null;
            this.pm = null;
            this.qtSource = null;
        }
    }

    public QDGraphics getGWorld() {
        return this.gw;
    }

    public boolean isSingleFrame() {
        return this.singleFrame;
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        block7: {
            if (this.isConsumer(imageConsumer)) {
                return;
            }
            try {
                this.consumers.addElement(imageConsumer);
                imageConsumer.setDimensions(this.size.width, this.size.height);
                if (!this.isConsumer(imageConsumer)) {
                    return;
                }
                imageConsumer.setProperties(this.props);
                if (!this.isConsumer(imageConsumer)) {
                    return;
                }
                imageConsumer.setColorModel(this.cm);
                if (this.isConsumer(imageConsumer)) {
                    int n = 14;
                    if (this.isSingleFrame()) {
                        n |= 0x10;
                    }
                    imageConsumer.setHints(n);
                }
            }
            catch (Exception exception) {
                if (!this.isConsumer(imageConsumer)) break block7;
                imageConsumer.imageComplete(1);
            }
        }
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        return this.consumers.contains(imageConsumer);
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        this.consumers.removeElement(imageConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProduction(ImageConsumer imageConsumer) {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            QTImageProducer qTImageProducer = this;
            synchronized (qTImageProducer) {
                block13: {
                    try {
                        this.addConsumer(imageConsumer);
                        if (!this.isConsumer(imageConsumer)) {
                            return;
                        }
                        imageConsumer.setPixels(0, 0, this.size.width, this.size.height, this.cm, this.pixels, 0, this.rowInts);
                        if (this.isConsumer(imageConsumer)) {
                            if (this.isSingleFrame()) {
                                imageConsumer.imageComplete(3);
                                if (this.isConsumer(imageConsumer)) {
                                    imageConsumer.imageComplete(1);
                                    this.removeConsumer(imageConsumer);
                                }
                            } else {
                                imageConsumer.imageComplete(2);
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (!this.isConsumer(imageConsumer)) break block13;
                        imageConsumer.imageComplete(1);
                    }
                }
            }
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    private synchronized void copyPixels() throws QTException {
        RawEncodedImage rawEncodedImage = this.pm.getPixelData();
        rawEncodedImage.copyToArray(0, this.pixels, 0, this.pixels.length);
    }

    public synchronized void redraw(Region region) throws QTException {
        if (this.consumers.isEmpty() && this.isSingleFrame()) {
            return;
        }
        this.qtSource.redraw(null);
        this.updateConsumers(region);
    }

    public synchronized void updateConsumers(Region region) throws QTException {
        int n;
        int n2;
        int n3;
        Object object;
        if (!this.isSingleFrame()) {
            this.copyPixels();
        }
        int n4 = 0;
        if (region != null) {
            object = region.getRgnBBox();
            n3 = ((QDRect)object).getX();
            n2 = ((QDRect)object).getY();
            n = ((QDRect)object).getWidth();
            n4 = ((QDRect)object).getHeight();
        } else {
            n3 = 0;
            n2 = 0;
            n = this.size.width;
            n4 = this.size.height;
        }
        object = this.consumers.elements();
        while (object.hasMoreElements()) {
            ImageConsumer imageConsumer = (ImageConsumer)object.nextElement();
            imageConsumer.setPixels(n3, n2, n, n4, this.cm, this.pixels, 0, this.rowInts);
            if (!this.isConsumer(imageConsumer)) continue;
            imageConsumer.imageComplete(2);
        }
        this.pixels[0] = 0;
    }

    public synchronized void setRedrawing(boolean bl) {
        this.doesRedraw = bl;
    }

    public boolean isRedrawing() {
        return this.doesRedraw;
    }

    public Dimension getSize() {
        return new Dimension(this.size);
    }
}

