/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.view;

import com.apple.eawt.CocoaComponent;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.view.QTComponent;
import quicktime.jdirect.QTNative;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDPoint;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.StdQTException;
import quicktime.std.image.GraphicsImporter;
import quicktime.std.movies.Movie;
import quicktime.std.movies.MovieController;
import quicktime.std.sg.SGVideoChannel;

class QTJavaCocoaCanvas
extends CocoaComponent
implements QTComponent,
KeyListener,
MouseListener {
    private static final int kSetMovie = 0;
    private static final int kSetImage = 1;
    private static final int kSetMovieController = 2;
    private static final int kSetSeqGrabber = 3;
    private static boolean debug = false;
    private int qtjavaView = 0;
    private boolean addDone = false;
    private boolean viewShown = false;
    private Movie movie;
    private MovieController controller;
    private GraphicsImporter image;
    private SGVideoChannel sgChannel;
    private int currentX;
    private int currentY;
    private int currentWidth;
    private int currentHeight;
    private int minWidth = 1;
    private int minHeight = 1;
    private int maxWidth = Integer.MAX_VALUE;
    private int maxHeight = Integer.MAX_VALUE;
    private QDRect oldbounds = null;
    transient int initialWidth = 1;
    transient int initialHeight = 1;
    private transient int prefWidth;
    private transient int prefHeight;
    private boolean performanceResize = false;
    private boolean QTMOVIEVIEW = false;
    private WindowAdapter wa;
    private Window parentWindow;

    private static native void initGlobalLock(Object var0);

    private static native void initGlobalOffScreen(Object var0);

    private native void setFullScreen(byte var1);

    private native void setMovie(int var1, Object var2);

    private native void setMovieController(int var1, Object var2);

    private native int createNSViewNative(float var1, float var2, Object var3, Object var4);

    private native int createImageNSViewNative(int var1, int var2, Object var3);

    private native int createSequenceGrabberNSView(int var1, int var2, Object var3);

    private native Object getMovieController(int var1);

    private native void removeMovie(int var1);

    public int createNSView() {
        QDRect qDRect = new QDRect(0, 0, 1, 1);
        Object var2_2 = null;
        if (this.movie != null) {
            try {
                if (this.controller != null) {
                    try {
                        qDRect = this.controller.getBounds();
                        if (debug) {
                            System.err.println("createNSView controller " + this.controller + "bounds " + qDRect);
                        }
                    }
                    catch (QTException qTException) {}
                } else {
                    qDRect = this.movie.getBounds();
                }
                this.setInitialWidthAndHeight(qDRect, this.getMinimumSize(), this.getMaximumSize());
            }
            catch (StdQTException stdQTException) {
                // empty catch block
            }
            this.qtjavaView = this.createNSViewNative(qDRect.getWidthF(), qDRect.getHeightF(), new Integer(QTObject.ID(this.movie)), this.controller != null ? new Integer(QTObject.ID(this.controller)) : null);
            return this.qtjavaView;
        }
        if (this.image != null) {
            try {
                qDRect = this.image.getBoundsRect();
                this.setInitialWidthAndHeight(qDRect, this.getMinimumSize(), this.getMaximumSize());
            }
            catch (StdQTException stdQTException) {
                // empty catch block
            }
            this.qtjavaView = this.createImageNSViewNative(qDRect.getWidth(), qDRect.getHeight(), new Integer(QTObject.ID(this.image)));
            return this.qtjavaView;
        }
        if (this.sgChannel != null) {
            try {
                if (this.sgChannel instanceof SGVideoChannel) {
                    qDRect = this.sgChannel.getBounds();
                }
                this.setInitialWidthAndHeight(qDRect, this.getMinimumSize(), this.getMaximumSize());
                if (debug) {
                    System.err.println("***createNSView sgChannel " + this.sgChannel + ", " + qDRect);
                }
            }
            catch (StdQTException stdQTException) {
                // empty catch block
            }
            this.qtjavaView = this.createSequenceGrabberNSView(qDRect.getWidth(), qDRect.getHeight(), new Integer(QTObject.ID(this.sgChannel.getSequenceGrabber())));
            return this.qtjavaView;
        }
        return 0;
    }

    QTJavaCocoaCanvas(MovieController movieController) throws QTException {
        this();
        this.movie = movieController.getMovie();
        this.controller = movieController;
        if (debug) {
            System.err.println("QTJavaCocoaCanvas " + this.movie + ", " + this.controller);
        }
    }

    QTJavaCocoaCanvas(Movie movie) {
        this();
        this.movie = movie;
        this.controller = null;
        this.performanceResize = false;
        if (debug) {
            System.err.println("QTJavaCocoaCanvas " + this.movie);
        }
    }

    QTJavaCocoaCanvas(GraphicsImporter graphicsImporter) {
        this();
        this.image = graphicsImporter;
        if (debug) {
            System.err.println("QTJavaCocoaCanvas " + graphicsImporter);
        }
    }

    QTJavaCocoaCanvas(SGVideoChannel sGVideoChannel) {
        this();
        this.sgChannel = sGVideoChannel;
        if (debug) {
            System.err.println("QTJavaCocoaCanvas " + this.sgChannel);
        }
    }

    private QTJavaCocoaCanvas() {
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addDone) {
            if (debug) {
                System.err.println("addNotify qtjavaView " + this.qtjavaView);
            }
            this.addedTo();
            QTSession.addActiveCanvas(this);
            this.addDone = true;
        }
        if (this.isVisible()) {
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeNotify() {
        if (debug) {
            System.err.println("removeNotify:");
        }
        if (this.addDone && QTSession.isInitialized()) {
            try {
                if (this.movie != null) {
                    this.doRemoveDrawable();
                }
                QTSession.removeActiveCanvas(this);
                if (debug) {
                    System.err.println("removeNotify:");
                }
                this.addDone = false;
            }
            finally {
                super.removeNotify();
            }
        } else {
            super.removeNotify();
        }
    }

    private final void doParentLayout() {
        Container container;
        if (debug) {
            System.err.println("doParentLayout:" + this.getParent());
        }
        if ((container = this.getParent()) != null) {
            this.invalidate();
            container.validate();
        }
        super.setBounds(this.currentX, this.currentY, this.currentWidth, this.currentHeight);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (debug) {
            System.err.println("setBounds: " + n3 + "," + n4);
        }
        super.setBounds(n, n2, n3, n4);
    }

    private final void setCurrentXY(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n3 - this.currentWidth;
        if (n6 < 0) {
            n6 = 0;
        }
        if ((n5 = n4 - this.currentHeight) < 0) {
            n5 = 0;
        }
        if (this.performanceResize) {
            this.currentX = n + (int)(0.5f * (float)n6);
            this.currentY = n2 + (int)(0.5f * (float)n5);
        } else {
            this.currentX = n;
            this.currentY = n2;
        }
        if (debug) {
            System.err.println("setCurrentXY " + this.currentX + " " + this.currentY);
        }
    }

    public float getAlignmentX() {
        return this.performanceResize ? 0.5f : 0.0f;
    }

    public float getAlignmentY() {
        return this.performanceResize ? 0.5f : 0.0f;
    }

    private void setCurrentWidthHeight(int n, int n2) {
        if (n < this.minWidth) {
            n = this.minWidth;
        } else if (n > this.maxWidth) {
            n = this.maxWidth;
        }
        if (n2 < this.minHeight) {
            n2 = this.minHeight;
        } else if (n2 > this.maxHeight) {
            n2 = this.maxHeight;
        }
        if (this.performanceResize) {
            this.setPerformanceResize(n, n2);
        } else {
            this.currentWidth = n;
            this.currentHeight = n2;
        }
        if (debug) {
            System.out.println("setCurrentWidthHeight( " + this.currentWidth + ", " + this.currentHeight + ", " + this.minWidth + ", " + this.minHeight);
        }
    }

    private void setInitialWidthAndHeight(QDRect qDRect, Dimension dimension, Dimension dimension2) {
        this.initialWidth = qDRect.getWidth();
        this.initialHeight = qDRect.getHeight();
        this.minWidth = dimension.width < 0 ? 0 : dimension.width;
        this.minHeight = dimension.height < 0 ? 0 : dimension.height;
        this.maxWidth = dimension2.width < this.minWidth ? this.minWidth : dimension2.width;
        this.maxHeight = dimension2.height < this.minHeight ? this.minHeight : dimension2.height;
        if (this.initialWidth < this.minWidth) {
            this.initialWidth = this.minWidth;
        } else if (this.initialWidth > this.maxWidth) {
            this.initialWidth = this.maxWidth;
        }
        if (this.initialHeight < this.minHeight) {
            this.initialHeight = this.minHeight;
        } else if (this.initialHeight > this.maxHeight) {
            this.initialHeight = this.maxHeight;
        }
        this.prefWidth = this.initialWidth;
        this.prefHeight = this.initialHeight;
        if (debug) {
            System.err.println("setInitialWidthAndHeight " + this.initialWidth + " " + this.initialHeight + " " + this.prefWidth + " " + this.prefHeight);
        }
    }

    private void setPerformanceResize(int n, int n2) {
        boolean bl = false;
        int n3 = 2;
        while (!bl) {
            boolean bl2;
            int n4;
            int n5;
            if (n < this.initialWidth || n2 < this.initialHeight) {
                n5 = this.initialWidth / n3;
                n4 = this.initialHeight / n3;
                if (n5 <= n && n4 <= n2) {
                    bl = true;
                    bl2 = false;
                    this.currentWidth = n5;
                    this.currentHeight = n4;
                    while (bl2) {
                        if (this.currentWidth >= this.minWidth && this.currentHeight >= this.minHeight) {
                            bl2 = true;
                        }
                        this.currentWidth *= 2;
                        this.currentHeight *= 2;
                    }
                }
            } else {
                n5 = this.initialWidth * n3;
                n4 = this.initialHeight * n3;
                if (n5 >= n || n4 >= n2) {
                    bl = true;
                    if (n5 > n || n4 > n2) {
                        n5 /= 2;
                        n4 /= 2;
                    }
                    bl2 = false;
                    this.currentWidth = n5;
                    this.currentHeight = n4;
                    while (bl2) {
                        if (this.currentWidth <= this.maxWidth && this.currentHeight <= this.maxHeight) {
                            bl2 = true;
                        }
                        this.currentWidth /= 2;
                        this.currentHeight /= 2;
                    }
                }
            }
            n3 *= 2;
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = null;
        dimension = new Dimension(this.prefWidth, this.prefHeight);
        if (debug) {
            System.err.println("getPreferredSize " + dimension);
        }
        return dimension;
    }

    public Dimension getBestSize() {
        Dimension dimension = null;
        dimension = new Dimension(this.initialWidth, this.initialHeight);
        if (debug) {
            System.err.println("getBestSize " + dimension);
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = null;
        dimension = new Dimension(this.minWidth, this.minHeight);
        if (debug) {
            System.err.println("getMinimumSize " + dimension);
        }
        return dimension;
    }

    public Dimension getMaximumSize() {
        Dimension dimension = null;
        dimension = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
        if (debug) {
            System.err.println("getMaximumSize " + dimension);
        }
        return dimension;
    }

    private void setFullScreen() {
        this.setFullScreen((byte)1);
    }

    public void removeMovie() throws QTException {
        if (this.movie != null) {
            this.movie.setRate(0.0f);
            this.movie.stop();
        }
    }

    public Movie getMovie() {
        return this.movie;
    }

    public MovieController getMovieController() {
        return this.controller;
    }

    public void setMovieController(MovieController movieController) throws QTException {
        QDRect qDRect = null;
        if (movieController == this.controller) {
            return;
        }
        this.doRemoveDrawable();
        this.controller = movieController;
        if (movieController != null) {
            this.movie = movieController.getMovie();
            try {
                qDRect = movieController.getBounds();
                if (this.qtjavaView != 0 && this.isValid()) {
                    this.sendMessage(2, new Integer(QTObject.ID(movieController)));
                    this.setInitialWidthAndHeight(qDRect, this.getMinimumSize(), this.getMaximumSize());
                }
            }
            catch (QTException qTException) {
                // empty catch block
            }
            if (this.qtjavaView != 0 && this.isValid()) {
                this.addedTo();
            }
        } else {
            this.movie = null;
        }
    }

    public void setMovie(Movie movie) throws QTException {
        QDRect qDRect = null;
        if (movie == this.movie) {
            return;
        }
        if (debug) {
            System.err.println("setMovie " + movie);
        }
        this.doRemoveDrawable();
        this.movie = movie;
        if (movie != null) {
            qDRect = this.movie.getBounds();
            if (this.qtjavaView != 0 && this.isValid()) {
                this.sendMessage(0, new Integer(QTObject.ID(this.movie)));
            }
            this.setInitialWidthAndHeight(qDRect, this.getMinimumSize(), this.getMaximumSize());
        }
    }

    public void setSGChannel(SGVideoChannel sGVideoChannel) throws QTException {
        QDRect qDRect = new QDRect(0, 0, 1, 1);
        if (sGVideoChannel == this.sgChannel) {
            return;
        }
        if (debug) {
            System.err.println("setSGChannel " + this.sgChannel);
        }
        if (this.sgChannel != null) {
            this.doRemoveDrawable();
        }
        if (sGVideoChannel != null) {
            this.sgChannel = sGVideoChannel;
            if (this.sgChannel instanceof SGVideoChannel) {
                qDRect = this.sgChannel.getBounds();
            }
            if (this.qtjavaView != 0 && this.isValid()) {
                this.sendMessage(3, new Integer(QTObject.ID(this.sgChannel.getSequenceGrabber())));
            }
            this.setInitialWidthAndHeight(qDRect, this.getMinimumSize(), this.getMaximumSize());
        }
    }

    public Component asComponent() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRemoveDrawable() {
        QDGraphics qDGraphics = null;
        if (debug) {
            System.out.println("doRemoveDrawable:");
        }
        try {
            block16: {
                try {
                    qDGraphics = QDGraphics.scratch;
                    if (this.movie != null && QTSession.isInitialized() && this.movie != null) {
                        this.movie.setRate(0.0f);
                        this.movie.stop();
                    }
                    if (this.qtjavaView == 0 || !this.isValid()) break block16;
                    if (this.movie != null) {
                        if (this.controller != null) {
                            this.sendMessage(2, null);
                        }
                        if (this.movie != null) {
                            this.sendMessage(0, null);
                        }
                    }
                    if (this.image == null) break block16;
                    this.sendMessage(1, null);
                }
                catch (QTException qTException) {
                    if (debug) {
                        qTException.printStackTrace();
                    }
                    Object var4_3 = null;
                    if (this.controller != null) {
                        this.removedFrom();
                    }
                    if (debug) {
                        System.out.println("finally:");
                    }
                    this.movie = null;
                    this.controller = null;
                    this.image = null;
                }
            }
            Object var4_2 = null;
            if (this.controller != null) {
                this.removedFrom();
            }
            if (debug) {
                System.out.println("finally:");
            }
            this.movie = null;
            this.controller = null;
            this.image = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.controller != null) {
                this.removedFrom();
            }
            if (debug) {
                System.out.println("finally:");
            }
            this.movie = null;
            this.controller = null;
            this.image = null;
            throw throwable;
        }
    }

    public GraphicsImporter getImage() {
        return this.image;
    }

    public void setImage(GraphicsImporter graphicsImporter) {
        QDRect qDRect = null;
        if (this.image == graphicsImporter) {
            return;
        }
        this.doRemoveDrawable();
        this.image = graphicsImporter;
        if (graphicsImporter != null) {
            try {
                qDRect = this.image.getBoundsRect();
                this.setInitialWidthAndHeight(qDRect, this.getMinimumSize(), this.getMaximumSize());
            }
            catch (StdQTException stdQTException) {
                // empty catch block
            }
            if (this.qtjavaView != 0 && this.isValid()) {
                this.sendMessage(1, new Integer(QTObject.ID(this.image)));
            }
            this.doParentLayout();
        }
        this.repaint();
    }

    protected void addedTo() {
        Container container;
        if (debug) {
            try {
                if (debug) {
                    System.err.println("addedTo " + this.controller.getPort());
                }
            }
            catch (StdQTException stdQTException) {
                // empty catch block
            }
        }
        if (this.controller != null) {
            this.addKeyListener(this);
        }
        Container container2 = container = this.getParent();
        while (container2 != null && !((container = container2) instanceof Window)) {
            container2 = container.getParent();
        }
        if (container != null) {
            container.addKeyListener(this);
        }
        try {
            if (this.controller != null) {
                this.controller.setKeysEnabled(true);
            }
        }
        catch (StdQTException stdQTException) {
            // empty catch block
        }
        if (container instanceof Window) {
            this.parentWindow = (Window)container;
            this.wa = new WindowAdapter(){

                public void windowActivated(WindowEvent windowEvent) {
                    try {
                        if (QTJavaCocoaCanvas.this.controller != null) {
                            QTJavaCocoaCanvas.this.controller.activate(QTJavaCocoaCanvas.this.controller.getPort(), true);
                            QTJavaCocoaCanvas.this.controller.activate();
                        }
                        QTJavaCocoaCanvas.this.redraw(null);
                    }
                    catch (QTException qTException) {
                        // empty catch block
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void windowDeactivated(WindowEvent windowEvent) {
                    Object object = QTSession.terminationLock();
                    synchronized (object) {
                        if (QTSession.isInitialized()) {
                            try {
                                if (QTJavaCocoaCanvas.this.controller != null) {
                                    QTJavaCocoaCanvas.this.controller.deactivate();
                                    QTJavaCocoaCanvas.this.controller.activate(QTJavaCocoaCanvas.this.controller.getPort(), false);
                                }
                                QTJavaCocoaCanvas.this.redraw(null);
                            }
                            catch (QTException qTException) {}
                        } else {
                            QTJavaCocoaCanvas.this.removedFrom();
                        }
                    }
                }
            };
            this.parentWindow.addWindowListener(this.wa);
        }
    }

    protected void removedFrom() {
        this.removeKeyListener(this);
        if (this.getParent() != null) {
            this.getParent().removeKeyListener(this);
        }
        if (this.parentWindow != null) {
            this.parentWindow.removeWindowListener(this.wa);
            this.parentWindow = null;
            this.wa = null;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        try {
            if (debug) {
                System.err.println("Key pressed " + keyEvent);
            }
            if (this.controller != null) {
                boolean bl = this.controller.key(keyEvent.getKeyCode(), keyEvent.getModifiers());
            }
        }
        catch (QTException qTException) {
            QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this, "keyPressed");
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (debug) {
            System.err.println("mousePressed " + mouseEvent);
        }
        try {
            Container container;
            Container container2 = container = this.getParent();
            while (container2 != null) {
                if (debug) {
                    System.err.println(container2 + " getLocation " + container2.getLocation() + " getBounds " + container2.getBounds());
                }
                if (container2 instanceof Window || container2 instanceof Frame || container2 instanceof Applet) break;
                container = container2;
                container2 = container.getParent();
            }
            if (debug) {
                System.err.println(container + " getLocation " + container.getLocation() + " getBounds " + container.getBounds());
            }
            if (container instanceof Applet) {
                if (this.controller != null) {
                    this.controller.click(new QDPoint(mouseEvent.getX(), mouseEvent.getY() + (container.getLocation().y - 22) + this.getLocation().y), mouseEvent.getModifiers());
                }
            } else {
                if (debug) {
                    System.err.println(mouseEvent.getX() + container.getLocation().x + this.getLocation().x + ", " + (mouseEvent.getY() + (container.getLocation().y == 22 ? container.getLocation().y : container.getLocation().y - 22) + this.getLocation().y));
                }
                if (this.controller != null) {
                    this.controller.click(new QDPoint(mouseEvent.getX() + container.getLocation().x + this.getLocation().x, container.getLocation().y != 22 ? mouseEvent.getY() + (container.getLocation().y - 22) + this.getLocation().y : mouseEvent.getY()), mouseEvent.getModifiers());
                }
            }
        }
        catch (QTException qTException) {
            QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this, "mousePressed");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private final void redraw(Region region) throws QTException {
        block7: {
            if (debug) {
                System.out.println("RD:");
            }
            if (region != null) {
                try {
                    if (this.controller != null) {
                        this.controller.invalidate(this.controller.getPort(), region);
                        this.controller.idle();
                    }
                    break block7;
                }
                catch (StdQTException stdQTException) {
                    if (this.controller != null) {
                        this.controller.draw();
                    }
                    break block7;
                }
            }
            if (this.controller != null) {
                this.controller.draw();
            }
        }
    }

    static {
        if (!QTSession.isCurrentOS(4)) {
            throw new QTRuntimeException("OS not supported");
        }
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() < 65540) {
            throw new QTRuntimeException("Java version not supported");
        }
        String string = "/System/Library/QuickTimeJava/QuickTimeJava.bundle/Contents/Resources/libCocoaInterface.jnilib";
        System.load(string);
        QTJavaCocoaCanvas.initGlobalLock(QTNative.globalsLock);
    }
}

