/*
 * Decompiled with CFR 0.152.
 */
package quicktime.qd;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.util.EndianDescriptor;
import quicktime.util.EndianFlipSpec;
import quicktime.util.EndianOrder;
import quicktime.util.QTByteObject;
import quicktime.util.QTUtils;

public final class QDColor
extends QTByteObject
implements QuickTimeLib,
Cloneable {
    private static Object linkage;
    private static final int kNativeSize = 6;
    public static final QDColor black;
    public static final QDColor white;
    public static final QDColor red;
    public static final QDColor green;
    public static final QDColor blue;
    public static final QDColor yellow;
    public static final QDColor magenta;
    public static final QDColor cyan;
    public static final QDColor darkGray;
    public static final QDColor gray;
    public static final QDColor lightGray;
    public static final QDColor pink;
    public static final QDColor orange;
    public static final QDColor brown;
    public static final int kMaximumValue = 65535;
    public static final int kIsRGBColor = 6;
    public static final int kIsARGBColor = 8;
    public static final int kIsTQ3ColorRGB = 12;
    public static final int kIsGradientColor = 14;
    public static final int kIsTQ3ColorARGB = 16;
    private static EndianDescriptor ed;
    private transient int alpha;
    private transient int endPercent;
    static final long serialVersionUID = -6088195721752787215L;
    static /* synthetic */ Class class$quicktime$qd$QDColor;

    public static final EndianDescriptor getEndianDescriptorRGBColor() {
        return EndianDescriptor.flipAll16;
    }

    public static final EndianDescriptor getEndianDescriptorARGBColor() {
        return EndianDescriptor.flipAll16;
    }

    public static final EndianDescriptor getEndianDescriptorGradientColor() {
        if (ed == null) {
            ed = new EndianDescriptor(0);
            EndianFlipSpec endianFlipSpec = new EndianFlipSpec(0, 2, 4);
            ed.addFlipSpec(endianFlipSpec);
            EndianFlipSpec endianFlipSpec2 = new EndianFlipSpec(8, 4, 1);
            ed.addFlipSpec(endianFlipSpec2);
        }
        return ed;
    }

    public static final EndianDescriptor getEndianDescriptorTQ3Color() {
        return EndianDescriptor.flipAll32;
    }

    public static final EndianDescriptor getEndianDescriptorTQ3ColorARGB() {
        return EndianDescriptor.flipAll32;
    }

    public static int convert8to16(int n) {
        return (0xFF & n) << 8 | 0xFF & n;
    }

    public static int convert16to8(int n) {
        return (0xFF00 & n) >> 8;
    }

    public static QDColor fromArray(byte[] byArray, int n) {
        if (n > byArray.length) {
            throw new IllegalArgumentException("Mismatch between flag and supplied colorBytes");
        }
        switch (n) {
            case 6: {
                QDColor qDColor = new QDColor();
                System.arraycopy(byArray, 0, qDColor.bytes, 0, 6);
                return qDColor;
            }
            case 8: {
                QDColor qDColor = new QDColor();
                System.arraycopy(byArray, 2, qDColor.bytes, 0, 6);
                qDColor.setAlpha(QTUtils.UShort2Int(QDColor.getShortFromArray(byArray, 0)));
                return qDColor;
            }
            case 14: {
                QDColor qDColor = new QDColor();
                System.arraycopy(byArray, 2, qDColor.bytes, 0, 6);
                qDColor.setAlpha(QTUtils.UShort2Int(QDColor.getShortFromArray(byArray, 0)));
                qDColor.endPercent = QDColor.getIntFromArray(byArray, 8);
                return qDColor;
            }
            case 12: {
                float f = QDColor.getFloatFromArray(byArray, 0);
                float f2 = QDColor.getFloatFromArray(byArray, 4);
                float f3 = QDColor.getFloatFromArray(byArray, 8);
                return new QDColor(f, f2, f3);
            }
            case 16: {
                float f = QDColor.getFloatFromArray(byArray, 0);
                float f4 = QDColor.getFloatFromArray(byArray, 4);
                float f5 = QDColor.getFloatFromArray(byArray, 8);
                float f6 = QDColor.getFloatFromArray(byArray, 12);
                return new QDColor(f4, f5, f6, f);
            }
        }
        throw new IllegalArgumentException("Unknown color format");
    }

    public static QDColor fromARGBColor(int n) {
        return new QDColor(QDColor.convert8to16(n & 0xFF0000), QDColor.convert8to16(n & 0xFF00), QDColor.convert8to16(n & 0xFF), QDColor.convert8to16(n & 0xFF000000));
    }

    public QDColor() {
        super(6);
    }

    public QDColor(int n, int n2, int n3) {
        this(n, n2, n3, 65535);
    }

    public QDColor(int n, int n2, int n3, int n4) {
        this();
        this.setRed(n);
        this.setGreen(n2);
        this.setBlue(n3);
        this.setAlpha(n4);
    }

    public QDColor(float f, float f2, float f3) {
        this(f, f2, f3, 1.0f);
    }

    public QDColor(float f, float f2, float f3, float f4) {
        this();
        f = QDColor.checkRange(f);
        f2 = QDColor.checkRange(f2);
        f3 = QDColor.checkRange(f3);
        f4 = QDColor.checkRange(f4);
        this.setRed((int)(f * 65535.0f + 0.5f));
        this.setGreen((int)(f2 * 65535.0f + 0.5f));
        this.setBlue((int)(f3 * 65535.0f + 0.5f));
        this.setAlpha((int)(f4 * 65535.0f + 0.5f));
    }

    public QDColor(float f, float f2, float f3, float f4, float f5) {
        this(f, f2, f3, f4);
        this.setAlpha((int)(f4 * 65535.0f + 0.5f));
        this.endPercent = QTUtils.X2Fix(f5);
    }

    public QDColor(Color color) {
        this(QDColor.convert8to16(color.getRed()), QDColor.convert8to16(color.getGreen()), QDColor.convert8to16(color.getBlue()));
    }

    private QDColor(byte[] byArray, int n) {
        super(byArray);
        this.alpha = n;
    }

    private static float checkRange(float f) {
        if (f < 0.0f) {
            return 0.0f;
        }
        if (f > 1.0f) {
            return 1.0f;
        }
        return f;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[6];
        byte[] byArray = new byte[10];
        objectInputStream.read(byArray);
        for (int i = 0; i < 6; i += 2) {
            QDColor.setShortInArray(this.getBytes(), i, EndianOrder.flipBigEndianToNative16(QDColor.getShortFromArray(byArray, i)));
        }
        this.alpha = EndianOrder.flipBigEndianToNative32(QDColor.getIntFromArray(byArray, 6));
        if (this.alpha == -1) {
            byArray = new byte[8];
            objectInputStream.read(byArray);
            this.alpha = EndianOrder.flipBigEndianToNative32(QDColor.getIntFromArray(byArray, 0));
            this.endPercent = EndianOrder.flipBigEndianToNative32(QDColor.getIntFromArray(byArray, 4));
        } else {
            this.endPercent = 0;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        byte[] byArray = new byte[18];
        for (int i = 0; i < 6; i += 2) {
            QDColor.setShortInArray(byArray, i, EndianOrder.flipNativeToBigEndian16(QDColor.getShortFromArray(this.getBytes(), i)));
        }
        QDColor.setIntInArray(byArray, 6, -1);
        QDColor.setIntInArray(byArray, 10, EndianOrder.flipNativeToBigEndian32(this.alpha));
        QDColor.setIntInArray(byArray, 14, EndianOrder.flipNativeToBigEndian32(this.endPercent));
        objectOutputStream.write(byArray);
    }

    public byte[] getRGBColor() {
        return this.bytes;
    }

    public byte[] getARGBColor() {
        byte[] byArray = new byte[8];
        QDColor.setShortInArray(byArray, 0, (short)this.alpha);
        System.arraycopy(this.bytes, 0, byArray, 2, 6);
        return byArray;
    }

    public byte[] getGradientColor() {
        byte[] byArray = new byte[12];
        QDColor.setShortInArray(byArray, 0, (short)this.alpha);
        System.arraycopy(this.bytes, 0, byArray, 2, 6);
        QDColor.setIntInArray(byArray, 8, this.endPercent);
        return byArray;
    }

    public byte[] getTQ3ColorRGB() {
        byte[] byArray = new byte[12];
        QDColor.setFloatInArray(byArray, 0, (float)this.getRed() / 65535.0f);
        QDColor.setFloatInArray(byArray, 4, (float)this.getGreen() / 65535.0f);
        QDColor.setFloatInArray(byArray, 8, (float)this.getBlue() / 65535.0f);
        return byArray;
    }

    public byte[] getTQ3ColorARGB() {
        byte[] byArray = new byte[16];
        QDColor.setFloatInArray(byArray, 0, (float)this.getAlpha() / 65535.0f);
        QDColor.setFloatInArray(byArray, 4, (float)this.getRed() / 65535.0f);
        QDColor.setFloatInArray(byArray, 8, (float)this.getGreen() / 65535.0f);
        QDColor.setFloatInArray(byArray, 12, (float)this.getBlue() / 65535.0f);
        return byArray;
    }

    public int getRed() {
        return QTUtils.UShort2Int(this.getShortAt(0));
    }

    public float getRedF() {
        return (float)QTUtils.UShort2Int(this.getShortAt(0)) / 65535.0f;
    }

    public int getGreen() {
        return QTUtils.UShort2Int(this.getShortAt(2));
    }

    public float getGreenF() {
        return (float)QTUtils.UShort2Int(this.getShortAt(2)) / 65535.0f;
    }

    public int getBlue() {
        return QTUtils.UShort2Int(this.getShortAt(4));
    }

    public float getBlueF() {
        return (float)QTUtils.UShort2Int(this.getShortAt(4)) / 65535.0f;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public float getAlphaF() {
        return (float)this.alpha / 65535.0f;
    }

    public float getEndingPercentage() {
        return QTUtils.Fix2X(this.endPercent);
    }

    public Object clone() {
        return new QDColor(this.getRGBColor(), this.getAlpha());
    }

    public int getARGB() {
        return QDColor.convert16to8(this.getAlpha()) << 24 | QDColor.convert16to8(this.getRed()) << 16 | QDColor.convert16to8(this.getGreen()) << 8 | QDColor.convert16to8(this.getBlue());
    }

    public int getRGB() {
        return 0 | QDColor.convert16to8(this.getRed()) << 16 | QDColor.convert16to8(this.getGreen()) << 8 | QDColor.convert16to8(this.getBlue());
    }

    public String toString() {
        return super.toString() + "[red=0x" + Integer.toHexString(this.getRed()) + ",green=0x" + Integer.toHexString(this.getGreen()) + ",blue=0x" + Integer.toHexString(this.getBlue()) + ",alpha=0x" + Integer.toHexString(this.getAlpha()) + "]";
    }

    private void setRed(int n) {
        this.setShortAt(0, (short)n);
    }

    private void setGreen(int n) {
        this.setShortAt(2, (short)n);
    }

    private void setBlue(int n) {
        this.setShortAt(4, (short)n);
    }

    private void setAlpha(int n) {
        this.alpha = 0xFFFF & n;
    }

    private static native short getShortFromArray(byte[] var0, int var1);

    private static native float getFloatFromArray(byte[] var0, int var1);

    private static native int getIntFromArray(byte[] var0, int var1);

    private static native void setShortInArray(byte[] var0, int var1, short var2);

    private static native void setFloatInArray(byte[] var0, int var1, float var2);

    private static native void setIntInArray(byte[] var0, int var1, int var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$qd$QDColor == null ? (class$quicktime$qd$QDColor = QDColor.class$("quicktime.qd.QDColor")) : class$quicktime$qd$QDColor);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
        black = new QDColor(0, 0, 0);
        white = new QDColor(65535, 65535, 65535);
        red = new QDColor(65535, 0, 0);
        green = new QDColor(0, 65535, 0);
        blue = new QDColor(0, 0, 65535);
        yellow = new QDColor(65535, 65535, 0);
        magenta = new QDColor(65535, 0, 65535);
        cyan = new QDColor(0, 65535, 65535);
        darkGray = new QDColor(16383, 16383, 16383);
        gray = new QDColor(Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE);
        lightGray = new QDColor(49151, 49151, 49151);
        pink = new QDColor(65535, 44976, 44976);
        orange = new QDColor(65535, 51400, 0);
        brown = new QDColor(Short.MAX_VALUE, 16383, 0);
    }
}

