/*
 * Decompiled with CFR 0.152.
 */
package quicktime.qd;

import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QTStreamingLib;
import quicktime.jdirect.QuickTimeLib;
import quicktime.qd.PixMap;
import quicktime.qd.QDException;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDPoint;
import quicktime.qd.QDRect;
import quicktime.std.StdQTException;
import quicktime.std.image.GraphicsImporter;
import quicktime.std.movies.Movie;
import quicktime.std.movies.MovieController;
import quicktime.std.movies.Track;
import quicktime.std.sg.VisualChannel;
import quicktime.streaming.Presentation;
import quicktime.streaming.Stream;
import quicktime.util.QTHandleRef;

public final class Region
extends QTHandleRef
implements QuickTimeLib,
QTStreamingLib,
Cloneable {
    private static Object linkage;
    private static final boolean isMacOS;
    private static final int[] savedPort;
    private static final int[] savedDevice;
    private QDGraphics recordingGraphics;
    static /* synthetic */ Class class$quicktime$qd$Region;

    public static Region fromGraphicsImporter(GraphicsImporter graphicsImporter) throws QTException {
        int[] nArray = new int[1];
        int n = Region.GraphicsImportGetClip(QTObject.ID(graphicsImporter), nArray);
        QTException.checkError(n);
        if (nArray[0] == 0) {
            return null;
        }
        return nArray[0] == 0 ? null : new Region(nArray[0]);
    }

    public static Region fromGraphicsImporterDefault(GraphicsImporter graphicsImporter) throws QTException {
        int[] nArray = new int[]{0};
        int n = Region.GraphicsImportGetDefaultClip(QTObject.ID(graphicsImporter), nArray);
        QTException.checkError(n);
        return nArray[0] == 0 ? null : new Region(nArray[0]);
    }

    public static Region fromMovieDisplayClip(Movie movie) throws QTException {
        int n = Region.GetMovieDisplayClipRgn(QTObject.ID(movie));
        StdQTException.checkError(Region.GetMoviesError());
        return n == 0 ? null : new Region(n);
    }

    public static Region fromMovieDisplayBounds(Movie movie) throws QTException {
        int n = Region.GetMovieDisplayBoundsRgn(QTObject.ID(movie));
        StdQTException.checkError(Region.GetMoviesError());
        return n == 0 ? null : new Region(n);
    }

    public static Region fromMovieClip(Movie movie) throws QTException {
        int n = Region.GetMovieClipRgn(QTObject.ID(movie));
        StdQTException.checkError(Region.GetMoviesError());
        return n == 0 ? null : new Region(n);
    }

    public static Region fromPresentationClip(Presentation presentation, Stream stream) throws QTException {
        int[] nArray = new int[]{0};
        StdQTException.checkError(Region.QTSPresGetClip(QTObject.ID(presentation), QTObject.ID(stream), nArray));
        return nArray[0] == 0 ? null : new Region(nArray[0]);
    }

    public static Region fromMovieBounds(Movie movie) throws QTException {
        int n = Region.GetMovieBoundsRgn(QTObject.ID(movie));
        StdQTException.checkError(Region.GetMoviesError());
        return n == 0 ? null : new Region(n);
    }

    public static Region fromMovieSegment(Movie movie, int n, int n2) throws QTException {
        int n3 = Region.GetMovieSegmentDisplayBoundsRgn(QTObject.ID(movie), n, n2);
        StdQTException.checkError(Region.GetMoviesError());
        return n3 == 0 ? null : new Region(n3);
    }

    public static Region fromMovieControllerBounds(MovieController movieController) throws QTException {
        int n = Region.MCGetControllerBoundsRgn(QTObject.ID(movieController));
        StdQTException.checkError(Region.GetMoviesError());
        return new Region(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Region fromMovieControllerWindow(MovieController movieController, QDGraphics qDGraphics) throws QTException {
        if (qDGraphics == null) {
            throw new StdQTException(-50);
        }
        int n = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Region.GetGWorld(savedPort, savedDevice);
            }
            Region.SetGWorld(QTObject.ID(qDGraphics), 0);
            n = Region.MCGetWindowRgn(QTObject.ID(movieController), QTObject.ID(qDGraphics));
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Region.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(Region.GetMoviesError());
        return new Region(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Region fromMovieControllerClip(MovieController movieController) throws QTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            int[] nArray = new int[1];
            StdQTException.checkError(Region.MCGetClip(QTObject.ID(movieController), nArray, null));
            return new Region(nArray[0]);
        }
    }

    public static Region fromMovieControllerBadge(MovieController movieController, Region region, boolean bl) throws QTException {
        int[] nArray = null;
        if (bl) {
            nArray = new int[1];
        }
        StdQTException.checkError(Region.MCDrawBadge(QTObject.ID(movieController), QTObject.ID(region), nArray));
        return bl ? new Region(nArray[0]) : null;
    }

    public static Region fromTrackClip(Track track) throws QTException {
        int n = Region.GetTrackClipRgn(QTObject.ID(track));
        StdQTException.checkError(Region.GetMoviesError());
        return n == 0 ? null : new Region(n);
    }

    public static Region fromTrackDisplay(Track track) throws QTException {
        int n = Region.GetTrackDisplayBoundsRgn(QTObject.ID(track));
        StdQTException.checkError(Region.GetMoviesError());
        return n == 0 ? null : new Region(n);
    }

    public static Region fromTrackMovieBounds(Track track) throws QTException {
        int n = Region.GetTrackMovieBoundsRgn(QTObject.ID(track));
        StdQTException.checkError(Region.GetMoviesError());
        return n == 0 ? null : new Region(n);
    }

    public static Region fromTrackBounds(Track track) throws QTException {
        int n = Region.GetTrackBoundsRgn(QTObject.ID(track));
        StdQTException.checkError(Region.GetMoviesError());
        return n == 0 ? null : new Region(n);
    }

    public static Region fromTrackSegment(Track track, int n, int n2) throws QTException {
        int n3 = Region.GetTrackSegmentDisplayBoundsRgn(QTObject.ID(track), n, n2);
        StdQTException.checkError(Region.GetMoviesError());
        return n3 == 0 ? null : new Region(n3);
    }

    public static Region fromVideoChannel(VisualChannel visualChannel) throws QTException {
        int[] nArray = new int[]{0};
        int n = Region.SGGetChannelClip(QTObject.ID(visualChannel), nArray);
        StdQTException.checkError(n);
        return nArray[0] == 0 ? null : new Region(nArray[0]);
    }

    public Region() throws QTException {
        super(Region.allocate(), null, false);
    }

    private static int allocate() throws QTException {
        int n = Region.NewRgn();
        StdQTException.checkError(Region.MemError());
        return n;
    }

    public Region(QDRect qDRect) throws QTException {
        this();
        this.rect(qDRect);
    }

    public Region(PixMap pixMap) throws QTException {
        this();
        boolean bl = false;
        if (!pixMap.isLocked()) {
            pixMap.lock();
            bl = true;
        }
        int n = Region.getIntFromPointer(QTObject.ID(pixMap), 0);
        short s = Region.BitMapToRegion(this._ID(), n);
        if (bl) {
            pixMap.unlock();
        }
        QDException.checkError(s);
    }

    private Region(int n) throws QTException {
        super(n, null, false);
    }

    public int getSize() {
        return super.getSize();
    }

    public QDRect getRgnBBox() {
        if (QTSession.isCurrentOS(4)) {
            QDRect qDRect = new QDRect();
            Region.GetRegionBounds(this._ID(), qDRect.getBytes());
            return qDRect;
        }
        byte[] byArray = new byte[8];
        this.getBytesAt(2, 8, byArray, 0);
        return QDRect.fromArray(byArray, 8);
    }

    public QDRect getBounds() {
        return this.getRgnBBox();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(QDGraphics qDGraphics) throws QDException {
        if (qDGraphics == null) {
            throw new QDException("Graphics must be specified for Open Region");
        }
        if (this.recordingGraphics != null) {
            this.close();
        }
        this.recordingGraphics = qDGraphics;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Region.GetGWorld(savedPort, savedDevice);
            }
            Region.SetGWorld(QTObject.ID(this.recordingGraphics), 0);
            Region.OpenRgn();
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Region.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws QDException {
        if (this.recordingGraphics != null) {
            Object object = QTNative.globalsLock;
            synchronized (object) {
                if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                    Region.GetGWorld(savedPort, savedDevice);
                }
                Region.SetGWorld(QTObject.ID(this.recordingGraphics), 0);
                Region.CloseRgn(this._ID());
                if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                    Region.SetGWorld(savedPort[0], savedDevice[0]);
                }
            }
        }
        this.recordingGraphics = null;
    }

    public void rect(QDRect qDRect) {
        Region.RectRgn(this._ID(), qDRect.getRect());
    }

    public Region copy() throws QTException {
        int n = Region.NewRgn();
        if (n == 0) {
            QDException.checkError(-108);
        }
        if (isMacOS || QTSession.isCurrentOS(4)) {
            Region.CopyRgn(this._ID(), n);
        } else {
            Region.MacCopyRgn(this._ID(), n);
        }
        return new Region(n);
    }

    public Object clone() {
        try {
            return this.copy();
        }
        catch (QTException qTException) {
            throw new QTRuntimeException(qTException);
        }
    }

    public void setEmpty() {
        Region.SetEmptyRgn(this._ID());
    }

    public void setRect(int n, int n2, int n3, int n4) {
        int n5 = n2 + n4;
        int n6 = n + n3;
        if (isMacOS || QTSession.isCurrentOS(4)) {
            Region.SetRectRgn(this._ID(), (short)n, (short)n2, (short)n6, (short)n5);
        } else {
            Region.MacSetRectRgn(this._ID(), (short)n, (short)n2, (short)n6, (short)n5);
        }
    }

    public void offset(int n, int n2) {
        if (isMacOS || QTSession.isCurrentOS(4)) {
            Region.OffsetRgn(this._ID(), (short)n, (short)n2);
        } else {
            Region.MacOffsetRgn(this._ID(), (short)n, (short)n2);
        }
    }

    public void inset(int n, int n2) {
        Region.InsetRgn(this._ID(), (short)n, (short)n2);
    }

    public Region sect(Region region) throws QTException {
        int n = Region.NewRgn();
        if (n == 0) {
            QDException.checkError(-108);
        }
        Region.SectRgn(this._ID(), QTObject.ID(region), n);
        return new Region(n);
    }

    public Region sect(QDRect qDRect) throws QTException {
        int n = Region.NewRgn();
        if (n == 0) {
            QDException.checkError(-108);
        }
        Region.RectRgn(n, qDRect.getRect());
        int n2 = Region.NewRgn();
        if (n2 == 0) {
            Region.DisposeRgn(n);
            QDException.checkError(-108);
        }
        Region.SectRgn(this._ID(), n, n2);
        Region.DisposeRgn(n);
        return new Region(n2);
    }

    public Region union(Region region) throws QTException {
        int n = Region.NewRgn();
        if (n == 0) {
            QDException.checkError(-108);
        }
        if (isMacOS || QTSession.isCurrentOS(4)) {
            Region.UnionRgn(this._ID(), QTObject.ID(region), n);
        } else {
            Region.MacUnionRgn(this._ID(), QTObject.ID(region), n);
        }
        return new Region(n);
    }

    public Region union(QDRect qDRect) throws QTException {
        int n = Region.NewRgn();
        if (n == 0) {
            QDException.checkError(-108);
        }
        Region.RectRgn(n, qDRect.getRect());
        int n2 = Region.NewRgn();
        if (n2 == 0) {
            QDException.checkError(-108);
        }
        if (isMacOS || QTSession.isCurrentOS(4)) {
            Region.UnionRgn(this._ID(), n, n2);
        } else {
            Region.MacUnionRgn(this._ID(), n, n2);
        }
        return new Region(n2);
    }

    public Region diff(Region region) throws QTException {
        int n = Region.NewRgn();
        if (n == 0) {
            QDException.checkError(-108);
        }
        Region.DiffRgn(this._ID(), QTObject.ID(region), n);
        return new Region(n);
    }

    public Region xor(Region region) throws QTException {
        int n = Region.NewRgn();
        if (n == 0) {
            QDException.checkError(-108);
        }
        if (isMacOS || QTSession.isCurrentOS(4)) {
            Region.XorRgn(this._ID(), QTObject.ID(region), n);
        } else {
            Region.MacXorRgn(this._ID(), QTObject.ID(region), n);
        }
        return new Region(n);
    }

    public boolean rectIn(QDRect qDRect) {
        return Region.RectInRgn(qDRect.getRect(), this._ID()) != 0;
    }

    public boolean equalRgn(Region region) {
        if (isMacOS || QTSession.isCurrentOS(4)) {
            return Region.EqualRgn(this._ID(), QTObject.ID(region)) != 0;
        }
        return Region.MacEqualRgn(this._ID(), QTObject.ID(region)) != 0;
    }

    public boolean empty() {
        return Region.EmptyRgn(this._ID()) != 0;
    }

    public void map(QDRect qDRect, QDRect qDRect2) {
        Region.MapRgn(this._ID(), qDRect.getRect(), qDRect2.getRect());
    }

    public boolean pointIn(QDPoint qDPoint) {
        return Region.PtInRgn(qDPoint.getPoint(), this._ID()) != 0;
    }

    public String toString() {
        return super.toString() + "[rgnBBox=" + this.getRgnBBox() + "]";
    }

    private static native void SetGWorld(int var0, int var1);

    private static native void GetGWorld(int[] var0, int[] var1);

    private static native void OpenRgn();

    private static native void CloseRgn(int var0);

    private static native int NewRgn();

    private static native short MemError();

    private static native void SectRgn(int var0, int var1, int var2);

    private static native int GraphicsImportGetClip(int var0, int[] var1);

    private static native int GraphicsImportGetDefaultClip(int var0, int[] var1);

    private static native int GetMovieDisplayClipRgn(int var0);

    private static native short GetMoviesError();

    private static native int GetMovieDisplayBoundsRgn(int var0);

    private static native int GetMovieClipRgn(int var0);

    private static native int GetMovieBoundsRgn(int var0);

    private static native int GetMovieSegmentDisplayBoundsRgn(int var0, int var1, int var2);

    private static native int MCGetControllerBoundsRgn(int var0);

    private static native int MCGetWindowRgn(int var0, int var1);

    private static native int MCGetClip(int var0, int[] var1, int[] var2);

    private static native int MCDrawBadge(int var0, int var1, int[] var2);

    private static native int GetTrackClipRgn(int var0);

    private static native int GetTrackDisplayBoundsRgn(int var0);

    private static native int GetTrackMovieBoundsRgn(int var0);

    private static native int GetTrackBoundsRgn(int var0);

    private static native int GetTrackSegmentDisplayBoundsRgn(int var0, int var1, int var2);

    private static native int SGGetChannelClip(int var0, int[] var1);

    private static native short BitMapToRegion(int var0, int var1);

    private static native void RectRgn(int var0, byte[] var1);

    private static native void MacCopyRgn(int var0, int var1);

    private static native void SetEmptyRgn(int var0);

    private static native void MacSetRectRgn(int var0, short var1, short var2, short var3, short var4);

    private static native void MacOffsetRgn(int var0, short var1, short var2);

    private static native void InsetRgn(int var0, short var1, short var2);

    private static native void DisposeRgn(int var0);

    private static native void MacUnionRgn(int var0, int var1, int var2);

    private static native void DiffRgn(int var0, int var1, int var2);

    private static native void MacXorRgn(int var0, int var1, int var2);

    private static native byte RectInRgn(byte[] var0, int var1);

    private static native byte MacEqualRgn(int var0, int var1);

    private static native byte EmptyRgn(int var0);

    private static native void MapRgn(int var0, byte[] var1, byte[] var2);

    private static native byte PtInRgn(int var0, int var1);

    private static native int getIntFromPointer(int var0, int var1);

    private static native void PaintRgn(int var0);

    private static native void CopyRgn(int var0, int var1);

    private static native void SetRectRgn(int var0, short var1, short var2, short var3, short var4);

    private static native void OffsetRgn(int var0, short var1, short var2);

    private static native void UnionRgn(int var0, int var1, int var2);

    private static native void XorRgn(int var0, int var1, int var2);

    private static native byte EqualRgn(int var0, int var1);

    private static native byte GetRegionBounds(int var0, byte[] var1);

    private static native byte IsRegionRectangular(int var0);

    private static native short QTSPresGetClip(int var0, int var1, int[] var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$qd$Region == null ? (class$quicktime$qd$Region = Region.class$("quicktime.qd.Region")) : class$quicktime$qd$Region);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
        isMacOS = QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4);
        savedPort = new int[]{0};
        savedDevice = new int[]{0};
    }
}

