/*
 * Decompiled with CFR 0.152.
 */
package quicktime.qd3d.camera;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.jdirect.PrimitivesLib;
import quicktime.jdirect.QTNative;
import quicktime.qd3d.camera.CameraPlacement;
import quicktime.qd3d.camera.CameraRange;
import quicktime.qd3d.camera.CameraViewPort;
import quicktime.util.EndianDescriptor;
import quicktime.util.EndianOrder;
import quicktime.util.QTByteObject;

public class CameraData
extends QTByteObject
implements PrimitivesLib,
Cloneable {
    private static Object linkage;
    public static final int kNativeSize = 60;
    private static final long serialVersionUID = 8266295306447856273L;
    static /* synthetic */ Class class$quicktime$qd3d$camera$CameraData;

    public static final EndianDescriptor getEndianDescriptor() {
        return EndianDescriptor.flipAll32;
    }

    public CameraData() {
        this(60);
    }

    public CameraData(CameraPlacement cameraPlacement, CameraRange cameraRange, CameraViewPort cameraViewPort) {
        this();
        this.setPlacement(cameraPlacement);
        this.setRange(cameraRange);
        this.setViewPort(cameraViewPort);
    }

    CameraData(byte[] byArray) {
        super(byArray);
    }

    CameraData(int n) {
        super(n);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        int n = objectInputStream.readInt();
        this.bytes = new byte[n];
        objectInputStream.read(this.bytes);
        for (int i = 0; i < 60; i += 4) {
            int n2 = CameraData.getIntFromArray(this.bytes, i);
            int n3 = EndianOrder.flipBigEndianToNative32(n2);
            CameraData.setIntInArray(this.getBytes(), i, n3);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        byte[] byArray = this.getBytes();
        int n = this.getSize();
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; i += 4) {
            int n2 = CameraData.getIntFromArray(this.getBytes(), i);
            int n3 = EndianOrder.flipNativeToBigEndian32(n2);
            CameraData.setIntInArray(byArray, i, n3);
        }
        objectOutputStream.write(byArray);
    }

    public final CameraPlacement getPlacement() {
        CameraPlacement cameraPlacement = new CameraPlacement();
        System.arraycopy(this.getBytes(), 0, cameraPlacement.getBytes(), 0, 36);
        return cameraPlacement;
    }

    public final void setPlacement(CameraPlacement cameraPlacement) {
        System.arraycopy(cameraPlacement.getBytes(), 0, this.getBytes(), 0, 36);
    }

    public final CameraRange getRange() {
        CameraRange cameraRange = new CameraRange();
        System.arraycopy(this.getBytes(), 36, cameraRange.getBytes(), 0, 8);
        return cameraRange;
    }

    public final void setRange(CameraRange cameraRange) {
        System.arraycopy(cameraRange.getBytes(), 0, this.getBytes(), 36, 8);
    }

    public final CameraViewPort getViewPort() {
        CameraViewPort cameraViewPort = new CameraViewPort();
        System.arraycopy(this.getBytes(), 44, cameraViewPort.getBytes(), 0, 16);
        return cameraViewPort;
    }

    public final void setViewPort(CameraViewPort cameraViewPort) {
        System.arraycopy(cameraViewPort.getBytes(), 0, this.getBytes(), 44, 16);
    }

    final void setCameraBytes(CameraData cameraData) {
        System.arraycopy(cameraData.getBytes(), 0, this.getBytes(), 0, 60);
    }

    public Object clone() {
        return new CameraData(this.bytes);
    }

    public String toString() {
        return this.getClass().getName();
    }

    private static native int getIntFromArray(byte[] var0, int var1);

    private static native void setIntInArray(byte[] var0, int var1, int var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (QTSession.isCurrentOS(4)) {
            throw new QTRuntimeException("Unsupported OS");
        }
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$qd3d$camera$CameraData == null ? (class$quicktime$qd3d$camera$CameraData = CameraData.class$("quicktime.qd3d.camera.CameraData")) : class$quicktime$qd3d$camera$CameraData);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

