/*
 * Decompiled with CFR 0.152.
 */
package quicktime.qd3d.camera;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.jdirect.PrimitivesLib;
import quicktime.jdirect.QTNative;
import quicktime.qd3d.math.Point3D;
import quicktime.qd3d.math.Vector3D;
import quicktime.util.EndianDescriptor;
import quicktime.util.EndianOrder;
import quicktime.util.QTByteObject;

public final class CameraPlacement
extends QTByteObject
implements PrimitivesLib {
    private static Object linkage;
    public static final int kNativeSize = 36;
    private static final long serialVersionUID = -2481353228250322010L;
    static /* synthetic */ Class class$quicktime$qd3d$camera$CameraPlacement;

    public static final EndianDescriptor getEndianDescriptor() {
        return EndianDescriptor.flipAll32;
    }

    public CameraPlacement() {
        super(36);
    }

    public CameraPlacement(Point3D point3D, Point3D point3D2, Vector3D vector3D) {
        this();
        this.setCameraLocation(point3D);
        this.setPointOfInterest(point3D2);
        this.setUpVector(vector3D);
    }

    private CameraPlacement(byte[] byArray) {
        super(byArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[36];
        byte[] byArray = new byte[36];
        objectInputStream.read(byArray);
        for (int i = 0; i < 36; i += 4) {
            int n = CameraPlacement.getIntFromArray(byArray, i);
            int n2 = EndianOrder.flipBigEndianToNative32(n);
            CameraPlacement.setIntInArray(this.getBytes(), i, n2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        byte[] byArray = this.getBytes();
        for (int i = 0; i < 36; i += 4) {
            int n = CameraPlacement.getIntFromArray(this.getBytes(), i);
            int n2 = EndianOrder.flipNativeToBigEndian32(n);
            CameraPlacement.setIntInArray(byArray, i, n2);
        }
        objectOutputStream.write(byArray);
    }

    public Point3D getCameraLocation() {
        Point3D point3D = new Point3D();
        System.arraycopy(this.getBytes(), 0, point3D.getBytes(), 0, point3D.getBytes().length);
        return point3D;
    }

    public Point3D getPointOfInterest() {
        Point3D point3D = new Point3D();
        System.arraycopy(this.getBytes(), 12, point3D.getBytes(), 0, point3D.getBytes().length);
        return point3D;
    }

    public Vector3D getUpVector() {
        return new Vector3D(this.getFloatAt(24), this.getFloatAt(28), this.getFloatAt(32));
    }

    public void setCameraLocation(Point3D point3D) {
        this.setFloatAt(0, point3D.getX());
        this.setFloatAt(4, point3D.getY());
        this.setFloatAt(8, point3D.getZ());
    }

    public void setPointOfInterest(Point3D point3D) {
        this.setFloatAt(12, point3D.getX());
        this.setFloatAt(16, point3D.getY());
        this.setFloatAt(20, point3D.getZ());
    }

    public void setUpVector(Vector3D vector3D) {
        this.setFloatAt(24, vector3D.getX());
        this.setFloatAt(28, vector3D.getY());
        this.setFloatAt(32, vector3D.getZ());
    }

    public Object clone() {
        return new CameraPlacement(this.bytes);
    }

    public String toString() {
        return super.toString() + "[location=" + this.getCameraLocation() + ",interest=" + this.getPointOfInterest() + ",upVector=" + this.getUpVector() + "]";
    }

    private static native int getIntFromArray(byte[] var0, int var1);

    private static native void setIntInArray(byte[] var0, int var1, int var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (QTSession.isCurrentOS(4)) {
            throw new QTRuntimeException("Unsupported OS");
        }
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$qd3d$camera$CameraPlacement == null ? (class$quicktime$qd3d$camera$CameraPlacement = CameraPlacement.class$("quicktime.qd3d.camera.CameraPlacement")) : class$quicktime$qd3d$camera$CameraPlacement);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

