/*
 * Decompiled with CFR 0.152.
 */
package quicktime.qd3d.camera;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.qd.QDPoint;
import quicktime.util.EndianDescriptor;
import quicktime.util.EndianOrder;
import quicktime.util.QTByteObject;
import quicktime.util.UtilException;

public final class CameraViewPort
extends QTByteObject
implements Cloneable {
    public static final int kNativeSize = 16;
    static final long serialVersionUID = -480864256741555003L;

    public static final EndianDescriptor getEndianDescriptor() {
        return EndianDescriptor.flipAll32;
    }

    public CameraViewPort() {
        super(16);
    }

    public CameraViewPort(QDPoint qDPoint, float f, float f2) {
        this();
        this.setOrigin(qDPoint);
        this.setWidth(f);
        this.setHeight(f2);
    }

    protected CameraViewPort(byte[] byArray) {
        super(byArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[16];
        CameraViewPort cameraViewPort = new CameraViewPort();
        objectInputStream.read(cameraViewPort.getBytes());
        try {
            EndianOrder.flipBigEndianToNative(cameraViewPort, 0, CameraViewPort.getEndianDescriptor());
        }
        catch (UtilException utilException) {
            utilException.printStackTrace();
        }
        System.arraycopy(cameraViewPort.getBytes(), 0, this.getBytes(), 0, this.bytes.length);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        CameraViewPort cameraViewPort = (CameraViewPort)this.clone();
        try {
            EndianOrder.flipNativeToBigEndian(cameraViewPort, 0, CameraViewPort.getEndianDescriptor());
        }
        catch (UtilException utilException) {
            utilException.printStackTrace();
        }
        objectOutputStream.write(cameraViewPort.getBytes());
    }

    public QDPoint getOrigin() {
        return QDPoint.fromArray(this.getBytes(), -8);
    }

    public float getWidth() {
        return this.getFloatAt(8);
    }

    public float getHeight() {
        return this.getFloatAt(12);
    }

    public void setOrigin(QDPoint qDPoint) {
        this.setFloatAt(0, qDPoint.getXF());
        this.setFloatAt(4, qDPoint.getYF());
    }

    public void setWidth(float f) {
        this.setFloatAt(8, f);
    }

    public void setHeight(float f) {
        this.setFloatAt(12, f);
    }

    public Object clone() {
        return new CameraViewPort(this.bytes);
    }

    public String toString() {
        return this.getClass().getName();
    }

    static {
        if (QTSession.isCurrentOS(4)) {
            throw new QTRuntimeException("Unsupported OS");
        }
    }
}

