/*
 * Decompiled with CFR 0.152.
 */
package quicktime.qd3d.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickDraw3DLib;
import quicktime.jdirect.QuickTimeLib;
import quicktime.qd3d.math.Matrix4x4;
import quicktime.qd3d.math.Vector3D;
import quicktime.util.EndianDescriptor;
import quicktime.util.EndianOrder;
import quicktime.util.QTByteObject;
import quicktime.util.UtilException;

public final class Quaternion
extends QTByteObject
implements QuickTimeLib,
QuickDraw3DLib,
Cloneable {
    private static Object linkage;
    public static final int kNativeSize = 16;
    static final long serialVersionUID = -3634140697957637093L;
    static /* synthetic */ Class class$quicktime$qd3d$math$Quaternion;

    public static final EndianDescriptor getEndianDescriptor() {
        return EndianDescriptor.flipAll32;
    }

    public Quaternion() {
        super(16);
        this.setIdentity();
    }

    public Quaternion(float f, float f2, float f3, float f4) {
        this();
        this.setW(f);
        this.setX(f2);
        this.setY(f3);
        this.setZ(f4);
    }

    private Quaternion(Object object) {
        super(16);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[16];
        objectInputStream.read(this.bytes);
        try {
            EndianOrder.flipBigEndianToNative(this, 0, Quaternion.getEndianDescriptor());
        }
        catch (UtilException utilException) {
            utilException.printStackTrace();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Quaternion quaternion = (Quaternion)this.clone();
        try {
            EndianOrder.flipNativeToBigEndian(quaternion, 0, Quaternion.getEndianDescriptor());
        }
        catch (UtilException utilException) {
            utilException.printStackTrace();
        }
        objectOutputStream.write(quaternion.getBytes());
    }

    public float getW() {
        return this.getFloatAt(0);
    }

    public float getX() {
        return this.getFloatAt(4);
    }

    public float getY() {
        return this.getFloatAt(8);
    }

    public float getZ() {
        return this.getFloatAt(12);
    }

    public void setW(float f) {
        this.setFloatAt(0, f);
    }

    public void setX(float f) {
        this.setFloatAt(4, f);
    }

    public void setY(float f) {
        this.setFloatAt(8, f);
    }

    public void setZ(float f) {
        this.setFloatAt(12, f);
    }

    public Quaternion copy() {
        Quaternion quaternion = new Quaternion((Object)null);
        int n = Quaternion.Q3Quaternion_Copy(this.getBytes(), quaternion.getBytes());
        return quaternion;
    }

    public void setIdentity() {
        int n = Quaternion.Q3Quaternion_SetIdentity(this.getBytes());
    }

    public boolean isIdentity() {
        return Quaternion.Q3Quaternion_IsIdentity(this.getBytes()) != 0;
    }

    public Quaternion invert() {
        Quaternion quaternion = new Quaternion((Object)null);
        int n = Quaternion.Q3Quaternion_Invert(this.getBytes(), quaternion.getBytes());
        return quaternion;
    }

    public Quaternion multiply(Quaternion quaternion) {
        Quaternion quaternion2 = new Quaternion((Object)null);
        int n = Quaternion.Q3Quaternion_Multiply(this.getBytes(), quaternion.getBytes(), quaternion2.getBytes());
        return quaternion2;
    }

    public Quaternion normalize() {
        Quaternion quaternion = new Quaternion((Object)null);
        int n = Quaternion.Q3Quaternion_Normalize(this.getBytes(), quaternion.getBytes());
        return quaternion;
    }

    public float dot(Quaternion quaternion) {
        return Quaternion.Q3Quaternion_Dot(this.getBytes(), quaternion.getBytes());
    }

    public void setRotateAboutAxis(Vector3D vector3D, float f) {
        int n = Quaternion.Q3Quaternion_SetRotateAboutAxis(this.getBytes(), vector3D.getBytes(), f);
    }

    public void setRotateX(float f) {
        int n = Quaternion.Q3Quaternion_SetRotate_X(this.getBytes(), f);
    }

    public void setRotateY(float f) {
        int n = Quaternion.Q3Quaternion_SetRotate_Y(this.getBytes(), f);
    }

    public void setRotateZ(float f) {
        int n = Quaternion.Q3Quaternion_SetRotate_Z(this.getBytes(), f);
    }

    public void setRotateXYZ(float f, float f2, float f3) {
        int n = Quaternion.Q3Quaternion_SetRotate_XYZ(this.getBytes(), f, f2, f3);
    }

    public void setMatrix(Matrix4x4 matrix4x4) {
        int n = Quaternion.Q3Quaternion_SetMatrix(this.getBytes(), matrix4x4.getBytes());
    }

    public void setRotateVectorToVector(Vector3D vector3D, Vector3D vector3D2) {
        int n = Quaternion.Q3Quaternion_SetRotateVectorToVector(this.getBytes(), vector3D.getBytes(), vector3D2.getBytes());
    }

    public Quaternion matchReflection(Quaternion quaternion) {
        Quaternion quaternion2 = new Quaternion((Object)null);
        int n = Quaternion.Q3Quaternion_MatchReflection(this.getBytes(), quaternion.getBytes(), quaternion2.getBytes());
        return quaternion2;
    }

    public Quaternion interpolateFast(Quaternion quaternion, float f) {
        Quaternion quaternion2 = new Quaternion((Object)null);
        int n = Quaternion.Q3Quaternion_InterpolateFast(this.getBytes(), quaternion.getBytes(), f, quaternion2.getBytes());
        return quaternion2;
    }

    public Quaternion interpolateLinear(Quaternion quaternion, float f) {
        Quaternion quaternion2 = new Quaternion((Object)null);
        int n = Quaternion.Q3Quaternion_InterpolateLinear(this.getBytes(), quaternion.getBytes(), f, quaternion2.getBytes());
        return quaternion2;
    }

    public Object clone() {
        return this.copy();
    }

    private static native int Q3Quaternion_Copy(byte[] var0, byte[] var1);

    private static native int Q3Quaternion_SetIdentity(byte[] var0);

    private static native int Q3Quaternion_IsIdentity(byte[] var0);

    private static native int Q3Quaternion_Invert(byte[] var0, byte[] var1);

    private static native int Q3Quaternion_Multiply(byte[] var0, byte[] var1, byte[] var2);

    private static native int Q3Quaternion_Normalize(byte[] var0, byte[] var1);

    private static native float Q3Quaternion_Dot(byte[] var0, byte[] var1);

    private static native int Q3Quaternion_SetRotateAboutAxis(byte[] var0, byte[] var1, float var2);

    private static native int Q3Quaternion_SetRotate_X(byte[] var0, float var1);

    private static native int Q3Quaternion_SetRotate_Y(byte[] var0, float var1);

    private static native int Q3Quaternion_SetRotate_Z(byte[] var0, float var1);

    private static native int Q3Quaternion_SetRotate_XYZ(byte[] var0, float var1, float var2, float var3);

    private static native int Q3Quaternion_SetMatrix(byte[] var0, byte[] var1);

    private static native int Q3Quaternion_SetRotateVectorToVector(byte[] var0, byte[] var1, byte[] var2);

    private static native int Q3Quaternion_MatchReflection(byte[] var0, byte[] var1, byte[] var2);

    private static native int Q3Quaternion_InterpolateFast(byte[] var0, byte[] var1, float var2, byte[] var3);

    private static native int Q3Quaternion_InterpolateLinear(byte[] var0, byte[] var1, float var2, byte[] var3);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (QTSession.isCurrentOS(4)) {
            throw new QTRuntimeException("Unsupported OS");
        }
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$qd3d$math$Quaternion == null ? (class$quicktime$qd3d$math$Quaternion = Quaternion.class$("quicktime.qd3d.math.Quaternion")) : class$quicktime$qd3d$math$Quaternion);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

