/*
 * Decompiled with CFR 0.152.
 */
package quicktime.sound;

import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTSession;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.sound.SoundException;
import quicktime.std.StdQTException;
import quicktime.std.sg.SGSoundChannel;
import quicktime.util.QTUtils;

public final class SPBDevice
extends QTObject
implements QuickTimeLib {
    private static Object linkage;
    static /* synthetic */ Class class$quicktime$sound$SPBDevice;

    public static String getIndexedDevice(int n) throws SoundException {
        byte[] byArray = new byte[256];
        int[] nArray = new int[]{0};
        short s = SPBDevice.SPBGetIndexedDevice((short)n, byArray, nArray);
        if (s == -221) {
            return null;
        }
        SPBDevice.DisposeHandle(nArray[0]);
        SoundException.checkError(s);
        return QTUtils.PString2String(byArray, 0);
    }

    public static SPBDevice fromSoundChannel(SGSoundChannel sGSoundChannel) throws StdQTException {
        int n = SPBDevice.SGGetSoundInputDriver(QTObject.ID(sGSoundChannel));
        return new SPBDevice(n, sGSoundChannel);
    }

    public SPBDevice(String string, int n) throws SoundException {
        super(SPBDevice.allocate(string, n), null);
    }

    private static int allocate(String string, int n) throws SoundException {
        int[] nArray = new int[]{0};
        if (n == 1 && QTSession.hasSecurityRestrictions()) {
            throw new SecurityException("Only able to record sound with security settings when class is signed");
        }
        SoundException.checkError(SPBDevice.SPBOpenDevice(string == null ? null : QTUtils.String2PString(string, 255), (short)n, nArray));
        return nArray[0];
    }

    private SPBDevice(int n, Object object) {
        super(n, object);
    }

    private void getDeviceInfo(int n, byte[] byArray) throws SoundException {
        SoundException.checkError(SPBDevice.SPBGetDeviceInfo(this._ID(), n, byArray));
    }

    private void getDeviceInfo(int n, int n2) throws SoundException {
        SoundException.checkError(SPBDevice.SPBGetDeviceInfo(this._ID(), n, n2));
    }

    private void getDeviceInfo(int n, short[] sArray) throws SoundException {
        SoundException.checkError(SPBDevice.SPBGetDeviceInfo(this._ID(), n, sArray));
    }

    private void getDeviceInfo(int n, int[] nArray) throws SoundException {
        SoundException.checkError(SPBDevice.SPBGetDeviceInfo(this._ID(), n, nArray));
    }

    private void setDeviceInfo(int n, short[] sArray) throws SoundException {
        SoundException.checkError(SPBDevice.SPBSetDeviceInfo(this._ID(), n, sArray));
    }

    private void setDeviceInfo(int n, int[] nArray) throws SoundException {
        SoundException.checkError(SPBDevice.SPBSetDeviceInfo(this._ID(), n, nArray));
    }

    public int millisecondsToBytes(int n) throws SoundException {
        int[] nArray = new int[]{n};
        SoundException.checkError(SPBDevice.SPBMillisecondsToBytes(this._ID(), nArray));
        return nArray[0];
    }

    public int bytesToMilliseconds(int n) throws SoundException {
        int[] nArray = new int[]{n};
        SoundException.checkError(SPBDevice.SPBBytesToMilliseconds(this._ID(), nArray));
        return nArray[0];
    }

    public void setLevelMeterOnOff(boolean bl) throws SoundException {
        short[] sArray = new short[]{(short)(bl ? 1 : 0)};
        this.setDeviceInfo(1819108724, sArray);
    }

    public boolean getLevelMeterOnOff() throws SoundException {
        short[] sArray = new short[]{0, 0};
        this.getDeviceInfo(1819108724, sArray);
        return sArray[0] != 0;
    }

    public int getLevelMeterLevel() throws SoundException {
        short[] sArray = new short[]{0, 0};
        this.getDeviceInfo(1819108724, sArray);
        return sArray[1];
    }

    public void setAutomaticGainControl(boolean bl) throws SoundException {
        short[] sArray = new short[]{(short)(bl ? 1 : 0)};
        this.setDeviceInfo(1634165536, sArray);
    }

    public boolean getAutomaticGainControl() throws SoundException {
        short[] sArray = new short[]{0};
        this.getDeviceInfo(1634165536, sArray);
        return sArray[0] != 0;
    }

    public void setInputGain(float f) throws SoundException {
        int[] nArray = new int[]{QTUtils.X2Fix(f)};
        this.setDeviceInfo(1734437230, nArray);
    }

    public float getInputGain() throws SoundException {
        int[] nArray = new int[]{0};
        this.getDeviceInfo(1734437230, nArray);
        return QTUtils.Fix2X(nArray[0]);
    }

    public int getInputSource() throws SoundException {
        short[] sArray = new short[]{0};
        this.getDeviceInfo(1936684402, sArray);
        return sArray[0];
    }

    public void setInputSource(int n) throws SoundException {
        short[] sArray = new short[]{(short)n};
        this.setDeviceInfo(1936684402, sArray);
    }

    public String[] getInputSourceNames() throws SoundException {
        byte[] byArray = new byte[4];
        this.getDeviceInfo(1936613741, byArray);
        int n = SPBDevice.getIntFromArray(byArray, 0);
        int n2 = SPBDevice.getShortFromHandle(n, 0);
        String[] stringArray = new String[n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            byte by = SPBDevice.getByteFromHandle(n, n3 + 2);
            byte[] byArray2 = new byte[by + 1];
            SPBDevice.copyPointerToArray(SPBDevice.getIntFromPointer(n, 0), n3 + 2, byArray2, 0, by + 1);
            stringArray[i] = QTUtils.PString2String(byArray2, 0);
            n3 = n3 + by + 1;
        }
        SPBDevice.DisposeHandle(n);
        return stringArray;
    }

    public int getChannelAvailable() throws SoundException {
        short[] sArray = new short[]{0};
        this.getDeviceInfo(1667785078, sArray);
        return sArray[0];
    }

    public int getNumberChannels() throws SoundException {
        short[] sArray = new short[]{0};
        this.getDeviceInfo(1667785070, sArray);
        return sArray[0];
    }

    public void setNumberChannels(int n) throws SoundException {
        short[] sArray = new short[]{(short)n};
        this.setDeviceInfo(1667785070, sArray);
    }

    public int getPlayThruOnOff() throws SoundException {
        short[] sArray = new short[]{0};
        this.getDeviceInfo(1886155880, sArray);
        return sArray[0];
    }

    public void setPlayThruOnOff(int n) throws SoundException {
        short[] sArray = new short[]{(short)n};
        this.setDeviceInfo(1886155880, sArray);
    }

    public void setSampleRate(float f) throws SoundException {
        int[] nArray = new int[]{QTUtils.X2UFix(f)};
        this.setDeviceInfo(1936875892, nArray);
    }

    public float getSampleRate() throws SoundException {
        int[] nArray = new int[]{0};
        this.getDeviceInfo(1936875892, nArray);
        return QTUtils.UFix2X(nArray[0]);
    }

    public float[] getSampleRateAvailable() throws SoundException {
        byte[] byArray = new byte[6];
        this.getDeviceInfo(1936941430, byArray);
        short s = SPBDevice.getShortFromArray(byArray, 0);
        float[] fArray = null;
        fArray = s == 0 ? new float[2] : new float[s];
        for (int i = 0; i < fArray.length; ++i) {
            int n = SPBDevice.getIntFromHandle(SPBDevice.getIntFromArray(byArray, 2), i * 4);
            fArray[i] = QTUtils.UFix2X(n);
        }
        SPBDevice.DisposeHandle(SPBDevice.getIntFromArray(byArray, 2));
        return fArray;
    }

    public void setSampleSize(int n) throws SoundException {
        short[] sArray = new short[]{(short)n};
        this.setDeviceInfo(1936943482, sArray);
    }

    public int getSampleSize() throws SoundException {
        short[] sArray = new short[]{0};
        this.getDeviceInfo(1936943482, sArray);
        return sArray[0];
    }

    public int[] getSampleSizeAvailable() throws SoundException {
        byte[] byArray = new byte[6];
        this.getDeviceInfo(1936941430, byArray);
        int n = SPBDevice.getShortFromArray(byArray, 0);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = SPBDevice.getShortFromHandle(SPBDevice.getIntFromArray(byArray, 2), i * 2);
        }
        SPBDevice.DisposeHandle(SPBDevice.getIntFromArray(byArray, 2));
        return nArray;
    }

    public void setStereoInputGain(float f, float f2) throws SoundException {
        int[] nArray = new int[]{QTUtils.X2Fix(f), QTUtils.X2Fix(f2)};
        this.setDeviceInfo(1936154985, nArray);
    }

    public float getStereoInputGainLeft() throws SoundException {
        int[] nArray = new int[]{0, 0};
        this.getDeviceInfo(1936154985, nArray);
        return QTUtils.Fix2X(nArray[0]);
    }

    public float getStereoInputGainRight() throws SoundException {
        int[] nArray = new int[]{0, 0};
        this.getDeviceInfo(1936154985, nArray);
        return QTUtils.Fix2X(nArray[1]);
    }

    public boolean getContinuousRecording() throws SoundException {
        short[] sArray = new short[]{0};
        this.getDeviceInfo(1668247156, sArray);
        return sArray[0] == 1;
    }

    public void setContinuousRecording(boolean bl) throws SoundException {
        short[] sArray = new short[]{(short)(bl ? 1 : 0)};
        this.setDeviceInfo(1668247156, sArray);
    }

    public void setCompressionType(int n) throws SoundException {
        int[] nArray = new int[]{n};
        this.setDeviceInfo(1668246896, nArray);
    }

    public int getCompressionType() throws SoundException {
        int[] nArray = new int[]{0};
        this.getDeviceInfo(1668246896, nArray);
        return nArray[0];
    }

    public int[] getCompressionAvailable() throws SoundException {
        byte[] byArray = new byte[6];
        this.getDeviceInfo(1668112758, byArray);
        int n = SPBDevice.getShortFromArray(byArray, 0);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = SPBDevice.getIntFromHandle(SPBDevice.getIntFromArray(byArray, 2), i * 4);
        }
        SPBDevice.DisposeHandle(SPBDevice.getIntFromArray(byArray, 2));
        return nArray;
    }

    public boolean hasOptionsDialog() throws SoundException {
        short[] sArray = new short[]{0};
        this.getDeviceInfo(1869640804, sArray);
        return sArray[0] != 0;
    }

    public void showOptionsDialog() throws SoundException {
        int[] nArray = new int[]{0};
        this.setDeviceInfo(1869640804, nArray);
    }

    public String getName() throws SoundException {
        byte[] byArray = new byte[256];
        this.getDeviceInfo(1851878757, byArray);
        return QTUtils.PString2String(byArray, 0);
    }

    public int[] getActiveLevels() throws SoundException {
        int n = this.getNumberChannels();
        int n2 = SPBDevice.NewPtr(n * 2);
        this.getDeviceInfo(1819107683, n2);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = SPBDevice.getShortFromPointer(n2, i * 2);
        }
        SPBDevice.DisposePtr(n2);
        return nArray;
    }

    public String toString() {
        try {
            return this.getClass().getName() + "[name=" + this.getName() + "]";
        }
        catch (QTException qTException) {
            return super.toString();
        }
    }

    private static native int SGGetSoundInputDriver(int var0);

    private static native short SPBOpenDevice(byte[] var0, short var1, int[] var2);

    private static native short SPBGetDeviceInfo(int var0, int var1, int[] var2);

    private static native short SPBSetDeviceInfo(int var0, int var1, int[] var2);

    private static native short SPBGetDeviceInfo(int var0, int var1, short[] var2);

    private static native short SPBSetDeviceInfo(int var0, int var1, short[] var2);

    private static native short SPBGetDeviceInfo(int var0, int var1, byte[] var2);

    private static native short SPBGetDeviceInfo(int var0, int var1, int var2);

    private static native short SPBMillisecondsToBytes(int var0, int[] var1);

    private static native short SPBBytesToMilliseconds(int var0, int[] var1);

    private static native short getShortFromArray(byte[] var0, int var1);

    private static native int getIntFromArray(byte[] var0, int var1);

    private static native byte getByteFromHandle(int var0, int var1);

    private static native void copyPointerToArray(int var0, int var1, byte[] var2, int var3, int var4);

    private static native int getIntFromPointer(int var0, int var1);

    private static native short getShortFromPointer(int var0, int var1);

    private static native int getIntFromHandle(int var0, int var1);

    private static native void DisposeHandle(int var0);

    private static native short getShortFromHandle(int var0, int var1);

    private static native short SPBGetIndexedDevice(short var0, byte[] var1, int[] var2);

    private static native int NewPtr(int var0);

    private static native void DisposePtr(int var0);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$sound$SPBDevice == null ? (class$quicktime$sound$SPBDevice = SPBDevice.class$("quicktime.sound.SPBDevice")) : class$quicktime$sound$SPBDevice);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

