/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.clocks;

import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTObject;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.jdirect.MethodClosure;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.std.clocks.ExtremesCallBack;
import quicktime.std.clocks.InterruptClosure;
import quicktime.std.clocks.QTCallBack;
import quicktime.std.clocks.RateCallBack;
import quicktime.std.clocks.TimeCallBack;
import quicktime.std.clocks.TimeJumpCallBack;

final class CBRunner
implements Runnable,
QuickTimeLib {
    private static Object linkage;
    private static int activeCallbacks;
    private static Thread idleThread;
    private static int nCBThreads;
    private static String privActStrCached;
    private Thread cbThread;
    private CBMethodClosure mMethodClosure;
    private InterruptClosure mInterruptClosure;
    private QTCallBack cb;
    private boolean callbackDone = false;
    private int callBackTimeBase;
    private boolean notified = false;
    private boolean executing;
    static /* synthetic */ Class class$quicktime$std$clocks$CBRunner;

    CBRunner(QTCallBack qTCallBack) {
        this.cb = qTCallBack;
        this.callBackTimeBase = CBRunner.GetCallBackTimeBase(QTObject.ID(qTCallBack));
        if (QTSession.isCurrentOS(1)) {
            this.mInterruptClosure = new InterruptClosure(960, this);
            ++activeCallbacks;
            if (idleThread == null) {
                idleThread = new Thread(new MRJIdler());
                idleThread.start();
            }
        } else {
            this.mMethodClosure = new CBMethodClosure(this, "callBackProc", "(II)V", 960);
        }
        privActStrCached = "CBThread-" + nCBThreads++ + "-";
        if (qTCallBack instanceof TimeCallBack) {
            privActStrCached = privActStrCached + "TC";
        } else if (qTCallBack instanceof TimeJumpCallBack) {
            privActStrCached = privActStrCached + "TJ";
        } else if (qTCallBack instanceof RateCallBack) {
            privActStrCached = privActStrCached + "RC";
        } else if (qTCallBack instanceof ExtremesCallBack) {
            privActStrCached = privActStrCached + "EC";
        }
        class QTJPrivelegedAction {
            QTJPrivelegedAction() {
            }

            Object doPrivelegedAction() {
                return AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ QTJPrivelegedAction this$1;
                    {
                        this.this$1 = qTJPrivelegedAction;
                    }

                    public Object run() {
                        return new Thread((Runnable)QTJPrivelegedAction.access$300(this.this$1), CBRunner.access$400());
                    }
                });
            }

            static /* synthetic */ CBRunner access$300(QTJPrivelegedAction qTJPrivelegedAction) {
                return qTJPrivelegedAction.CBRunner.this;
            }
        }
        this.cbThread = QTSession.getJavaVersion() == 65537 ? new Thread((Runnable)this, privActStrCached) : (Thread)new QTJPrivelegedAction().doPrivelegedAction();
        this.cbThread.setPriority(10);
        this.cbThread.start();
    }

    final void cleanup() {
        this.callbackDone = true;
        if (QTSession.isCurrentOS(1) && --activeCallbacks < 1) {
            idleThread = null;
            activeCallbacks = 0;
        }
        this.doNotify();
    }

    final int getClosure() {
        if (this.mInterruptClosure != null) {
            return this.mInterruptClosure.fetchPointer();
        }
        if (this.mMethodClosure != null) {
            return this.mMethodClosure.getClosure();
        }
        throw new QTRuntimeException("No Method Closure object created");
    }

    private final void callBackProc(int n, int n2) {
        this.doNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.doWait();
        if (!this.callbackDone) {
            do {
                this.notified = false;
                Object object = QTSession.terminationLock();
                synchronized (object) {
                    if (QTSession.isInitialized()) {
                        if (this.callbackDone) {
                            break;
                        }
                        this.cb.timeWhenCalledMsecs = CBRunner.GetTimeBaseTime(this.callBackTimeBase, 1000, 0);
                        this.cb.rateWhenCalled = (float)CBRunner.GetTimeBaseEffectiveRate(this.callBackTimeBase) / 65536.0f;
                        if (this.cb.rateWhenCalled < 0.0f) {
                            ++this.cb.timeWhenCalledMsecs;
                        }
                        if (this.callbackDone) {
                            break;
                        }
                    } else {
                        break;
                    }
                    this.executing = true;
                    this.cb.execute();
                }
                if (this.callbackDone) break;
                this.doWait();
            } while (this.notified);
        }
        if (this.cb.upp == this) {
            this.cb.upp = null;
        }
        this.cbThread = null;
        this.mMethodClosure = null;
    }

    private synchronized void doWait() {
        this.executing = false;
        if (this.notified || this.callbackDone) {
            return;
        }
        try {
            this.wait();
            this.notified = true;
        }
        catch (InterruptedException interruptedException) {
            this.notified = false;
        }
    }

    synchronized void doNotify() {
        if (this.executing) {
            this.notified = true;
            return;
        }
        this.notified = true;
        this.notifyAll();
    }

    private static native int GetTimeBaseEffectiveRate(int var0);

    private static native int GetTimeBaseTime(int var0, int var1, int var2);

    private static native int GetCallBackTimeBase(int var0);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ String access$400() {
        return privActStrCached;
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$std$clocks$CBRunner == null ? (class$quicktime$std$clocks$CBRunner = CBRunner.class$("quicktime.std.clocks.CBRunner")) : class$quicktime$std$clocks$CBRunner);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
        activeCallbacks = 0;
    }

    static class CBMethodClosure
    extends MethodClosure {
        CBMethodClosure(Object object, String string, String string2, int n) {
            super(object, string, string2, n);
        }

        int getClosure() {
            return this.closure;
        }
    }

    static class MRJIdler
    implements Runnable {
        MRJIdler() {
        }

        public void run() {
            try {
                while (activeCallbacks >= 1) {
                    Thread.sleep(10L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            idleThread = null;
        }
    }
}

