/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.movies;

import com.apple.mrj.macos.carbon.CarbonAccess;
import com.apple.mrj.macos.carbon.CarbonEventClient;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTSession;
import quicktime.io.OpenFile;
import quicktime.io.OpenMovieFile;
import quicktime.io.QTFile;
import quicktime.io.QTIOException;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.jdirect.QuickTimeVRLib;
import quicktime.qd.ColorTable;
import quicktime.qd.GDevice;
import quicktime.qd.Pict;
import quicktime.qd.QDException;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDPoint;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.StdQTException;
import quicktime.std.clocks.Clock;
import quicktime.std.clocks.TimeBase;
import quicktime.std.clocks.TimeRecord;
import quicktime.std.image.Matrix;
import quicktime.std.movies.AtomContainer;
import quicktime.std.movies.ExecutingWiredAction;
import quicktime.std.movies.IdleDispatcher;
import quicktime.std.movies.MovieDrawingComplete;
import quicktime.std.movies.MovieEditState;
import quicktime.std.movies.MovieInfo;
import quicktime.std.movies.MoviePrePreroll;
import quicktime.std.movies.MovieProgress;
import quicktime.std.movies.MoviesDispatcher;
import quicktime.std.movies.NextTaskNeededSooner;
import quicktime.std.movies.SearchResult;
import quicktime.std.movies.StatusInfo;
import quicktime.std.movies.TimeInfo;
import quicktime.std.movies.Track;
import quicktime.std.movies.media.DataRef;
import quicktime.std.movies.media.UserData;
import quicktime.std.qtcomponents.MovieExporter;
import quicktime.std.qtcomponents.MovieImporter;
import quicktime.std.sg.SequenceGrabber;
import quicktime.util.QTHandle;
import quicktime.util.QTPointer;
import quicktime.util.QTUtils;

public final class Movie
extends QTObject
implements QuickTimeLib,
QuickTimeVRLib {
    private static Object linkage;
    private static final int[] savedPort;
    private static final int[] savedDevice;
    private Object dataRef = null;
    private MoviesDispatcher drawingUPP;
    private MoviesDispatcher preUPP;
    private MoviesDispatcher progUPP;
    private MoviesDispatcher wiredUPP;
    private static Hashtable dispatchers;
    static /* synthetic */ Class class$quicktime$std$movies$Movie;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void taskAll(int n) throws QTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.GetGWorld(savedPort, savedDevice);
            }
            if (!QTSession.isInitialized()) {
                throw new QTException("QuickTime is NOT initialized");
            }
            Movie.MoviesTask(0, n);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Movie createMovieFile(QTFile qTFile, int n, int n2) throws QTException {
        if ((n2 & Integer.MIN_VALUE) != 0) {
            try {
                QTFile.checkSecurity(qTFile.getCanonicalPath(), 1024);
            }
            catch (IOException iOException) {
                throw new QTIOException(iOException.getMessage());
            }
        }
        int[] nArray = new int[]{0};
        if ((n2 & 0x40000000) != 0) {
            n2 ^= 0x40000000;
        }
        short s = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.GetGWorld(savedPort, savedDevice);
            }
            Movie.SetGWorld(QTObject.ID(QDGraphics.scratch), 0);
            s = Movie.CreateMovieFile(qTFile.getFSSpec(false, 512), n, (short)-1, n2 | 0x20000000, null, nArray);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(s);
        return new Movie(nArray[0], null);
    }

    public static Movie fromSequenceGrabber(SequenceGrabber sequenceGrabber) {
        int n = Movie.SGGetMovie(QTObject.ID(sequenceGrabber));
        return new Movie(n, sequenceGrabber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Movie fromScrap(int n) throws QTException {
        int n2 = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.GetGWorld(savedPort, savedDevice);
            }
            Movie.SetGWorld(QTObject.ID(QDGraphics.scratch), 0);
            n2 = Movie.NewMovieFromScrap(n);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(Movie.GetMoviesError());
        if (n2 == 0) {
            throw new StdQTException(-2010);
        }
        object = new Movie(n2, null);
        super.init();
        return object;
    }

    public static Movie fromFile(OpenMovieFile openMovieFile) throws QTException {
        return Movie.fromFile(openMovieFile, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Movie fromFile(OpenMovieFile openMovieFile, int n, MovieInfo movieInfo) throws QTException {
        int[] nArray = new int[1];
        short s = (short)QTObject.ID(openMovieFile);
        short[] sArray = new short[1];
        byte[] byArray = new byte[255];
        byte[] byArray2 = new byte[1];
        short s2 = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.GetGWorld(savedPort, savedDevice);
            }
            Movie.SetGWorld(QTObject.ID(QDGraphics.scratch), 0);
            s2 = Movie.NewMovieFromFile(nArray, s, sArray, byArray, (short)n, byArray2);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(s2);
        if (nArray[0] == 0) {
            throw new StdQTException(-2010);
        }
        if (movieInfo != null) {
            movieInfo.setMovieInfo(sArray[0], byArray2[0] == 1, new String(byArray, 1, byArray.length - 1));
        }
        object = new Movie(nArray[0], null);
        super.init();
        return object;
    }

    public static Movie fromHandle(QTHandle qTHandle) throws QTException {
        return Movie.fromHandle(qTHandle, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Movie fromHandle(QTHandle qTHandle, int n, MovieInfo movieInfo) throws QTException {
        int[] nArray = new int[1];
        int n2 = QTObject.ID(qTHandle);
        byte[] byArray = new byte[1];
        short s = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.GetGWorld(savedPort, savedDevice);
            }
            Movie.SetGWorld(QTObject.ID(QDGraphics.scratch), 0);
            s = Movie.NewMovieFromHandle(nArray, n2, (short)n, byArray);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(s);
        if (nArray[0] == 0) {
            throw new StdQTException(-2010);
        }
        if (movieInfo != null) {
            movieInfo.setMovieInfo(0, byArray[0] == 1, null);
        }
        object = new Movie(nArray[0], null);
        super.init();
        ((Movie)object).dataRef = qTHandle;
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Movie fromDataFork(OpenFile openFile, int n, int n2, MovieInfo movieInfo) throws QTException, QDException {
        int[] nArray = new int[]{0};
        short s = (short)QTObject.ID(openFile);
        byte[] byArray = new byte[1];
        short s2 = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.GetGWorld(savedPort, savedDevice);
            }
            Movie.SetGWorld(QTObject.ID(QDGraphics.scratch), 0);
            s2 = Movie.NewMovieFromDataFork(nArray, s, n, (short)n2, byArray);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(s2);
        if (nArray[0] == 0) {
            throw new StdQTException(-2010);
        }
        if (movieInfo != null) {
            movieInfo.setMovieInfo(0, byArray[0] == 1, "");
        }
        object = new Movie(nArray[0], null);
        super.init();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Movie fromDataRef(DataRef dataRef, int n) throws QTException {
        int[] nArray = new int[]{0};
        short[] sArray = new short[]{0};
        short s = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.GetGWorld(savedPort, savedDevice);
            }
            Movie.SetGWorld(QTObject.ID(QDGraphics.scratch), 0);
            s = Movie.NewMovieFromDataRef(nArray, (short)n, sArray, QTObject.ID(dataRef), dataRef == null ? 0 : dataRef.getType());
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        if (nArray[0] == 0) {
            throw new StdQTException(-2012);
        }
        StdQTException.checkError(s);
        object = new Movie(nArray[0], null);
        super.init();
        ((Movie)object).dataRef = dataRef;
        return object;
    }

    Movie(int n, Object object) {
        super(n, object);
    }

    public Movie() throws QTException {
        this(1);
    }

    public Movie(int n) throws QTException {
        super(Movie.allocate(n));
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int allocate(int n) throws StdQTException, QDException {
        int n2 = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.GetGWorld(savedPort, savedDevice);
            }
            Movie.SetGWorld(QTObject.ID(QDGraphics.scratch), 0);
            n2 = Movie.NewMovie(n);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(Movie.GetMoviesError());
        if (n2 == 0) {
            throw new StdQTException(-2010);
        }
        return n2;
    }

    private void init() throws StdQTException {
        QDRect qDRect = this.getBounds();
        qDRect.setX(0);
        qDRect.setY(0);
        this.setBounds(qDRect);
    }

    void _setNR(int n) {
        this.setNR(n);
    }

    public int addResource(OpenMovieFile openMovieFile, int n, String string) throws StdQTException {
        short[] sArray = new short[]{(short)n};
        byte[] byArray = string != null ? QTUtils.String2PString(string, 255) : null;
        short s = Movie.AddMovieResource(this._ID(), (short)QTObject.ID(openMovieFile), sArray, byArray);
        StdQTException.checkError(s);
        return sArray[0];
    }

    public void updateResource(OpenMovieFile openMovieFile, int n, String string) throws StdQTException {
        byte[] byArray = string != null ? QTUtils.String2PString(string, 255) : null;
        short s = Movie.UpdateMovieResource(this._ID(), (short)QTObject.ID(openMovieFile), (short)n, byArray);
        StdQTException.checkError(s);
    }

    public void removeResource(OpenMovieFile openMovieFile, int n) throws StdQTException {
        short s = Movie.RemoveMovieResource((short)QTObject.ID(openMovieFile), (short)n);
        StdQTException.checkError(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void task(int n) throws QTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.GetGWorld(savedPort, savedDevice);
            }
            Movie.MoviesTask(this._ID(), n);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    public void setDrawingCompleteProc(int n, MovieDrawingComplete movieDrawingComplete) throws StdQTException {
        if (movieDrawingComplete == null) {
            this.removeDrawingCompleteProc();
            return;
        }
        if (this.drawingUPP != null) {
            this.removeDrawingCompleteProc();
        }
        this.drawingUPP = new MoviesDispatcher(this, movieDrawingComplete);
        Movie.SetMovieDrawingCompleteProc(this._ID(), n, this.drawingUPP.ID(), 0);
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public void removeDrawingCompleteProc() throws StdQTException {
        Movie.SetMovieDrawingCompleteProc(this._ID(), 0, 0, 0);
        if (this.drawingUPP != null) {
            this.drawingUPP.cleanupMethodClosure();
        }
        this.drawingUPP = null;
        StdQTException.checkError(Movie.GetMoviesError());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preroll(int n, float f) throws StdQTException {
        if (QTSession.isCurrentOS(4)) {
            Object object = QTNative.globalsLock;
            synchronized (object) {
                short s = Movie.PrerollMovie(this._ID(), n, QTUtils.X2Fix(f));
                StdQTException.checkError(s);
            }
        } else {
            short s = Movie.PrerollMovie(this._ID(), n, QTUtils.X2Fix(f));
            StdQTException.checkError(s);
        }
    }

    public void prePreroll(int n, float f) throws StdQTException {
        this.preUPP = null;
        this.prePreroll(n, f, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prePreroll(int n, float f, MoviePrePreroll moviePrePreroll) throws StdQTException {
        if (QTSession.getQTMajorVersion() == 3) {
            if (moviePrePreroll != null) {
                moviePrePreroll.execute(this, 0);
            }
            return;
        }
        if (moviePrePreroll == null) {
            moviePrePreroll = new MoviePrePreroll(){

                public void execute(Movie movie, int n) {
                }
            };
        }
        this.preUPP = new MoviesDispatcher(this, moviePrePreroll);
        Object object = QTNative.globalsLock;
        synchronized (object) {
            short s = Movie.PrePrerollMovie(this._ID(), n, QTUtils.X2Fix(f), this.preUPP.ID(), 0);
            StdQTException.checkError(s);
        }
    }

    public void abortPrePreroll(int n) throws StdQTException {
        if (QTSession.getQTMajorVersion() == 3) {
            return;
        }
        Movie.AbortPrePrerollMovie(this._ID(), (short)n);
        if (this.preUPP != null) {
            this.preUPP.cleanupMethodClosure();
            this.preUPP = null;
        }
    }

    public void loadIntoRam(int n, int n2, int n3) throws StdQTException {
        short s = Movie.LoadMovieIntoRam(this._ID(), n, n2, n3);
        StdQTException.checkError(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(boolean bl) throws StdQTException {
        if (QTSession.isCurrentOS(4)) {
            Object object = QTNative.globalsLock;
            synchronized (object) {
                byte by = (byte)(bl ? 1 : 0);
                Movie.SetMovieActive(this._ID(), by);
                StdQTException.checkError(Movie.GetMoviesError());
            }
        } else {
            byte by = (byte)(bl ? 1 : 0);
            Movie.SetMovieActive(this._ID(), by);
            StdQTException.checkError(Movie.GetMoviesError());
        }
    }

    public boolean getActive() throws StdQTException {
        byte by = Movie.GetMovieActive(this._ID());
        StdQTException.checkError(Movie.GetMoviesError());
        return by == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            Movie.StartMovie(this._ID());
        }
        StdQTException.checkError(Movie.GetMoviesError());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            Movie.StopMovie(this._ID());
        }
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public void goToBeginning() throws StdQTException {
        Movie.GoToBeginningOfMovie(this._ID());
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public void goToEnd() throws StdQTException {
        Movie.GoToEndOfMovie(this._ID());
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public boolean isDone() throws StdQTException {
        byte by = Movie.IsMovieDone(this._ID());
        StdQTException.checkError(Movie.GetMoviesError());
        return by == 1;
    }

    public boolean getPreviewMode() throws StdQTException {
        byte by = Movie.GetMoviePreviewMode(this._ID());
        StdQTException.checkError(Movie.GetMoviesError());
        return by == 1;
    }

    public void setPreviewMode(boolean bl) throws StdQTException {
        byte by = (byte)(bl ? 1 : 0);
        Movie.SetMoviePreviewMode(this._ID(), by);
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public void showPoster() throws StdQTException {
        Movie.ShowMoviePoster(this._ID());
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public void playPreview() throws StdQTException {
        Movie.PlayMoviePreview(this._ID(), 0, 0);
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public QDGraphics getGWorld() throws StdQTException {
        return QDGraphics.fromMovie(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGWorld(QDGraphics qDGraphics, GDevice gDevice) throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            Movie.SetMovieGWorld(this._ID(), QTObject.ID(qDGraphics), QTObject.ID(gDevice));
            StdQTException.checkError(Movie.GetMoviesError());
        }
    }

    public QDRect getNaturalBoundsRect() throws StdQTException {
        QDRect qDRect = new QDRect();
        Movie.GetMovieNaturalBoundsRect(this._ID(), qDRect.getRect());
        StdQTException.checkError(Movie.GetMoviesError());
        return qDRect;
    }

    public Track getNextTrackForCompositing(Track track) throws QTException {
        int n = Movie.GetNextTrackForCompositing(this._ID(), QTObject.ID(track));
        StdQTException.checkError(Movie.GetMoviesError());
        return new Track(n, this);
    }

    public Track getPrevTrackForCompositing(Track track) throws QTException {
        int n = Movie.GetPrevTrackForCompositing(this._ID(), QTObject.ID(track));
        StdQTException.checkError(Movie.GetMoviesError());
        return new Track(n, this);
    }

    public Pict getPict(int n) throws QTException {
        return Pict.fromMovie(this, n);
    }

    public Pict getPosterPict() throws QTException {
        return Pict.fromMovie(this);
    }

    public void update() throws StdQTException {
        short s = Movie.UpdateMovie(this._ID());
        StdQTException.checkError(s);
    }

    public void invalidateRegion(Region region) throws StdQTException {
        short s = Movie.InvalidateMovieRegion(this._ID(), QTObject.ID(region));
        StdQTException.checkError(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QDRect getBounds() throws StdQTException {
        if (QTSession.isCurrentOS(4)) {
            Object object = QTNative.globalsLock;
            synchronized (object) {
                QDRect qDRect = new QDRect();
                Movie.GetMovieBox(this._ID(), qDRect.getRect());
                StdQTException.checkError(Movie.GetMoviesError());
                return qDRect;
            }
        }
        QDRect qDRect = new QDRect();
        Movie.GetMovieBox(this._ID(), qDRect.getRect());
        StdQTException.checkError(Movie.GetMoviesError());
        return qDRect;
    }

    public QDRect getBox() throws StdQTException {
        return this.getBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBounds(QDRect qDRect) throws StdQTException {
        if (QTSession.isCurrentOS(4)) {
            Object object = QTNative.globalsLock;
            synchronized (object) {
                Movie.SetMovieBox(this._ID(), qDRect.getRect());
                StdQTException.checkError(Movie.GetMoviesError());
            }
        } else {
            Movie.SetMovieBox(this._ID(), qDRect.getRect());
            StdQTException.checkError(Movie.GetMoviesError());
        }
    }

    public void setBox(QDRect qDRect) throws StdQTException {
        this.setBounds(qDRect);
    }

    public Region getDisplayClipRgn() throws QTException {
        return Region.fromMovieDisplayClip(this);
    }

    public void setDisplayClipRgn(Region region) throws StdQTException {
        Movie.SetMovieDisplayClipRgn(this._ID(), QTObject.ID(region));
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public Region getClipRgn() throws QTException {
        return Region.fromMovieClip(this);
    }

    public void setClipRgn(Region region) throws StdQTException {
        Movie.SetMovieClipRgn(this._ID(), QTObject.ID(region));
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public Region getDisplayBoundsRgn() throws QTException {
        return Region.fromMovieDisplayBounds(this);
    }

    public Region getBoundsRgn() throws QTException {
        return Region.fromMovieBounds(this);
    }

    public void putIntoHandle(QTHandle qTHandle) throws StdQTException {
        short s = Movie.PutMovieIntoHandle(this._ID(), QTObject.ID(qTHandle));
        StdQTException.checkError(s);
    }

    public void putIntoDataFork(OpenMovieFile openMovieFile, int n, int n2) throws StdQTException {
        short s = (short)QTObject.ID(openMovieFile);
        short s2 = Movie.PutMovieIntoDataFork(this._ID(), s, n, n2);
        StdQTException.checkError(s2);
    }

    public int getCreationTime() throws StdQTException {
        int n = Movie.GetMovieCreationTime(this._ID());
        StdQTException.checkError(Movie.GetMoviesError());
        return n;
    }

    public int getModificationTime() throws StdQTException {
        int n = Movie.GetMovieModificationTime(this._ID());
        StdQTException.checkError(Movie.GetMoviesError());
        return n;
    }

    public int getTimeScale() throws StdQTException {
        int n = Movie.GetMovieTimeScale(this._ID());
        StdQTException.checkError(Movie.GetMoviesError());
        return n;
    }

    public void setTimeScale(int n) throws StdQTException {
        Movie.SetMovieTimeScale(this._ID(), n);
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public int getDuration() throws StdQTException {
        int n = Movie.GetMovieDuration(this._ID());
        StdQTException.checkError(Movie.GetMoviesError());
        return n;
    }

    public float getRate() throws StdQTException {
        int n = Movie.GetMovieRate(this._ID());
        StdQTException.checkError(Movie.GetMoviesError());
        return QTUtils.Fix2X(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRate(float f) throws StdQTException {
        if (QTSession.isCurrentOS(4)) {
            Object object = QTNative.globalsLock;
            synchronized (object) {
                Movie.SetMovieRate(this._ID(), QTUtils.X2Fix(f));
                StdQTException.checkError(Movie.GetMoviesError());
            }
        } else {
            Movie.SetMovieRate(this._ID(), QTUtils.X2Fix(f));
            StdQTException.checkError(Movie.GetMoviesError());
        }
    }

    public float getPreferredRate() throws StdQTException {
        int n = Movie.GetMoviePreferredRate(this._ID());
        StdQTException.checkError(Movie.GetMoviesError());
        return QTUtils.Fix2X(n);
    }

    public void setPreferredRate(float f) throws StdQTException {
        Movie.SetMoviePreferredRate(this._ID(), QTUtils.X2Fix(f));
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public float getPreferredVolume() throws StdQTException {
        short s = Movie.GetMoviePreferredVolume(this._ID());
        StdQTException.checkError(Movie.GetMoviesError());
        return QTUtils.ShortFix2X(s);
    }

    public void setPreferredVolume(float f) throws StdQTException {
        Movie.SetMoviePreferredVolume(this._ID(), QTUtils.X2ShortFix(f));
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public float getVolume() throws StdQTException {
        short s = Movie.GetMovieVolume(this._ID());
        StdQTException.checkError(Movie.GetMoviesError());
        return QTUtils.ShortFix2X(s);
    }

    public void setVolume(float f) throws StdQTException {
        Movie.SetMovieVolume(this._ID(), QTUtils.X2ShortFix(f));
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public Matrix getMatrix() throws StdQTException {
        Matrix matrix = new Matrix();
        Movie.GetMovieMatrix(this._ID(), matrix.getBytes());
        StdQTException.checkError(Movie.GetMoviesError());
        return matrix;
    }

    public void setMatrix(Matrix matrix) throws StdQTException {
        Movie.SetMovieMatrix(this._ID(), matrix.getBytes());
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public TimeInfo getPreviewTime() throws StdQTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Movie.GetMoviePreviewTime(this._ID(), nArray, nArray2);
        StdQTException.checkError(Movie.GetMoviesError());
        return new TimeInfo(nArray[0], nArray2[0]);
    }

    public void setPreviewTime(TimeInfo timeInfo) throws StdQTException {
        Movie.SetMoviePreviewTime(this._ID(), timeInfo.time, timeInfo.duration);
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public void setPreviewTime(int n, int n2) throws StdQTException {
        Movie.SetMoviePreviewTime(this._ID(), n, n2);
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public int getPosterTime() throws StdQTException {
        int n = Movie.GetMoviePosterTime(this._ID());
        StdQTException.checkError(Movie.GetMoviesError());
        return n;
    }

    public void setPosterTime(int n) throws StdQTException {
        Movie.SetMoviePosterTime(this._ID(), n);
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public TimeInfo getSelection() throws StdQTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Movie.GetMovieSelection(this._ID(), nArray, nArray2);
        StdQTException.checkError(Movie.GetMoviesError());
        return new TimeInfo(nArray[0], nArray2[0]);
    }

    public void setSelection(TimeInfo timeInfo) throws StdQTException {
        Movie.SetMovieSelection(this._ID(), timeInfo.time, timeInfo.duration);
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public void setSelection(int n, int n2) throws StdQTException {
        Movie.SetMovieSelection(this._ID(), n, n2);
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public void setActiveSegment(TimeInfo timeInfo) throws StdQTException {
        Movie.SetMovieActiveSegment(this._ID(), timeInfo.time, timeInfo.duration);
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public TimeInfo getActiveSegment() throws StdQTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Movie.GetMovieActiveSegment(this._ID(), nArray, nArray2);
        StdQTException.checkError(Movie.GetMoviesError());
        return new TimeInfo(nArray[0], nArray2[0]);
    }

    public int getTime() throws StdQTException {
        int n = Movie.GetMovieTime(this._ID(), 0);
        StdQTException.checkError(Movie.GetMoviesError());
        return n;
    }

    public TimeRecord getTRTime() throws QTException {
        TimeRecord timeRecord = new TimeRecord();
        int n = Movie.GetMovieTime(this._ID(), QTObject.ID(timeRecord));
        StdQTException.checkError(Movie.GetMoviesError());
        return timeRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTime(TimeRecord timeRecord) throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            Movie.SetMovieTime(this._ID(), QTObject.ID(timeRecord));
        }
        StdQTException.checkError(Movie.GetMoviesError());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeValue(int n) throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            Movie.SetMovieTimeValue(this._ID(), n);
        }
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public UserData getUserData() throws StdQTException {
        return UserData.fromMovie(this);
    }

    public int getTrackCount() throws StdQTException {
        int n = Movie.GetMovieTrackCount(this._ID());
        StdQTException.checkError(Movie.GetMoviesError());
        return n;
    }

    public Track getTrack(int n) throws QTException {
        int n2 = Movie.GetMovieTrack(this._ID(), n);
        StdQTException.checkError(Movie.GetMoviesError());
        return n2 == 0 ? null : new Track(n2, this);
    }

    public Track getIndTrack(int n) throws QTException {
        int n2 = Movie.GetMovieIndTrack(this._ID(), n);
        StdQTException.checkError(Movie.GetMoviesError());
        return n2 == 0 ? null : new Track(n2, this);
    }

    public Track getIndTrackType(int n, int n2, int n3) throws QTException {
        int n4 = Movie.GetMovieIndTrackType(this._ID(), n, n2, n3);
        StdQTException.checkError(Movie.GetMoviesError());
        return n4 == 0 ? null : new Track(n4, this);
    }

    public void removeTrack(Track track) throws StdQTException {
        if (QTObject.ID(track) == 0) {
            throw new StdQTException(-2009);
        }
        int n = Movie.GetTrackMovie(QTObject.ID(track));
        StdQTException.checkError(Movie.GetMoviesError());
        if (n != this._ID()) {
            throw new StdQTException(-2010);
        }
        Movie.DisposeMovieTrack(QTObject.ID(track));
        StdQTException.checkError(Movie.GetMoviesError());
        track.owner = null;
        track._setNR(0);
    }

    public void setAutoTrackAlternatesEnabled(boolean bl) throws StdQTException {
        byte by = (byte)(bl ? 1 : 0);
        Movie.SetAutoTrackAlternatesEnabled(this._ID(), by);
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public void selectAlternates() throws StdQTException {
        Movie.SelectMovieAlternates(this._ID());
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public TimeInfo getNextInterestingTime(int n, int[] nArray, int n2, float f) throws StdQTException {
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        short s = 0;
        if (nArray != null) {
            s = (short)nArray.length;
        }
        Movie.GetMovieNextInterestingTime(this._ID(), (short)n, s, nArray, n2, QTUtils.X2Fix(f), nArray2, nArray3);
        StdQTException.checkError(Movie.GetMoviesError());
        return new TimeInfo(nArray2[0], nArray3[0]);
    }

    public void insertEmptySegment(int n, int n2) throws StdQTException {
        short s = Movie.InsertEmptyMovieSegment(this._ID(), n, n2);
        StdQTException.checkError(s);
    }

    public void insertSegment(Movie movie, int n, int n2, int n3) throws StdQTException {
        short s = Movie.InsertMovieSegment(this._ID(), QTObject.ID(movie), n, n2, n3);
        StdQTException.checkError(s);
    }

    public void deleteSegment(int n, int n2) throws StdQTException {
        short s = Movie.DeleteMovieSegment(this._ID(), n, n2);
        StdQTException.checkError(s);
    }

    public void scaleSegment(int n, int n2, int n3) throws StdQTException {
        short s = Movie.ScaleMovieSegment(this._ID(), n, n2, n3);
        StdQTException.checkError(s);
    }

    public Movie cutSelection() throws QTException {
        int n = Movie.CutMovieSelection(this._ID());
        StdQTException.checkError(Movie.GetMoviesError());
        return new Movie(n, null);
    }

    public Movie copySelection() throws QTException {
        int n = Movie.CopyMovieSelection(this._ID());
        StdQTException.checkError(Movie.GetMoviesError());
        return new Movie(n, null);
    }

    public void pasteSelection(Movie movie) throws StdQTException {
        Movie.PasteMovieSelection(this._ID(), QTObject.ID(movie));
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public void addSelection(Movie movie) throws StdQTException {
        Movie.AddMovieSelection(this._ID(), QTObject.ID(movie));
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public void clearSelection() throws StdQTException {
        Movie.ClearMovieSelection(this._ID());
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public void pasteHandle(QTHandle qTHandle, int n, int n2, MovieImporter movieImporter) throws StdQTException {
        short s = Movie.PasteHandleIntoMovie(QTObject.ID(qTHandle), n, this._ID(), n2, QTObject.ID(movieImporter));
        StdQTException.checkError(s);
    }

    public QTHandle putIntoTypedHandle(Track track, int n, int n2, int n3, int n4, MovieExporter movieExporter) throws QTException {
        int n5 = 0;
        if (track != null) {
            n5 = QTObject.ID(track);
        }
        QTHandle qTHandle = new QTHandle(0, true);
        short s = Movie.PutMovieIntoTypedHandle(this._ID(), n5, n, QTObject.ID(qTHandle), n2, n3, n4, QTObject.ID(movieExporter));
        StdQTException.checkError(s);
        return qTHandle;
    }

    public void copySettings(Movie movie) throws StdQTException {
        short s = Movie.CopyMovieSettings(this._ID(), QTObject.ID(movie));
        StdQTException.checkError(s);
    }

    public Track addEmptyTrack(Track track, DataRef dataRef) throws QTException {
        int[] nArray = new int[1];
        short s = Movie.AddEmptyTrackToMovie(QTObject.ID(track), this._ID(), QTObject.ID(dataRef), dataRef.getType(), nArray);
        StdQTException.checkError(s);
        return new Track(nArray[0], this);
    }

    public Track newTrack(float f, float f2, float f3) throws QTException {
        return this.addTrack(f, f2, f3);
    }

    public Track addTrack(float f, float f2, float f3) throws QTException {
        return new Track(this, f, f2, f3);
    }

    public MovieEditState newEditState() throws QTException {
        int n = Movie.NewMovieEditState(this._ID());
        StdQTException.checkError(Movie.GetMoviesError());
        return new MovieEditState(this, n);
    }

    public void useEditState(MovieEditState movieEditState) throws StdQTException {
        short s = Movie.UseMovieEditState(this._ID(), QTObject.ID(movieEditState));
        StdQTException.checkError(s);
    }

    public int getDataSize(int n, int n2) throws StdQTException {
        int n3 = Movie.GetMovieDataSize(this._ID(), n, n2);
        StdQTException.checkError(Movie.GetMoviesError());
        return n3;
    }

    public boolean pointInMovie(QDPoint qDPoint) throws StdQTException {
        byte by = Movie.PtInMovie(this._ID(), qDPoint.getPoint());
        StdQTException.checkError(Movie.GetMoviesError());
        return by == 1;
    }

    public void setLanguage(int n) throws StdQTException {
        Movie.SetMovieLanguage(this._ID(), n);
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public boolean hasChanged() throws StdQTException {
        byte by = Movie.HasMovieChanged(this._ID());
        StdQTException.checkError(Movie.GetMoviesError());
        return by == 1;
    }

    public void clearChanged() throws StdQTException {
        Movie.ClearMovieChanged(this._ID());
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public void setDefaultDataRef(DataRef dataRef) throws StdQTException {
        short s = Movie.SetMovieDefaultDataRef(this._ID(), QTObject.ID(dataRef), dataRef.getType());
        StdQTException.checkError(s);
        this.dataRef = dataRef;
    }

    public DataRef getDefaultDataRef() throws QTException {
        return DataRef.fromMovie(this);
    }

    public void setColorTable(ColorTable colorTable) throws StdQTException {
        short s = Movie.SetMovieColorTable(this._ID(), QTObject.ID(colorTable));
        StdQTException.checkError(s);
    }

    public ColorTable getColorTable() throws QTException {
        return ColorTable.fromMovie(this);
    }

    public int flatten(int n, QTFile qTFile, int n2, int n3, int n4, int n5, String string) throws QTException {
        short[] sArray = new short[]{(short)n5};
        byte[] byArray = null;
        if (string != null) {
            byArray = QTUtils.String2PString(string, 255);
        }
        Movie.FlattenMovie(this._ID(), n, qTFile.getFSSpec(false, 512), n2, (short)n3, n4, sArray, byArray);
        StdQTException.checkError(Movie.GetMoviesError());
        return sArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Movie flattenData(int n, QTFile qTFile, int n2, int n3, int n4) throws QTException {
        int n5 = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.GetGWorld(savedPort, savedDevice);
            }
            int[] nArray = new int[]{0};
            int[] nArray2 = new int[]{0};
            Movie.GetMovieGWorld(this._ID(), nArray, nArray2);
            Movie.SetGWorld(nArray[0], nArray2[0]);
            n5 = Movie.FlattenMovieData(this._ID(), n, qTFile.getFSSpec(false, 512), n2, (short)n3, n4);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(Movie.GetMoviesError());
        return n5 != 0 ? new Movie(n5, null) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Movie flattenData(int n, QTHandle qTHandle) throws QTException {
        byte[] byArray = new byte[8];
        Movie.setIntInArray(byArray, 0, 1752065132);
        Movie.setIntInArray(byArray, 4, QTObject.ID(qTHandle));
        int n2 = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.GetGWorld(savedPort, savedDevice);
            }
            int[] nArray = new int[]{0};
            int[] nArray2 = new int[]{0};
            Movie.GetMovieGWorld(this._ID(), nArray, nArray2);
            Movie.SetGWorld(QTObject.ID(QDGraphics.scratch), 0);
            n2 = Movie.FlattenMovieData(this._ID(), n | 0x10, byArray, 0, (short)-1, 0);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(Movie.GetMoviesError());
        object = null;
        if (n2 != 0) {
            object = new Movie(n2, null);
            ((Movie)object).dataRef = qTHandle;
            ((Movie)object).setActive(true);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgressProc() throws StdQTException {
        int n = 0;
        if (QTSession.isCurrentOS(4)) {
            n = (Integer)CarbonAccess.invokeCarbonEventClient(new CarbonEventClient(){
                int res1 = 0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object invoke() {
                    Object object = QTNative.globalsLock;
                    synchronized (object) {
                        Movie.SetMovieProgressProc(Movie.this._ID(), -1, 0);
                    }
                    return new Integer(this.res1);
                }
            });
            StdQTException.checkError(n);
        } else {
            Object object = QTNative.globalsLock;
            synchronized (object) {
                Movie.SetMovieProgressProc(this._ID(), -1, 0);
            }
        }
        if (this.progUPP != null) {
            this.progUPP.cleanupMethodClosure();
            this.progUPP = null;
        }
        StdQTException.checkError(Movie.GetMoviesError());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgressProc(MovieProgress movieProgress) throws StdQTException {
        boolean bl = false;
        if (movieProgress == null) {
            this.setProgressProc();
            return;
        }
        if (this.progUPP != null) {
            this.progUPP.cleanupMethodClosure();
        }
        this.progUPP = new MoviesDispatcher(this, movieProgress);
        Object object = QTNative.globalsLock;
        synchronized (object) {
            Movie.SetMovieProgressProc(this._ID(), this.progUPP.ID(), 0);
        }
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public void addExecuteWiredActionsProc(ExecutingWiredAction executingWiredAction) throws StdQTException {
        if (executingWiredAction == null) {
            throw new StdQTException(-50);
        }
        if (this.wiredUPP != null) {
            Movie.RemoveMovieExecuteWiredActionsProc(this._ID(), this.wiredUPP.ID(), 0);
            this.wiredUPP.cleanupMethodClosure();
        }
        this.wiredUPP = new MoviesDispatcher(this, executingWiredAction);
        StdQTException.checkError(Movie.AddMovieExecuteWiredActionsProc(this._ID(), this.wiredUPP.ID(), 0));
    }

    public void removeExecuteWiredActionsProc() throws StdQTException {
        if (this.wiredUPP != null) {
            short s = Movie.RemoveMovieExecuteWiredActionsProc(this._ID(), this.wiredUPP.ID(), 0);
            this.wiredUPP.cleanupMethodClosure();
            this.wiredUPP = null;
            StdQTException.checkError(s);
        }
    }

    public void executeWiredActions(int n, AtomContainer atomContainer) throws StdQTException {
        StdQTException.checkError(Movie.MovieExecuteWiredActions(this._ID(), n, QTObject.ID(atomContainer)));
    }

    public SearchResult searchText(QTPointer qTPointer, int n, Track track, int n2, int n3) throws QTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        nArray[0] = QTObject.ID(track);
        nArray2[0] = n2;
        nArray3[0] = n3;
        short s = Movie.MovieSearchText(this._ID(), QTObject.ID(qTPointer), qTPointer.getSize(), n, nArray, nArray2, nArray3);
        StdQTException.checkError(s);
        return new SearchResult(new Track(nArray[0], this), nArray2[0], nArray3[0]);
    }

    public SearchResult searchText(QTPointer qTPointer, int n, int n2, int n3) throws QTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        nArray[0] = 0;
        nArray2[0] = n2;
        nArray3[0] = n3;
        short s = Movie.MovieSearchText(this._ID(), QTObject.ID(qTPointer), qTPointer.getSize(), n, nArray, nArray2, nArray3);
        StdQTException.checkError(s);
        return new SearchResult(new Track(nArray[0], this), nArray2[0], nArray3[0]);
    }

    public QDRect getPosterBox() throws StdQTException {
        QDRect qDRect = new QDRect();
        Movie.GetPosterBox(this._ID(), qDRect.getRect());
        StdQTException.checkError(Movie.GetMoviesError());
        return qDRect;
    }

    public void setPosterBox(QDRect qDRect) throws StdQTException {
        Movie.SetPosterBox(this._ID(), qDRect.getRect());
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public Region getSegmentDisplayBoundsRgn(int n, int n2) throws QTException {
        return Region.fromMovieSegment(this, n, n2);
    }

    public StatusInfo getStatus() throws QTException {
        int[] nArray = new int[1];
        int n = Movie.GetMovieStatus(this._ID(), nArray);
        if (n != 0) {
            return new StatusInfo(n, new Track(nArray[0], this));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showInformation() throws StdQTException {
        final int n = this._ID();
        if (QTSession.isCurrentOS(4)) {
            CarbonAccess.invokeCarbonEventClient(new CarbonEventClient(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object invoke() {
                    Object object = QTNative.globalsLock;
                    synchronized (object) {
                        Movie.ShowMovieInformation(n, 0, 0);
                    }
                    return null;
                }
            });
            StdQTException.checkError(Movie.GetMoviesError());
        } else {
            Object object = QTNative.globalsLock;
            synchronized (object) {
                Movie.ShowMovieInformation(this._ID(), 0, 0);
                StdQTException.checkError(Movie.GetMoviesError());
            }
        }
    }

    public void putOnScrap(int n) throws StdQTException {
        short s = Movie.PutMovieOnScrap(this._ID(), n);
        StdQTException.checkError(s);
    }

    public void setPlayHints(int n, int n2) throws StdQTException {
        Movie.SetMoviePlayHints(this._ID(), n, n2);
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public TimeBase getTimeBase() throws StdQTException {
        return TimeBase.fromMovie(this);
    }

    public void setMasterTimeBase(TimeBase timeBase, TimeRecord timeRecord) throws StdQTException {
        Movie.SetMovieMasterTimeBase(this._ID(), QTObject.ID(timeBase), QTObject.ID(timeRecord));
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public void setMasterClock(Clock clock, TimeRecord timeRecord) throws StdQTException {
        Movie.SetMovieMasterClock(this._ID(), QTObject.ID(clock), QTObject.ID(timeRecord));
        StdQTException.checkError(Movie.GetMoviesError());
    }

    public int convertToFile(Track track, QTFile qTFile, int n, int n2, int n3) throws QTException {
        return this.convertToFile(track, qTFile, n, n2, n3, 0, null);
    }

    public int convertToFile(QTFile qTFile, int n, int n2, int n3) throws QTException {
        return this.convertToFile(null, qTFile, n, n2, n3, 0, null);
    }

    public int convertToFile(QTFile qTFile, int n, int n2, int n3, int n4) throws QTException {
        return this.convertToFile(null, qTFile, n, n2, n3, n4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int convertToFile(Track track, QTFile qTFile, int n, int n2, int n3, int n4, MovieExporter movieExporter) throws QTException, StdQTException {
        short s;
        final short[] sArray = new short[1];
        final Track track2 = track;
        final int n5 = n;
        final int n6 = n2;
        final int n7 = n3;
        final int n8 = n4;
        final MovieExporter movieExporter2 = movieExporter;
        final int n9 = this._ID();
        final byte[] byArray = qTFile.getFSSpec(false, 512);
        if (QTSession.isCurrentOS(4)) {
            int n10 = (Integer)CarbonAccess.invokeCarbonEventClient(new CarbonEventClient(){
                int res1 = 0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object invoke() {
                    Object object = QTNative.globalsLock;
                    synchronized (object) {
                        this.res1 = Movie.ConvertMovieToFile(n9, QTObject.ID(track2), byArray, n5, n6, (short)n7, sArray, n8, QTObject.ID(movieExporter2));
                    }
                    return new Integer(this.res1);
                }
            });
            StdQTException.checkError(n10);
            return sArray[0];
        }
        Object object = QTNative.globalsLock;
        synchronized (object) {
            s = Movie.ConvertMovieToFile(this._ID(), QTObject.ID(track), qTFile.getFSSpec(false, 512), n, n2, (short)n3, sArray, n4, QTObject.ID(movieExporter));
        }
        StdQTException.checkError(s);
        return sArray[0];
    }

    public Track getQTVRTrack(int n) throws QTException {
        int n2 = Movie.QTVRGetQTVRTrack(this._ID(), n);
        return n2 == 0 ? null : new Track(n2, this);
    }

    public String toString() {
        try {
            return super.toString() + "[bounds=" + this.getBounds() + "]";
        }
        catch (StdQTException stdQTException) {
            return super.toString() + "[Error getting movie information.]";
        }
    }

    public final boolean needsTimeTable() throws StdQTException {
        byte[] byArray = new byte[1];
        short s = Movie.QTMovieNeedsTimeTable(this._ID(), byArray);
        StdQTException.checkError(s);
        return byArray[0] != 0;
    }

    public final int maxLoadedTimeInMovie() throws StdQTException {
        int[] nArray = new int[1];
        short s = Movie.GetMaxLoadedTimeInMovie(this._ID(), nArray);
        StdQTException.checkError(s);
        return nArray[0];
    }

    public void copyUserDataToMovie(Movie movie, boolean bl) throws StdQTException {
        StdQTException.checkError(Movie.CopyMovieUserData(this._ID(), QTObject.ID(movie), bl ? 1919970403 : 1835361639));
    }

    public void copyUserDataFromMovie(Movie movie, boolean bl) throws StdQTException {
        StdQTException.checkError(Movie.CopyMovieUserData(QTObject.ID(movie), this._ID(), bl ? 1919970403 : 1835361639));
    }

    public static void copyUserData(Movie movie, Movie movie2, int n) throws StdQTException {
        StdQTException.checkError(Movie.CopyMovieUserData(QTObject.ID(movie), QTObject.ID(movie2), n));
    }

    public void chooseClock(int n) {
        Movie.ChooseMovieClock(this._ID(), n);
    }

    public void putDataRefIntoHandle(DataRef dataRef, QTHandle qTHandle) throws StdQTException {
        StdQTException.checkError(Movie.PutMovieForDataRefIntoHandle(this._ID(), QTObject.ID(dataRef), dataRef.getType(), QTObject.ID(qTHandle)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Movie forDataRefFromHandle(DataRef dataRef, QTHandle qTHandle, int n, MovieInfo movieInfo) throws StdQTException {
        int[] nArray = new int[1];
        byte[] byArray = new byte[1];
        short s = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.GetGWorld(savedPort, savedDevice);
            }
            Movie.SetGWorld(QTObject.ID(QDGraphics.scratch), 0);
            s = Movie.NewMovieForDataRefFromHandle(nArray, QTObject.ID(qTHandle), (short)n, byArray, QTObject.ID(dataRef), dataRef.getType());
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(s);
        if (nArray[0] == 0) {
            throw new StdQTException(-2010);
        }
        if (movieInfo != null) {
            movieInfo.setMovieInfo(0, byArray[0] == 1, null);
        }
        object = new Movie(nArray[0], null);
        super.init();
        ((Movie)object).dataRef = dataRef;
        return object;
    }

    public static int getTimeUntilNextTask(int n) throws StdQTException {
        int[] nArray = new int[]{0};
        StdQTException.checkError(Movie.QTGetTimeUntilNextTask(nArray, n));
        return nArray[0];
    }

    public static void setNextTaskNeededSoonerCallback(NextTaskNeededSooner nextTaskNeededSooner, int n, int n2) throws StdQTException {
        if (nextTaskNeededSooner == null) {
            return;
        }
        IdleDispatcher idleDispatcher = new IdleDispatcher(nextTaskNeededSooner);
        IdleDispatcher idleDispatcher2 = dispatchers.put(nextTaskNeededSooner, idleDispatcher);
        StdQTException.checkError(Movie.QTInstallNextTaskNeededSoonerCallback(idleDispatcher.ID(), n, n2, 0));
    }

    public static void removeNextTaskNeededSoonerCallback(NextTaskNeededSooner nextTaskNeededSooner) throws StdQTException {
        if (nextTaskNeededSooner == null) {
            return;
        }
        IdleDispatcher idleDispatcher = (IdleDispatcher)dispatchers.get(nextTaskNeededSooner);
        idleDispatcher.cleanupMethodClosure();
        StdQTException.checkError(Movie.QTUninstallNextTaskNeededSoonerCallback(idleDispatcher.ID(), 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Movie flattenDataToDataRef(DataRef dataRef, int n, int n2, int n3, int n4) throws QTException {
        int n5 = 0;
        Movie movie = null;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.GetGWorld(savedPort, savedDevice);
            }
            int[] nArray = new int[]{0};
            int[] nArray2 = new int[]{0};
            Movie.GetMovieGWorld(this._ID(), nArray, nArray2);
            Movie.SetGWorld(nArray[0], nArray2[0]);
            n5 = Movie.FlattenMovieDataToDataRef(this._ID(), n, QTObject.ID(dataRef), dataRef.getType(), n2, (short)n3, n4);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                Movie.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(Movie.GetMoviesError());
        if (n5 != 0) {
            movie = new Movie(n5, null);
            movie.init();
            movie.dataRef = dataRef;
        }
        return movie;
    }

    public void setMovieAnchorDataRef(DataRef dataRef) throws StdQTException {
        short s = 0;
        s = Movie.SetMovieAnchorDataRef(this._ID(), QTObject.ID(dataRef), dataRef.getType());
        StdQTException.checkError(s);
    }

    private boolean isMovieProgressProc() {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        Movie.GetMovieProgressProc(this._ID(), nArray, nArray2);
        return nArray[0] != 0;
    }

    public boolean isAnchorDefaultDataRef() throws StdQTException {
        short s = 0;
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        s = Movie.GetMovieAnchorDataRef(this._ID(), nArray, nArray2, nArray3);
        StdQTException.checkError(s);
        return nArray3[0] == 1;
    }

    private static native void MoviesTask(int var0, int var1);

    private static native short GetMoviesError();

    private static native short CreateMovieFile(byte[] var0, int var1, short var2, int var3, short[] var4, int[] var5);

    private static native int SGGetMovie(int var0);

    private static native int NewMovieFromScrap(int var0);

    private static native short NewMovieFromFile(int[] var0, short var1, short[] var2, byte[] var3, short var4, byte[] var5);

    private static native short NewMovieFromHandle(int[] var0, int var1, short var2, byte[] var3);

    private static native short NewMovieFromDataFork(int[] var0, short var1, int var2, short var3, byte[] var4);

    private static native short NewMovieFromDataRef(int[] var0, short var1, short[] var2, int var3, int var4);

    private static native int NewMovie(int var0);

    private static native short AddMovieResource(int var0, short var1, short[] var2, byte[] var3);

    private static native short UpdateMovieResource(int var0, short var1, short var2, byte[] var3);

    private static native short RemoveMovieResource(short var0, short var1);

    private static native short PrerollMovie(int var0, int var1, int var2);

    private static native short LoadMovieIntoRam(int var0, int var1, int var2, int var3);

    private static native void SetMovieActive(int var0, byte var1);

    private static native byte GetMovieActive(int var0);

    private static native void StartMovie(int var0);

    private static native void StopMovie(int var0);

    private static native void GoToBeginningOfMovie(int var0);

    private static native void GoToEndOfMovie(int var0);

    private static native byte IsMovieDone(int var0);

    private static native byte GetMoviePreviewMode(int var0);

    private static native void SetMoviePreviewMode(int var0, byte var1);

    private static native void ShowMoviePoster(int var0);

    private static native void PlayMoviePreview(int var0, int var1, int var2);

    private static native void SetMovieGWorld(int var0, int var1, int var2);

    private static native void GetMovieNaturalBoundsRect(int var0, byte[] var1);

    private static native int GetNextTrackForCompositing(int var0, int var1);

    private static native int GetPrevTrackForCompositing(int var0, int var1);

    private static native short UpdateMovie(int var0);

    private static native short InvalidateMovieRegion(int var0, int var1);

    private static native void GetMovieBox(int var0, byte[] var1);

    private static native void SetMovieBox(int var0, byte[] var1);

    private static native void SetMovieDisplayClipRgn(int var0, int var1);

    private static native void SetMovieClipRgn(int var0, int var1);

    private static native short PutMovieIntoHandle(int var0, int var1);

    private static native short PutMovieIntoDataFork(int var0, short var1, int var2, int var3);

    private static native int GetMovieCreationTime(int var0);

    private static native int GetMovieModificationTime(int var0);

    private static native int GetMovieTimeScale(int var0);

    private static native void SetMovieTimeScale(int var0, int var1);

    private static native int GetMovieDuration(int var0);

    private static native int GetMovieRate(int var0);

    private static native void SetMovieRate(int var0, int var1);

    private static native int GetMoviePreferredRate(int var0);

    private static native void SetMoviePreferredRate(int var0, int var1);

    private static native short GetMoviePreferredVolume(int var0);

    private static native void SetMoviePreferredVolume(int var0, short var1);

    private static native short GetMovieVolume(int var0);

    private static native void SetMovieVolume(int var0, short var1);

    private static native void GetMovieMatrix(int var0, byte[] var1);

    private static native void SetMovieMatrix(int var0, byte[] var1);

    private static native void GetMoviePreviewTime(int var0, int[] var1, int[] var2);

    private static native void SetMoviePreviewTime(int var0, int var1, int var2);

    private static native int GetMoviePosterTime(int var0);

    private static native void SetMoviePosterTime(int var0, int var1);

    private static native void GetMovieSelection(int var0, int[] var1, int[] var2);

    private static native void SetMovieSelection(int var0, int var1, int var2);

    private static native void SetMovieActiveSegment(int var0, int var1, int var2);

    private static native void GetMovieActiveSegment(int var0, int[] var1, int[] var2);

    private static native int GetMovieTime(int var0, int var1);

    private static native void SetMovieTime(int var0, int var1);

    private static native void SetMovieTimeValue(int var0, int var1);

    private static native int GetMovieTrackCount(int var0);

    private static native int GetMovieTrack(int var0, int var1);

    private static native int GetMovieIndTrack(int var0, int var1);

    private static native int GetMovieIndTrackType(int var0, int var1, int var2, int var3);

    private static native int GetTrackMovie(int var0);

    private static native void DisposeMovieTrack(int var0);

    private static native void SetAutoTrackAlternatesEnabled(int var0, byte var1);

    private static native void SelectMovieAlternates(int var0);

    private static native void GetMovieNextInterestingTime(int var0, short var1, short var2, int[] var3, int var4, int var5, int[] var6, int[] var7);

    private static native short InsertEmptyMovieSegment(int var0, int var1, int var2);

    private static native short InsertMovieSegment(int var0, int var1, int var2, int var3, int var4);

    private static native short DeleteMovieSegment(int var0, int var1, int var2);

    private static native short ScaleMovieSegment(int var0, int var1, int var2, int var3);

    private static native int CutMovieSelection(int var0);

    private static native int CopyMovieSelection(int var0);

    private static native void PasteMovieSelection(int var0, int var1);

    private static native void AddMovieSelection(int var0, int var1);

    private static native void ClearMovieSelection(int var0);

    private static native short PasteHandleIntoMovie(int var0, int var1, int var2, int var3, int var4);

    private static native short PutMovieIntoTypedHandle(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private static native short CopyMovieSettings(int var0, int var1);

    private static native short AddEmptyTrackToMovie(int var0, int var1, int var2, int var3, int[] var4);

    private static native int NewMovieEditState(int var0);

    private static native short UseMovieEditState(int var0, int var1);

    private static native int GetMovieDataSize(int var0, int var1, int var2);

    private static native byte PtInMovie(int var0, int var1);

    private static native void SetMovieLanguage(int var0, int var1);

    private static native byte HasMovieChanged(int var0);

    private static native void ClearMovieChanged(int var0);

    private static native short SetMovieDefaultDataRef(int var0, int var1, int var2);

    private static native short SetMovieColorTable(int var0, int var1);

    private static native void FlattenMovie(int var0, int var1, byte[] var2, int var3, short var4, int var5, short[] var6, byte[] var7);

    private static native int FlattenMovieData(int var0, int var1, byte[] var2, int var3, short var4, int var5);

    private static native void setIntInArray(byte[] var0, int var1, int var2);

    private static native void SetMovieProgressProc(int var0, int var1, int var2);

    private static native void GetMovieProgressProc(int var0, int[] var1, int[] var2);

    private static native short MovieSearchText(int var0, int var1, int var2, int var3, int[] var4, int[] var5, int[] var6);

    private static native void GetPosterBox(int var0, byte[] var1);

    private static native void SetPosterBox(int var0, byte[] var1);

    private static native int GetMovieStatus(int var0, int[] var1);

    private static native void ShowMovieInformation(int var0, int var1, int var2);

    private static native short PutMovieOnScrap(int var0, int var1);

    private static native void SetMoviePlayHints(int var0, int var1, int var2);

    private static native void SetMovieMasterTimeBase(int var0, int var1, int var2);

    private static native void SetMovieMasterClock(int var0, int var1, int var2);

    private static native short ConvertMovieToFile(int var0, int var1, byte[] var2, int var3, int var4, short var5, short[] var6, int var7, int var8);

    private static native int QTVRGetQTVRTrack(int var0, int var1);

    private static native short QTMovieNeedsTimeTable(int var0, byte[] var1);

    private static native short GetMaxLoadedTimeInMovie(int var0, int[] var1);

    private static native short PrePrerollMovie(int var0, int var1, int var2, int var3, int var4);

    private static native void AbortPrePrerollMovie(int var0, short var1);

    private static native void SetMovieDrawingCompleteProc(int var0, int var1, int var2, int var3);

    private static native short AddMovieExecuteWiredActionsProc(int var0, int var1, int var2);

    private static native short RemoveMovieExecuteWiredActionsProc(int var0, int var1, int var2);

    private static native short MovieExecuteWiredActions(int var0, int var1, int var2);

    private static native void SetGWorld(int var0, int var1);

    private static native void GetGWorld(int[] var0, int[] var1);

    private static native void GetMovieGWorld(int var0, int[] var1, int[] var2);

    private static native short CopyMovieUserData(int var0, int var1, int var2);

    private static native void ChooseMovieClock(int var0, int var1);

    private static native short NewMovieForDataRefFromHandle(int[] var0, int var1, short var2, byte[] var3, int var4, int var5);

    private static native short PutMovieForDataRefIntoHandle(int var0, int var1, int var2, int var3);

    private static native int FlattenMovieDataToDataRef(int var0, int var1, int var2, int var3, int var4, short var5, int var6);

    private static native short QTGetTimeUntilNextTask(int[] var0, int var1);

    private static native short QTInstallNextTaskNeededSoonerCallback(int var0, int var1, int var2, int var3);

    private static native short QTUninstallNextTaskNeededSoonerCallback(int var0, int var1);

    private static native short SetMovieAnchorDataRef(int var0, int var1, int var2);

    private static native short GetMovieAnchorDataRef(int var0, int[] var1, int[] var2, int[] var3);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$std$movies$Movie == null ? (class$quicktime$std$movies$Movie = Movie.class$("quicktime.std.movies.Movie")) : class$quicktime$std$movies$Movie);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
        savedPort = new int[]{0};
        savedDevice = new int[]{0};
        dispatchers = new Hashtable();
    }
}

