/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.movies.media;

import quicktime.QTException;
import quicktime.std.movies.AtomContainer;
import quicktime.std.movies.media.SampleDescription;
import quicktime.util.EndianDescriptor;
import quicktime.util.EndianFlipSpec;
import quicktime.util.QTHandle;

public final class QTVRSampleDescription
extends SampleDescription {
    private static EndianDescriptor ed;

    public QTVRSampleDescription(AtomContainer atomContainer) throws QTException {
        super(QTVRSampleDescription.allocate(atomContainer), true, 1903457906);
        this.copyFromArray(16, atomContainer.getBytes(), 0, atomContainer.getSize());
    }

    private static int allocate(AtomContainer atomContainer) {
        return 16 + atomContainer.getSize();
    }

    public QTVRSampleDescription() throws QTException {
        super(16, true, 1903457906);
    }

    protected static EndianDescriptor makeED() {
        EndianDescriptor endianDescriptor = SampleDescription.makeED();
        EndianFlipSpec endianFlipSpec = new EndianFlipSpec(16, 4, 1);
        endianDescriptor.addFlipSpec(endianFlipSpec);
        return endianDescriptor;
    }

    public static EndianDescriptor getEndianDescriptor() {
        if (ed == null) {
            ed = QTVRSampleDescription.makeED();
        }
        return ed;
    }

    public void setVRWorld(AtomContainer atomContainer) throws QTException {
        int n = 16 + atomContainer.getSize();
        this.setSize(n);
        this.copyFromArray(16, atomContainer.getBytes(), 0, n);
        this.setIntAt(0, n);
    }

    public AtomContainer getVRWorld() throws QTException {
        int n = this.getSize() - 16;
        QTHandle qTHandle = new QTHandle(n, false);
        qTHandle.copyFromArray(0, this.getBytes(), 16, n);
        return AtomContainer.fromQTHandle(qTHandle);
    }
}

