/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.music;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import quicktime.util.EndianOrder;
import quicktime.util.QTByteObject;
import quicktime.util.QTUtils;

public final class InstSampleDesc
extends QTByteObject {
    public static final int kNativeSize = 46;
    static final long serialVersionUID = -7868738374047072834L;

    public InstSampleDesc() {
        super(46);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[46];
        objectInputStream.read(this.getBytes());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.getBytes());
    }

    public int getDataFormat() {
        return EndianOrder.flipBigEndianToNative32(this.getIntAt(0));
    }

    public void setDataFormat(int n) {
        this.setIntAt(0, EndianOrder.flipNativeToBigEndian32(n));
    }

    public int getNumChannels() {
        return EndianOrder.flipBigEndianToNative16(this.getShortAt(4));
    }

    public void setNumChannels(int n) {
        this.setShortAt(4, EndianOrder.flipNativeToBigEndian16((short)n));
    }

    public int getSampleSize() {
        return EndianOrder.flipBigEndianToNative16(this.getShortAt(6));
    }

    public void setSampleSize(int n) {
        this.setShortAt(6, EndianOrder.flipNativeToBigEndian16((short)n));
    }

    public float getSampleRate() {
        return QTUtils.Fix2X(this.getSampleRateRaw());
    }

    public void setSampleRate(float f) {
        this.setSampleRateRaw(QTUtils.X2Fix(f));
    }

    public int getSampleRateRaw() {
        return EndianOrder.flipBigEndianToNative32(this.getIntAt(8));
    }

    public void setSampleRateRaw(int n) {
        this.setIntAt(8, EndianOrder.flipNativeToBigEndian32(n));
    }

    public int getSampleDataID() {
        return EndianOrder.flipBigEndianToNative16(this.getShortAt(12));
    }

    public void setSampleDataID(int n) {
        this.setShortAt(12, EndianOrder.flipNativeToBigEndian16((short)n));
    }

    public int getOffset() {
        return EndianOrder.flipBigEndianToNative32(this.getIntAt(14));
    }

    public void setOffset(int n) {
        this.setIntAt(14, EndianOrder.flipNativeToBigEndian32(n));
    }

    public int getNumSamples() {
        return EndianOrder.flipBigEndianToNative32(this.getIntAt(18));
    }

    public void setNumSamples(int n) {
        this.setIntAt(18, EndianOrder.flipNativeToBigEndian32(n));
    }

    public int getLoopType() {
        return EndianOrder.flipBigEndianToNative32(this.getIntAt(22));
    }

    public void setLoopType(int n) {
        this.setIntAt(22, EndianOrder.flipNativeToBigEndian32(n));
    }

    public int getLoopStart() {
        return EndianOrder.flipBigEndianToNative32(this.getIntAt(26));
    }

    public void setLoopStart(int n) {
        this.setIntAt(26, EndianOrder.flipNativeToBigEndian32(n));
    }

    public int getLoopEnd() {
        return EndianOrder.flipBigEndianToNative32(this.getIntAt(30));
    }

    public void setLoopEnd(int n) {
        this.setIntAt(30, EndianOrder.flipNativeToBigEndian32(n));
    }

    public int getPitchNormal() {
        return EndianOrder.flipBigEndianToNative32(this.getIntAt(34));
    }

    public void setPitchNormal(int n) {
        this.setIntAt(34, EndianOrder.flipNativeToBigEndian32(n));
    }

    public int getPitchLow() {
        return EndianOrder.flipBigEndianToNative32(this.getIntAt(38));
    }

    public void setPitchLow(int n) {
        this.setIntAt(38, EndianOrder.flipNativeToBigEndian32(n));
    }

    public int getPitchHigh() {
        return EndianOrder.flipBigEndianToNative32(this.getIntAt(42));
    }

    public void setPitchHigh(int n) {
        this.setIntAt(42, EndianOrder.flipNativeToBigEndian32(n));
    }

    public String toString() {
        return this.getClass().getName() + "[dataFormat=" + QTUtils.fromOSType(this.getDataFormat()) + ",numChannels=" + this.getNumChannels() + ",sampleSize=" + this.getSampleSize() + ",sampleRate=" + this.getSampleRate() + ",sampleDataID=" + this.getSampleDataID() + ",offset=" + this.getOffset() + ",numSamples=" + this.getNumSamples() + ",loopType=" + this.getLoopType() + ",loopStart=" + this.getLoopStart() + ",loopEnd=" + this.getLoopEnd() + ",pitchNormal=" + this.getPitchNormal() + ",pitchLow=" + this.getPitchLow() + ",pitchHigh=" + this.getPitchHigh() + "]";
    }
}

