/*
 * Decompiled with CFR 0.152.
 */
package quicktime.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import quicktime.util.EncodedImage;
import quicktime.util.QTByteObject;
import quicktime.util.RawEncodedImage;

public class ByteEncodedImage
extends QTByteObject
implements EncodedImage,
Cloneable {
    private transient int rowBytes;
    static final long serialVersionUID = -2074813762531832L;

    public static ByteEncodedImage fromByteArray(byte[] byArray) {
        return new ByteEncodedImage(byArray);
    }

    public static ByteEncodedImage fromByteArray(byte[] byArray, int n) {
        return new ByteEncodedImage(byArray, n);
    }

    public ByteEncodedImage(RawEncodedImage rawEncodedImage) {
        this(rawEncodedImage.getSize());
        rawEncodedImage.copyToArray(0, this.bytes, 0, this.bytes.length);
        this.rowBytes = rawEncodedImage.getRowBytes();
    }

    public ByteEncodedImage(int n) {
        this(n, -1);
    }

    public ByteEncodedImage(int n, int n2) {
        super(n);
        this.rowBytes = n2;
    }

    private ByteEncodedImage(byte[] byArray) {
        this(byArray, -1);
    }

    private ByteEncodedImage(byte[] byArray, int n) {
        super(byArray);
        this.rowBytes = n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        int n = objectInputStream.readInt();
        this.bytes = new byte[n];
        objectInputStream.read(this.getBytes());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.getSize();
        objectOutputStream.writeInt(n);
        byte[] byArray = this.getBytes();
        objectOutputStream.write(byArray);
    }

    public Object clone() {
        byte[] byArray = new byte[this.bytes.length];
        System.arraycopy(this.bytes, 0, byArray, 0, this.bytes.length);
        return new ByteEncodedImage(byArray, this.rowBytes);
    }

    public byte getByte(int n) {
        if (n > this.getSize() || n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.getByteAt(n);
    }

    public short getShort(int n) {
        if (n > this.getSize() - 1 || n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.getShortAt(n);
    }

    public int getInt(int n) {
        if (n > this.getSize() - 3 || n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.getIntAt(n);
    }

    public int getRowBytes() {
        return this.rowBytes;
    }
}

