/*
 * Decompiled with CFR 0.152.
 */
package quicktime.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.util.QTPointerRef;
import quicktime.util.QTVectorEnumerator;
import quicktime.util.UtilException;

public abstract class QTVector
extends QTPointerRef
implements QuickTimeLib {
    private static Object linkage;
    private int mElSize;
    protected int mNumElements = 0;
    private int mInitialSize = this.getSize();
    static /* synthetic */ Class class$quicktime$util$QTVector;

    protected QTVector(int n, int n2) throws QTException {
        super(n * n2, true);
        this.mElSize = n;
    }

    private final boolean doSizeCheck() throws UtilException {
        return this.mNumElements * this.mElSize >= this.getSize();
    }

    protected void insertElement(QTPointerRef qTPointerRef, int n) throws UtilException, ArrayIndexOutOfBoundsException {
        if (n >= this.mNumElements) {
            throw new ArrayIndexOutOfBoundsException("QTVector:insert past end");
        }
        if (this.doSizeCheck()) {
            throw new ArrayIndexOutOfBoundsException("QTVector is full");
        }
        int n2 = this._ID() + this.mElSize * n;
        if (n != this.mNumElements - 1) {
            QTVector.BlockMove(n2 + 0, n2 + this.mElSize, this.mElSize * (this.mNumElements - n));
        }
        int n3 = QTObject.ID(qTPointerRef);
        QTVector.BlockMove(n3 + 0, n2 + 0, this.mElSize);
        ++this.mNumElements;
    }

    public void remove(int n) throws ArrayIndexOutOfBoundsException, UtilException {
        if (n >= this.mNumElements || this.mNumElements == 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n2 = this._ID() + this.mElSize * n;
        int n3 = this.mElSize * (this.mNumElements - n - 1);
        if (n3 > 0) {
            QTVector.BlockMove(n2 + this.mElSize, n2 + 0, n3);
        }
        --this.mNumElements;
    }

    protected void getElement(QTPointerRef qTPointerRef, int n) throws ArrayIndexOutOfBoundsException, UtilException {
        if (n >= this.mNumElements || this.mNumElements == 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n2 = QTObject.ID(qTPointerRef);
        int n3 = this._ID() + this.mElSize * n;
        QTVector.BlockMove(n3, n2, this.mElSize);
    }

    public boolean isEmpty() {
        return this.mNumElements == 0;
    }

    public void removeAll() throws UtilException {
        this.mNumElements = 0;
    }

    public int getSize() {
        return this.mNumElements * this.mElSize;
    }

    public int size() {
        return this.mNumElements;
    }

    public Enumeration elements() {
        return new QTVectorEnumerator(this);
    }

    protected abstract QTPointerRef makeElement();

    private static native void BlockMove(int var0, int var1, int var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$util$QTVector == null ? (class$quicktime$util$QTVector = QTVector.class$("quicktime.util.QTVector")) : class$quicktime$util$QTVector);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

