/*
 * Decompiled with CFR 0.152.
 */
package quicktime.vr;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.qd.QDPoint;
import quicktime.util.EndianDescriptor;
import quicktime.util.QTByteObject;

public final class QTVRCubicFace
extends QTByteObject
implements Cloneable {
    private static final int kNativeSize = 32;
    private static EndianDescriptor ed;
    static final long serialVersionUID = 5183605583657368208L;

    public QTVRCubicFace() {
        super(32);
    }

    public QTVRCubicFace(byte[] byArray) throws QTException {
        super(byArray);
        if (byArray.length != 32) {
            throw new QTException(-50);
        }
    }

    protected static EndianDescriptor makeED() {
        EndianDescriptor endianDescriptor = new EndianDescriptor(16);
        return endianDescriptor;
    }

    public static EndianDescriptor getEndianDescriptor() {
        if (ed == null) {
            ed = QTVRCubicFace.makeED();
        }
        return ed;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[32];
        QTVRCubicFace qTVRCubicFace = new QTVRCubicFace();
        objectInputStream.read(qTVRCubicFace.getBytes());
        System.arraycopy(qTVRCubicFace.getBytes(), 0, this.getBytes(), 0, this.bytes.length);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        QTVRCubicFace qTVRCubicFace = (QTVRCubicFace)this.clone();
        objectOutputStream.write(qTVRCubicFace.getBytes());
    }

    protected Object clone() {
        try {
            return new QTVRCubicFace(this.bytes);
        }
        catch (QTException qTException) {
            throw new QTRuntimeException(qTException);
        }
    }

    public float getOrientationW() {
        return this.getFloatAt(0);
    }

    public void setOrientationW(float f) {
        this.setFloatAt(0, f);
    }

    public float getOrientationX() {
        return this.getFloatAt(4);
    }

    public void setOrientationX(float f) {
        this.setFloatAt(4, f);
    }

    public float getOrientationY() {
        return this.getFloatAt(8);
    }

    public void setOrientationY(float f) {
        this.setFloatAt(8, f);
    }

    public float getOrientationZ() {
        return this.getFloatAt(12);
    }

    public void setOrientationZ(float f) {
        this.setFloatAt(12, f);
    }

    public QDPoint getCenter() {
        return new QDPoint(this.getFloatAt(16), this.getFloatAt(20));
    }

    public void setCenter(QDPoint qDPoint) {
        this.setFloatAt(16, qDPoint.getXF());
        this.setFloatAt(20, qDPoint.getYF());
    }

    public float getAspect() {
        return this.getFloatAt(24);
    }

    public void setAspect(float f) {
        this.setFloatAt(24, f);
    }

    public float getSkew() {
        return this.getFloatAt(28);
    }

    public void setSkew(float f) {
        this.setFloatAt(28, f);
    }

    public String toString() {
        return this.getClass().getName() + "[orientation W=" + this.getOrientationW() + ",X=" + this.getOrientationX() + ",Y=" + this.getOrientationY() + ",Z=" + this.getOrientationZ() + ",center=" + this.getCenter() + ",aspect=" + this.getAspect() + ",skew=" + this.getSkew() + "]";
    }
}

