/*
 * Decompiled with CFR 0.152.
 */
package quicktime.vr;

import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTException;
import quicktime.jdirect.PrimitivesLib;
import quicktime.jdirect.QTNative;
import quicktime.qd.QDPoint;
import quicktime.util.QTPointerRef;
import quicktime.util.QTUtils;

public class QTVRInterceptRecord
extends QTPointerRef
implements PrimitivesLib {
    private static Object linkage;
    private static final int kNativeSize = 44;
    static /* synthetic */ Class class$quicktime$vr$QTVRInterceptRecord;

    protected QTVRInterceptRecord(int n, Object object) {
        super(n, 44, object);
        if (object == null) {
            throw new RuntimeException("Must have an owner");
        }
    }

    public final int getSelector() {
        return this.getIntAt(4);
    }

    public final int getParamCount() {
        return this.getIntAt(16);
    }

    public float getAngle() throws QTException {
        int n = this.getSelector();
        if (n == 8192 || n == 8193) {
            int n2 = this.getIntAt(20);
            return QTVRInterceptRecord.getFloatFromPointer(n2, 0);
        }
        throw new QTException(-50);
    }

    public void setAngle(float f) throws QTException {
        int n = this.getSelector();
        if (n == 8192 || n == 8193) {
            int n2 = this.getIntAt(20);
            QTVRInterceptRecord.setFloatInPointer(n2, 0, f);
        }
        throw new QTException(-50);
    }

    public float getFieldOfView() throws QTException {
        int n = this.getSelector();
        if (n != 8194) {
            throw new QTException(-50);
        }
        int n2 = this.getIntAt(20);
        return QTVRInterceptRecord.getFloatFromPointer(n2, 0);
    }

    public void setFieldOfView(float f) throws QTException {
        int n = this.getSelector();
        if (n != 8194) {
            throw new QTException(-50);
        }
        int n2 = this.getIntAt(20);
        QTVRInterceptRecord.setFloatInPointer(n2, 0, f);
    }

    public QDPoint getViewCenter() throws QTException {
        int n = this.getSelector();
        if (n != 8195) {
            throw new QTException(-50);
        }
        int n2 = this.getIntAt(20);
        float f = QTVRInterceptRecord.getFloatFromPointer(n2, 0);
        float f2 = QTVRInterceptRecord.getFloatFromPointer(n2, 4);
        return new QDPoint(f, f2);
    }

    public void setViewCenter(QDPoint qDPoint) throws QTException {
        int n = this.getSelector();
        if (n != 8195) {
            throw new QTException(-50);
        }
        int n2 = this.getIntAt(20);
        QTVRInterceptRecord.setFloatInPointer(n2, 0, qDPoint.getXF());
        QTVRInterceptRecord.setFloatInPointer(n2, 4, qDPoint.getYF());
    }

    public int getHotSpotID() throws QTException {
        int n = this.getSelector();
        if (n == 8202 || n == 8203) {
            return this.getIntAt(20);
        }
        throw new QTException(-50);
    }

    public void setHotSpotID(int n) throws QTException {
        int n2 = this.getSelector();
        if (n2 == 8202 || n2 == 8203) {
            this.setIntAt(20, n);
        }
        throw new QTException(-50);
    }

    public int getHotSpotType() throws QTException {
        if (this.getSelector() != 8203) {
            throw new QTException(-50);
        }
        int n = this.getIntAt(24);
        return QTVRInterceptRecord.getIntFromPointer(n, 0);
    }

    public void setHotSpotType(int n) throws QTException {
        if (this.getSelector() != 8203) {
            throw new QTException(-50);
        }
        int n2 = this.getIntAt(24);
        QTVRInterceptRecord.setIntInPointer(n2, 0, n);
    }

    public String toString() {
        String string = this.getClass().getName();
        try {
            string = string + "[selector=0x" + Integer.toHexString(this.getSelector());
            string = string + ",paramCount=" + this.getParamCount();
            switch (this.getSelector()) {
                case 8192: {
                    string = string + ",pan angle (Radians)=" + this.getAngle();
                    break;
                }
                case 8193: {
                    string = string + ",tilt angle (Radians)=" + this.getAngle();
                    break;
                }
                case 8194: {
                    string = string + ",field of view (Radians)=" + this.getFieldOfView();
                    break;
                }
                case 8195: {
                    string = string + ",view center=" + this.getViewCenter();
                    break;
                }
                case 8202: {
                    string = string + ",hot spot ID=" + this.getHotSpotID();
                    break;
                }
                case 8203: {
                    string = string + ",hot spot ID=" + this.getHotSpotID();
                    string = string + ",hotSpotType='" + QTUtils.fromOSType(this.getHotSpotType()) + "'";
                    break;
                }
            }
        }
        catch (QTException qTException) {
            string = string + "MISMATCHED SELECTOR";
        }
        string = string + "]";
        return string;
    }

    private static native void setIntInPointer(int var0, int var1, int var2);

    private static native int getIntFromPointer(int var0, int var1);

    private static native void setFloatInPointer(int var0, int var1, float var2);

    private static native float getFloatFromPointer(int var0, int var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$vr$QTVRInterceptRecord == null ? (class$quicktime$vr$QTVRInterceptRecord = QTVRInterceptRecord.class$("quicktime.vr.QTVRInterceptRecord")) : class$quicktime$vr$QTVRInterceptRecord);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

