/*
 * Decompiled with CFR 0.152.
 */
package quicktime.vr;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.util.EndianDescriptor;
import quicktime.util.EndianFlipSpec;
import quicktime.util.QTUtils;
import quicktime.vr.QTVRAtom;

public final class QTVRNodeHeader
extends QTVRAtom {
    private static final int kNativeSize = 28;
    static final long serialVersionUID = 5440311233545515486L;
    private static EndianDescriptor ed;

    public QTVRNodeHeader() {
        super(28);
    }

    public QTVRNodeHeader(byte[] byArray) throws QTException {
        super(byArray, 28);
    }

    protected int getNativeSize() {
        return 28;
    }

    protected void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[28];
        QTVRNodeHeader qTVRNodeHeader = new QTVRNodeHeader();
        objectInputStream.read(qTVRNodeHeader.getBytes());
        System.arraycopy(qTVRNodeHeader.getBytes(), 0, this.getBytes(), 0, this.bytes.length);
    }

    protected void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        QTVRNodeHeader qTVRNodeHeader = (QTVRNodeHeader)this.clone();
        objectOutputStream.write(qTVRNodeHeader.getBytes());
    }

    public Object clone() {
        try {
            return new QTVRNodeHeader(this.bytes);
        }
        catch (QTException qTException) {
            throw new QTRuntimeException(qTException);
        }
    }

    protected static EndianDescriptor makeED() {
        EndianDescriptor endianDescriptor = new EndianDescriptor(0);
        EndianFlipSpec endianFlipSpec = new EndianFlipSpec(0, 2, 2);
        endianDescriptor.addFlipSpec(endianFlipSpec);
        EndianFlipSpec endianFlipSpec2 = new EndianFlipSpec(4, 4, 6);
        endianDescriptor.addFlipSpec(endianFlipSpec2);
        return endianDescriptor;
    }

    public static EndianDescriptor getEndianDescriptor() {
        if (ed == null) {
            ed = QTVRNodeHeader.makeED();
        }
        return ed;
    }

    public int getNodeType() {
        return this.getIntAt(4);
    }

    public void setNodeType(int n) {
        this.setIntAt(4, n);
    }

    public void setNodeType(String string) {
        this.setIntAt(4, QTUtils.toOSType(string));
    }

    public int getNodeID() {
        return this.getIntAt(8);
    }

    public void setNodeID(int n) {
        this.setIntAt(8, n);
    }

    public int getNameAtomID() {
        return this.getIntAt(12);
    }

    public void setNameAtomID(int n) {
        this.setIntAt(12, n);
    }

    public int getCommentAtomID() {
        return this.getIntAt(16);
    }

    public void setCommentAtomID(int n) {
        this.setIntAt(16, n);
    }

    public void setReserved1(int n) {
        this.setIntAt(20, n);
    }

    public int getReserved1() {
        return this.getIntAt(20);
    }

    public void setReserved2(int n) {
        this.setIntAt(24, n);
    }

    public int getReserved2() {
        return this.getIntAt(24);
    }

    public String toString() {
        return this.getClass().getName() + "[nodeType=" + QTUtils.fromOSType(this.getNodeType()) + ",nodeID=" + this.getNodeID() + ",nameAtomID=" + this.getNameAtomID() + ",commentAtomID" + this.getCommentAtomID() + "]";
    }
}

