/*
 * Decompiled with CFR 0.152.
 */
package quicktime.vr;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.qd.QDPoint;
import quicktime.util.EndianDescriptor;
import quicktime.util.EndianFlipSpec;
import quicktime.vr.QTVRAtom;

public final class QTVRObjectSample
extends QTVRAtom {
    private static final int kNativeSize = 88;
    public static final int kQTVRObjectAnimateViewFramesOn = 1;
    public static final int kQTVRObjectPalindromeViewFramesOn = 2;
    public static final int kQTVRObjectStartFirstViewFrameOn = 4;
    public static final int kQTVRObjectAnimateViewsOn = 8;
    public static final int kQTVRObjectPalindromeViewsOn = 16;
    public static final int kQTVRObjectSyncViewToFrameRate = 32;
    public static final int kQTVRObjectDontLoopViewFramesOn = 64;
    public static final int kQTVRObjectPlayEveryViewFrameOn = 128;
    public static final int kQTVRObjectStreamingViewsOn = 256;
    public static final int kQTVRObjectWrapPanOn = 1;
    public static final int kQTVRObjectWrapTiltOn = 2;
    public static final int kQTVRObjectCanZoomOn = 4;
    public static final int kQTVRObjectReverseHControlOn = 8;
    public static final int kQTVRObjectReverseVControlOn = 16;
    public static final int kQTVRObjectSwapHVControlOn = 32;
    public static final int kQTVRObjectTranslationOn = 64;
    public static final short kGrabberScrollerUI = 1;
    public static final short kOldJoyStickUI = 2;
    public static final short kJoystickUI = 3;
    public static final short kGrabberUI = 4;
    public static final short kAbsoluteUI = 5;
    static final long serialVersionUID = 8513787618060671940L;
    private static EndianDescriptor ed;

    public QTVRObjectSample() {
        super(88);
    }

    public QTVRObjectSample(byte[] byArray) throws QTException {
        super(byArray, 88);
    }

    protected int getNativeSize() {
        return 88;
    }

    protected void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[88];
        QTVRObjectSample qTVRObjectSample = new QTVRObjectSample();
        objectInputStream.read(qTVRObjectSample.getBytes());
        System.arraycopy(qTVRObjectSample.getBytes(), 0, this.getBytes(), 0, this.bytes.length);
    }

    protected void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        QTVRObjectSample qTVRObjectSample = (QTVRObjectSample)this.clone();
        objectOutputStream.write(qTVRObjectSample.getBytes());
    }

    public Object clone() {
        try {
            return new QTVRObjectSample(this.bytes);
        }
        catch (QTException qTException) {
            throw new QTRuntimeException(qTException);
        }
    }

    protected static EndianDescriptor makeED() {
        EndianDescriptor endianDescriptor = new EndianDescriptor(0);
        EndianFlipSpec endianFlipSpec = new EndianFlipSpec(0, 2, 6);
        endianDescriptor.addFlipSpec(endianFlipSpec);
        EndianFlipSpec endianFlipSpec2 = new EndianFlipSpec(12, 4, 19);
        endianDescriptor.addFlipSpec(endianFlipSpec2);
        return endianDescriptor;
    }

    public static EndianDescriptor getEndianDescriptor() {
        if (ed == null) {
            ed = QTVRObjectSample.makeED();
        }
        return ed;
    }

    public short getMovieType() {
        return this.getShortAt(4);
    }

    public void setMovieType(short s) {
        this.setShortAt(4, s);
    }

    public short getViewStateCount() {
        return this.getShortAt(6);
    }

    public void setViewStateCount(short s) {
        this.setShortAt(6, s);
    }

    public short getDefaultViewState() {
        return this.getShortAt(8);
    }

    public void setDefaultViewState(short s) {
        this.setShortAt(8, s);
    }

    public short getMouseDownViewState() {
        return this.getShortAt(10);
    }

    public void setMouseDownViewState(short s) {
        this.setShortAt(10, s);
    }

    public int getViewDuration() {
        return this.getIntAt(12);
    }

    public void setViewDuration(int n) {
        this.setIntAt(12, n);
    }

    public int getColumns() {
        return this.getIntAt(16);
    }

    public void setColumns(int n) {
        this.setIntAt(16, n);
    }

    public int getRows() {
        return this.getIntAt(20);
    }

    public void setRows(int n) {
        this.setIntAt(20, n);
    }

    public float getMouseMotionScale() {
        return this.getFloatAt(24);
    }

    public void setMouseMotionScale(float f) {
        this.setFloatAt(24, f);
    }

    public float getMinPan() {
        return this.getFloatAt(28);
    }

    public void setMinPan(float f) {
        this.setFloatAt(28, f);
    }

    public float getMaxPan() {
        return this.getFloatAt(32);
    }

    public void setMaxPan(float f) {
        this.setFloatAt(32, f);
    }

    public float getDefaultPan() {
        return this.getFloatAt(36);
    }

    public void setDefaultPan(float f) {
        this.setFloatAt(36, f);
    }

    public float getMinTilt() {
        return this.getFloatAt(40);
    }

    public void setMinTilt(float f) {
        this.setFloatAt(40, f);
    }

    public float getMaxTilt() {
        return this.getFloatAt(44);
    }

    public void setMaxTilt(float f) {
        this.setFloatAt(44, f);
    }

    public float getDefaultTilt() {
        return this.getFloatAt(48);
    }

    public void setDefaultTilt(float f) {
        this.setFloatAt(48, f);
    }

    public float getMinFieldOfView() {
        return this.getFloatAt(52);
    }

    public void setMinFieldOfView(float f) throws QTException {
        if ((double)f < 1.0) {
            throw new QTException(-50);
        }
        this.setFloatAt(52, f);
    }

    public float getFieldOfView() {
        return this.getFloatAt(56);
    }

    public void setFieldOfView(float f) throws QTException {
        if ((double)f < 1.0) {
            throw new QTException(-50);
        }
        this.setFloatAt(56, f);
    }

    public float getDefaultFieldOfView() {
        return this.getFloatAt(60);
    }

    public void setDefaultFieldOfView(float f) {
        this.setFloatAt(60, f);
    }

    public QDPoint getDefaultViewCenter() {
        return new QDPoint(this.getFloatAt(64), this.getFloatAt(68));
    }

    public void setDefaultViewCenter(QDPoint qDPoint) {
        this.setFloatAt(64, qDPoint.getXF());
        this.setFloatAt(68, qDPoint.getYF());
    }

    public float getViewRate() {
        return this.getFloatAt(72);
    }

    public void setViewRate(float f) {
        this.setFloatAt(72, f);
    }

    public float getFrameRate() {
        return this.getFloatAt(76);
    }

    public void setFrameRate(float f) {
        this.setFloatAt(76, f);
    }

    public int getAnimationSettings() {
        return this.getIntAt(80);
    }

    public void setAnimationSettings(int n) {
        this.setIntAt(80, n);
    }

    public int getControlSettings() {
        return this.getIntAt(84);
    }

    public void setControlSettings(int n) {
        this.setIntAt(84, n);
    }

    public String toString() {
        return this.getClass().getName() + "[movieType=" + this.getMovieType() + ",viewStateCount=" + this.getViewStateCount() + ",defaultViewState=" + this.getDefaultViewState() + ",mouseDownViewState=" + this.getMouseDownViewState() + ",viewDuration=" + this.getViewDuration() + ",columns=" + this.getColumns() + ",rows=" + this.getRows() + ",mouseMotionScale=" + this.getMouseMotionScale() + ",minPan=" + this.getMinPan() + ",maxPan=" + this.getMaxPan() + ",defaultPan=" + this.getDefaultPan() + ",minTilt=" + this.getMinTilt() + ",maxTilt=" + this.getMaxTilt() + ",defaultTilt=" + this.getDefaultTilt() + ",minFieldOfView=" + this.getMinFieldOfView() + ",fieldOfView=" + this.getFieldOfView() + ",defaultFieldOfView=" + this.getDefaultFieldOfView() + ",defaultViewCenter=" + this.getDefaultViewCenter() + ",viewRate=" + this.getViewRate() + ",frameRate=" + this.getFrameRate() + ",animationSettings=" + this.getAnimationSettings() + ",controlSettings" + this.getControlSettings() + "]";
    }
}

