/*
 * Decompiled with CFR 0.152.
 */
package quicktime.vr;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.util.EndianDescriptor;
import quicktime.util.EndianFlipSpec;
import quicktime.vr.QTVRAtom;

public final class QTVRPanoImaging
extends QTVRAtom {
    private static final int kNativeSize = 56;
    static final long serialVersionUID = 8351228396821852032L;
    private static EndianDescriptor ed;

    public QTVRPanoImaging() {
        super(56);
    }

    public QTVRPanoImaging(byte[] byArray) throws QTException {
        super(byArray, 56);
    }

    protected int getNativeSize() {
        return 56;
    }

    protected void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[56];
        QTVRPanoImaging qTVRPanoImaging = new QTVRPanoImaging();
        objectInputStream.read(qTVRPanoImaging.getBytes());
        System.arraycopy(qTVRPanoImaging.getBytes(), 0, this.getBytes(), 0, this.bytes.length);
    }

    protected void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        QTVRPanoImaging qTVRPanoImaging = (QTVRPanoImaging)this.clone();
        objectOutputStream.write(qTVRPanoImaging.getBytes());
    }

    public Object clone() {
        try {
            return new QTVRPanoImaging(this.bytes);
        }
        catch (QTException qTException) {
            throw new QTRuntimeException(qTException);
        }
    }

    protected static EndianDescriptor makeED() {
        EndianDescriptor endianDescriptor = new EndianDescriptor(0);
        EndianFlipSpec endianFlipSpec = new EndianFlipSpec(0, 2, 2);
        endianDescriptor.addFlipSpec(endianFlipSpec);
        EndianFlipSpec endianFlipSpec2 = new EndianFlipSpec(4, 4, 13);
        endianDescriptor.addFlipSpec(endianFlipSpec2);
        return endianDescriptor;
    }

    public static EndianDescriptor getEndianDescriptor() {
        if (ed == null) {
            ed = QTVRPanoImaging.makeED();
        }
        return ed;
    }

    public int getImagingMode() {
        return this.getIntAt(4);
    }

    public void setImagingMode(int n) {
        this.setIntAt(4, n);
    }

    public int getImagingValidFlags() {
        return this.getIntAt(8);
    }

    public void setImagingValidFlags(int n) {
        this.setIntAt(8, n);
    }

    public int getCorrection() {
        return this.getIntAt(12);
    }

    public void setCorrection(int n) {
        this.setIntAt(12, n);
    }

    public int getQuality() {
        return this.getIntAt(16);
    }

    public void setQuality(int n) {
        this.setIntAt(16, n);
    }

    public boolean isDirectDraw() {
        return this.getIntAt(20) == 1;
    }

    public void setDirectDraw(boolean bl) {
        this.setIntAt(20, bl ? 1 : 0);
    }

    public int getImagingProperty(int n) throws QTException {
        if (n < 0 || n > 5) {
            throw new QTException(-50);
        }
        int n2 = 24 + n * 4;
        return this.getIntAt(n2);
    }

    public void setImagingProperty(int n, int n2) throws QTException {
        if (n2 < 0 || n2 > 5) {
            throw new QTException(-50);
        }
        int n3 = 24 + n2 * 4;
        this.setIntAt(n3, n);
    }

    public void setReserved1(int n) {
        this.setIntAt(48, n);
    }

    public int getReserved1() {
        return this.getIntAt(48);
    }

    public void setReserved2(int n) {
        this.setIntAt(52, n);
    }

    public int getReserved2() {
        return this.getIntAt(52);
    }

    public String toString() {
        String string = this.getClass().getName() + "[imagingMode=" + this.getImagingMode() + ",imagingValidFlags=" + this.getImagingValidFlags() + ",correction=" + this.getCorrection() + ",quality=" + this.getQuality() + ",directDraw=" + this.isDirectDraw();
        try {
            string = string + ",imagingProperties=[" + this.getImagingProperty(0) + "][" + this.getImagingProperty(1) + "][" + this.getImagingProperty(2) + "][" + this.getImagingProperty(3) + "][" + this.getImagingProperty(4) + "][" + this.getImagingProperty(5) + "]";
        }
        catch (QTException qTException) {
            // empty catch block
        }
        return string + " ]";
    }
}

