/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.OutputStream;

public class NeuQuant {
    public static final int ncycles = 100;
    int netsize = 256;
    public static final int specials = 3;
    public static final int bgColour = 2;
    int cutnetsize = this.netsize - 3;
    int maxnetpos = this.netsize - 1;
    int initrad = this.netsize / 8;
    public static final int radiusbiasshift = 6;
    public static final int radiusbias = 64;
    public final int initBiasRadius = this.initrad * 64;
    public static final int radiusdec = 30;
    public static final int alphabiasshift = 10;
    public static final int initalpha = 1024;
    public static final double gamma = 1024.0;
    public static final double beta = 9.765625E-4;
    public static final double betagamma = 1.0;
    private double[][] network = new double[this.netsize][3];
    protected int[][] colormap = new int[this.netsize][4];
    private int[] netindex = new int[256];
    private double[] bias = new double[this.netsize];
    private double[] freq = new double[this.netsize];
    public static final int prime1 = 499;
    public static final int prime2 = 491;
    public static final int prime3 = 487;
    public static final int prime4 = 503;
    public static final int maxprime = 503;
    protected int[] pixels = null;
    private int samplefac = 0;
    NDNoise myApp = null;

    public NeuQuant(NDNoise aApp, BufferedImage im, int aNetSize, int aSampleFac, ImageObserver obs) throws IOException {
        this(aSampleFac, aNetSize);
        this.myApp = aApp;
        this.setPixels(im, obs);
        this.setUpArrays();
    }

    private NeuQuant(int sample, int aNetSize) throws IOException {
        this.netsize = aNetSize;
        this.cutnetsize = this.netsize - 3;
        this.maxnetpos = this.netsize - 1;
        this.initrad = this.netsize / 8;
        this.network = new double[this.netsize][3];
        this.colormap = new int[this.netsize][4];
        this.bias = new double[this.netsize];
        this.freq = new double[this.netsize];
        if (sample < 1) {
            throw new IOException("Sample must be 1..30");
        }
        if (sample > 30) {
            throw new IOException("Sample must be 1..30");
        }
        this.samplefac = sample;
    }

    public int getColorCount() {
        return this.netsize;
    }

    public Color getColor(int i) {
        if (i < 0 || i >= this.netsize) {
            return null;
        }
        int bb = this.colormap[i][0];
        int gg = this.colormap[i][1];
        int rr = this.colormap[i][2];
        return new Color(rr, gg, bb);
    }

    public int writeColourMap(boolean rgb, OutputStream out) throws IOException {
        int i = 0;
        while (i < this.netsize) {
            int bb = this.colormap[i][0];
            int gg = this.colormap[i][1];
            int rr = this.colormap[i][2];
            out.write(rgb ? rr : bb);
            out.write(gg);
            out.write(rgb ? bb : rr);
            ++i;
        }
        return this.netsize;
    }

    protected void setUpArrays() {
        this.network[0][0] = 0.0;
        this.network[0][1] = 0.0;
        this.network[0][2] = 0.0;
        this.network[1][0] = 1.0;
        this.network[1][1] = 1.0;
        this.network[1][2] = 1.0;
        int i = 0;
        while (i < 3) {
            this.freq[i] = 1.0 / (double)this.netsize;
            this.bias[i] = 0.0;
            ++i;
        }
        i = 3;
        while (i < this.netsize) {
            double[] p = this.network[i];
            p[0] = 256.0 * (double)(i - 3) / (double)this.cutnetsize;
            p[1] = 256.0 * (double)(i - 3) / (double)this.cutnetsize;
            p[2] = 256.0 * (double)(i - 3) / (double)this.cutnetsize;
            this.freq[i] = 1.0 / (double)this.netsize;
            this.bias[i] = 0.0;
            ++i;
        }
    }

    private void setPixels(BufferedImage im, ImageObserver obs) throws IOException {
        if (im == null) {
            throw new IOException("Image is null");
        }
        int w = im.getWidth(obs);
        int h = im.getHeight(obs);
        this.setPixels(im, w, h);
    }

    private void setPixels(BufferedImage im, int w, int h) throws IOException {
        if (w * h < 503) {
            throw new IOException("Image is too small");
        }
        this.pixels = ((DataBufferInt)im.getRaster().getDataBuffer()).getData();
    }

    public void init() {
        this.learn();
        this.fix();
        this.inxbuild();
    }

    private void altersingle(double alpha, int i, double b, double g, double r) {
        double[] n = this.network[i];
        n[0] = n[0] - alpha * (n[0] - b);
        n[1] = n[1] - alpha * (n[1] - g);
        n[2] = n[2] - alpha * (n[2] - r);
    }

    private void alterneigh(double alpha, int rad, int i, double b, double g, double r) {
        int hi;
        int lo = i - rad;
        if (lo < 2) {
            lo = 2;
        }
        if ((hi = i + rad) > this.netsize) {
            hi = this.netsize;
        }
        int j = i + 1;
        int k = i - 1;
        int q = 0;
        while (j < hi || k > lo) {
            double[] p;
            double a = alpha * (double)(rad * rad - q * q) / (double)(rad * rad);
            ++q;
            if (j < hi) {
                p = this.network[j];
                p[0] = p[0] - a * (p[0] - b);
                p[1] = p[1] - a * (p[1] - g);
                p[2] = p[2] - a * (p[2] - r);
                ++j;
            }
            if (k <= lo) continue;
            p = this.network[k];
            p[0] = p[0] - a * (p[0] - b);
            p[1] = p[1] - a * (p[1] - g);
            p[2] = p[2] - a * (p[2] - r);
            --k;
        }
    }

    private int contest(double b, double g, double r) {
        int bestpos;
        double bestd;
        double bestbiasd = bestd = 3.4028234663852886E38;
        int bestbiaspos = bestpos = -1;
        int i = 3;
        while (i < this.netsize) {
            double biasdist;
            double a;
            double[] n = this.network[i];
            double dist = n[0] - b;
            if (dist < 0.0) {
                dist = -dist;
            }
            if ((a = n[1] - g) < 0.0) {
                a = -a;
            }
            dist += a;
            a = n[2] - r;
            if (a < 0.0) {
                a = -a;
            }
            if ((dist += a) < bestd) {
                bestd = dist;
                bestpos = i;
            }
            if ((biasdist = dist - this.bias[i]) < bestbiasd) {
                bestbiasd = biasdist;
                bestbiaspos = i;
            }
            int n2 = i;
            this.freq[n2] = this.freq[n2] - 9.765625E-4 * this.freq[i];
            int n3 = i;
            this.bias[n3] = this.bias[n3] + 1.0 * this.freq[i];
            ++i;
        }
        int n = bestpos;
        this.freq[n] = this.freq[n] + 9.765625E-4;
        int n4 = bestpos;
        this.bias[n4] = this.bias[n4] - 1.0;
        return bestbiaspos;
    }

    private int specialFind(double b, double g, double r) {
        int i = 0;
        while (i < 3) {
            double[] n = this.network[i];
            if (n[0] == b && n[1] == g && n[2] == r) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void learn() {
        this.myApp.debugString = "Neural Quantization";
        int biasRadius = this.initBiasRadius;
        int alphadec = 30 + (this.samplefac - 1) / 3;
        int lengthcount = this.pixels.length;
        int samplepixels = lengthcount / this.samplefac;
        int delta = samplepixels / 100;
        int alpha = 1024;
        int i = 0;
        int rad = biasRadius >> 6;
        if (rad <= 1) {
            rad = 0;
        }
        System.err.println("beginning 1D learning: samplepixels=" + samplepixels + "  rad=" + rad);
        int step = 0;
        int pos = 0;
        step = lengthcount % 499 != 0 ? 499 : (lengthcount % 491 != 0 ? 491 : (lengthcount % 487 != 0 ? 487 : 503));
        i = 0;
        while (i < samplepixels) {
            int j;
            this.myApp.percent = 100 * i / samplepixels;
            int p = this.pixels[pos];
            int red = p >> 16 & 0xFF;
            int green = p >> 8 & 0xFF;
            int blue = p & 0xFF;
            double b = blue;
            double g = green;
            double r = red;
            if (i == 0) {
                this.network[2][0] = b;
                this.network[2][1] = g;
                this.network[2][2] = r;
            }
            int n = j = (j = this.specialFind(b, g, r)) < 0 ? this.contest(b, g, r) : j;
            if (j >= 3) {
                double a = 1.0 * (double)alpha / 1024.0;
                this.altersingle(a, j, b, g, r);
                if (rad > 0) {
                    this.alterneigh(a, rad, j, b, g, r);
                }
            }
            pos += step;
            while (pos >= lengthcount) {
                pos -= lengthcount;
            }
            if (++i % delta != 0) continue;
            alpha -= alpha / alphadec;
            if ((rad = (biasRadius -= biasRadius / 30) >> 6) > 1) continue;
            rad = 0;
        }
        System.err.println("finished 1D learning: final alpha=" + 1.0 * (double)alpha / 1024.0 + "!");
    }

    private void fix() {
        this.myApp.debugString = "Neural Quantization";
        int i = 0;
        while (i < this.netsize) {
            this.myApp.percent = 100 * i / this.netsize;
            int j = 0;
            while (j < 3) {
                int x = (int)(0.5 + this.network[i][j]);
                if (x < 0) {
                    x = 0;
                }
                if (x > 255) {
                    x = 255;
                }
                this.colormap[i][j] = x;
                ++j;
            }
            this.colormap[i][3] = i;
            ++i;
        }
    }

    private void inxbuild() {
        this.myApp.debugString = "Neural Quantization";
        int previouscol = 0;
        int startpos = 0;
        int i = 0;
        while (i < this.netsize) {
            this.myApp.percent = 100 * i / this.netsize;
            int[] p = this.colormap[i];
            int[] q = null;
            int smallpos = i;
            int smallval = p[1];
            int j = i + 1;
            while (j < this.netsize) {
                q = this.colormap[j];
                if (q[1] < smallval) {
                    smallpos = j;
                    smallval = q[1];
                }
                ++j;
            }
            q = this.colormap[smallpos];
            if (i != smallpos) {
                j = q[0];
                q[0] = p[0];
                p[0] = j;
                j = q[1];
                q[1] = p[1];
                p[1] = j;
                j = q[2];
                q[2] = p[2];
                p[2] = j;
                j = q[3];
                q[3] = p[3];
                p[3] = j;
            }
            if (smallval != previouscol) {
                this.netindex[previouscol] = startpos + i >> 1;
                j = previouscol + 1;
                while (j < smallval) {
                    this.netindex[j] = i;
                    ++j;
                }
                previouscol = smallval;
                startpos = i;
            }
            ++i;
        }
        this.netindex[previouscol] = startpos + this.maxnetpos >> 1;
        int j = previouscol + 1;
        while (j < 256) {
            this.netindex[j] = this.maxnetpos;
            ++j;
        }
    }

    public int convert(int pixel) {
        int r = pixel >> 16 & 0xFF;
        int g = pixel >> 8 & 0xFF;
        int b = pixel & 0xFF;
        int i = this.inxsearch(b, g, r);
        int bb = this.colormap[i][0];
        int gg = this.colormap[i][1];
        int rr = this.colormap[i][2];
        return 0xFF000000 | rr << 16 | gg << 8 | bb;
    }

    public int convertId(int pixel) {
        int alfa = pixel >> 24 & 0xFF;
        int r = pixel >> 16 & 0xFF;
        int g = pixel >> 8 & 0xFF;
        int b = pixel & 0xFF;
        int i = this.inxsearch(b, g, r);
        i = i * 256 / this.netsize;
        return 0xFF000000 | (i & 0xFF) << 16 | (i & 0xFF) << 8 | i & 0xFF;
    }

    public int lookup(int pixel) {
        int r = pixel >> 16 & 0xFF;
        int g = pixel >> 8 & 0xFF;
        int b = pixel & 0xFF;
        int i = this.inxsearch(b, g, r);
        return i;
    }

    public int lookup(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int i = this.inxsearch(b, g, r);
        return i;
    }

    public int lookup(boolean rgb, int x, int g, int y) {
        int i = rgb ? this.inxsearch(y, g, x) : this.inxsearch(x, g, y);
        return i;
    }

    private int not_used_slow_inxsearch(int b, int g, int r) {
        int bestd = 1000;
        int best = -1;
        int i = 0;
        while (i < this.netsize) {
            int a;
            int[] p = this.colormap[i];
            int dist = p[1] - g;
            if (dist < 0) {
                dist = -dist;
            }
            if ((a = p[0] - b) < 0) {
                a = -a;
            }
            dist += a;
            a = p[2] - r;
            if (a < 0) {
                a = -a;
            }
            if ((dist += a) < bestd) {
                bestd = dist;
                best = i;
            }
            ++i;
        }
        return best;
    }

    protected int inxsearch(int b, int g, int r) {
        int bestd = 1000;
        int best = -1;
        int i = this.netindex[g];
        int j = i - 1;
        while (i < this.netsize || j >= 0) {
            int a;
            int dist;
            int[] p;
            if (i < this.netsize) {
                p = this.colormap[i];
                dist = p[1] - g;
                if (dist >= bestd) {
                    i = this.netsize;
                } else {
                    if (dist < 0) {
                        dist = -dist;
                    }
                    if ((a = p[0] - b) < 0) {
                        a = -a;
                    }
                    if ((dist += a) < bestd) {
                        a = p[2] - r;
                        if (a < 0) {
                            a = -a;
                        }
                        if ((dist += a) < bestd) {
                            bestd = dist;
                            best = i;
                        }
                    }
                    ++i;
                }
            }
            if (j < 0) continue;
            p = this.colormap[j];
            dist = g - p[1];
            if (dist >= bestd) {
                j = -1;
                continue;
            }
            if (dist < 0) {
                dist = -dist;
            }
            if ((a = p[0] - b) < 0) {
                a = -a;
            }
            if ((dist += a) < bestd) {
                a = p[2] - r;
                if (a < 0) {
                    a = -a;
                }
                if ((dist += a) < bestd) {
                    bestd = dist;
                    best = j;
                }
            }
            --j;
        }
        return best;
    }
}

