/*
 * Decompiled with CFR 0.152.
 */
package com.bric.plaf;

import com.bric.plaf.PlafPaintUtils;
import com.bric.swing.ColorPicker;
import com.bric.swing.ColorPickerPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JSlider;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicSliderUI;

public class ColorPickerSliderUI
extends BasicSliderUI {
    ColorPicker colorPicker;
    int ARROW_HALF = 8;
    int[] intArray;
    BufferedImage bi;
    int lastMode;
    MouseInputAdapter myMouseListener;

    public ColorPickerSliderUI(JSlider jSlider, ColorPicker colorPicker) {
        super(jSlider);
        this.intArray = new int[Toolkit.getDefaultToolkit().getScreenSize().height];
        this.bi = new BufferedImage(1, this.intArray.length, 1);
        this.lastMode = -1;
        this.myMouseListener = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ColorPickerSliderUI.this.slider.setValueIsAdjusting(true);
                this.updateSliderValue(mouseEvent);
            }

            private void updateSliderValue(MouseEvent mouseEvent) {
                int n;
                if (ColorPickerSliderUI.this.slider.getOrientation() == 0) {
                    int n2 = mouseEvent.getX();
                    n = ColorPickerSliderUI.this.valueForXPosition(n2);
                } else {
                    int n3 = mouseEvent.getY();
                    n = ColorPickerSliderUI.this.valueForYPosition(n3);
                }
                ColorPickerSliderUI.this.slider.setValue(n);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.updateSliderValue(mouseEvent);
                ColorPickerSliderUI.this.slider.setValueIsAdjusting(false);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                this.updateSliderValue(mouseEvent);
            }
        };
        this.colorPicker = colorPicker;
        colorPicker.getColorPanel().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ColorPickerSliderUI.this.calculateGeometry();
                ColorPickerSliderUI.this.slider.repaint();
            }
        });
    }

    @Override
    public void paintThumb(Graphics graphics) {
        int n = this.thumbRect.y + this.thumbRect.height / 2;
        Polygon polygon = new Polygon();
        polygon.addPoint(0, n - this.ARROW_HALF);
        polygon.addPoint(this.ARROW_HALF, n);
        polygon.addPoint(0, n + this.ARROW_HALF);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.black);
        graphics2D.fill(polygon);
        graphics2D.setColor(Color.white);
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.draw(polygon);
    }

    @Override
    protected void calculateThumbSize() {
        super.calculateThumbSize();
        this.thumbRect.height += 4;
        this.thumbRect.y -= 2;
    }

    @Override
    protected void calculateTrackRect() {
        super.calculateTrackRect();
        ColorPickerPanel colorPickerPanel = this.colorPicker.getColorPanel();
        int n = Math.min(325, Math.min(colorPickerPanel.getWidth(), colorPickerPanel.getHeight()));
        int n2 = this.slider.getHeight() - this.ARROW_HALF * 2 - 2;
        if (n > n2) {
            n = n2;
        }
        this.trackRect.y = this.slider.getHeight() / 2 - n / 2;
        this.trackRect.height = n;
    }

    @Override
    public synchronized void paintTrack(Graphics graphics) {
        int n;
        Object object;
        int n2 = this.colorPicker.getMode();
        if (n2 == 0 || n2 == 1 || n2 == 2) {
            float f;
            object = this.colorPicker.getHSB();
            if (n2 == 0) {
                for (n = 0; n < this.trackRect.height; ++n) {
                    f = (float)n / (float)this.trackRect.height;
                    this.intArray[n] = Color.HSBtoRGB(f, 1.0f, 1.0f);
                }
            } else if (n2 == 2) {
                for (n = 0; n < this.trackRect.height; ++n) {
                    f = 1.0f - (float)n / (float)this.trackRect.height;
                    this.intArray[n] = Color.HSBtoRGB(object[0], f, object[2]);
                }
            } else {
                for (n = 0; n < this.trackRect.height; ++n) {
                    f = 1.0f - (float)n / (float)this.trackRect.height;
                    this.intArray[n] = Color.HSBtoRGB(object[0], object[1], f);
                }
            }
        } else {
            object = this.colorPicker.getRGB();
            if (n2 == 3) {
                for (n = 0; n < this.trackRect.height; ++n) {
                    int n3 = 255 - (int)((double)(n * 255 / this.trackRect.height) + 0.49);
                    this.intArray[n] = (n3 << 16) + (object[1] << 8) + object[2];
                }
            } else if (n2 == 4) {
                for (n = 0; n < this.trackRect.height; ++n) {
                    int n4 = 255 - (int)((double)(n * 255 / this.trackRect.height) + 0.49);
                    this.intArray[n] = (int)((object[0] << 16) + (n4 << 8) + object[2]);
                }
            } else if (n2 == 5) {
                for (n = 0; n < this.trackRect.height; ++n) {
                    int n5 = 255 - (int)((double)(n * 255 / this.trackRect.height) + 0.49);
                    this.intArray[n] = (int)((object[0] << 16) + (object[1] << 8) + n5);
                }
            }
        }
        object = (Graphics2D)graphics;
        Rectangle rectangle = new Rectangle(6, this.trackRect.y, 14, this.trackRect.height);
        if (this.slider.hasFocus()) {
            PlafPaintUtils.paintFocus((Graphics2D)object, rectangle, 3);
        }
        this.bi.getRaster().setDataElements(0, 0, 1, this.trackRect.height, this.intArray);
        TexturePaint texturePaint = new TexturePaint(this.bi, new Rectangle(0, this.trackRect.y, 1, this.bi.getHeight()));
        ((Graphics2D)object).setPaint(texturePaint);
        ((Graphics)object).fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        PlafPaintUtils.drawBevel((Graphics2D)object, rectangle);
    }

    @Override
    public void paintFocus(Graphics graphics) {
    }

    @Override
    protected void installListeners(JSlider jSlider) {
        super.installListeners(jSlider);
        jSlider.removeMouseListener(this.trackListener);
        jSlider.removeMouseMotionListener(this.trackListener);
        jSlider.addMouseListener(this.myMouseListener);
        jSlider.addMouseMotionListener(this.myMouseListener);
        jSlider.setOpaque(false);
    }

    @Override
    protected void uninstallListeners(JSlider jSlider) {
        super.uninstallListeners(jSlider);
        jSlider.removeMouseListener(this.myMouseListener);
        jSlider.removeMouseMotionListener(this.myMouseListener);
    }
}

