/*
 * Decompiled with CFR 0.152.
 */
package com.bric.util;

import java.security.AccessControlException;

public class JVM {
    public static final float javaVersion = JVM.getMajorJavaVersion(true);
    public static final boolean isMac = System.getProperty("os.name").toLowerCase().indexOf("mac") != -1;
    public static final boolean isWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
    public static final boolean isVista = System.getProperty("os.name").toLowerCase().indexOf("vista") != -1;
    public static final boolean isLinux = System.getProperty("os.name").toLowerCase().indexOf("linux") != -1;
    public static final boolean usingQuartz = isMac && (javaVersion > 0.0f && javaVersion < 1.4f || System.getProperty("apple.awt.graphics.UseQuartz") != null && System.getProperty("apple.awt.graphics.UseQuartz").equals("true"));

    public static void printProfile() {
        System.out.println(JVM.getProfile());
    }

    public static String getProfile() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("OS = " + System.getProperty("os.name") + " (" + System.getProperty("os.version") + "), " + System.getProperty("os.arch") + "\n");
        stringBuffer.append("Java Version = " + System.getProperty("java.version") + "\n");
        if (isMac) {
            stringBuffer.append("apple.awt.graphics.UseQuartz = " + usingQuartz);
        }
        return stringBuffer.toString();
    }

    public static float getMajorJavaVersion() throws AccessControlException {
        String string = System.getProperty("java.major.version");
        if (string == null) {
            String string2 = System.getProperty("java.version");
            float f = -1.0f;
            for (int i = string2.length(); f < 0.0f && i > 0; --i) {
                try {
                    f = Float.parseFloat(string2.substring(0, i));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            string = Float.toString(f);
            System.setProperty("java.major.version", string);
        }
        return Float.parseFloat(string);
    }

    public static float getMajorJavaVersion(boolean bl) {
        try {
            return JVM.getMajorJavaVersion();
        }
        catch (RuntimeException runtimeException) {
            if (bl) {
                System.err.println("this exception was ignored without incident, but it means we can't determine the major java version:");
                runtimeException.printStackTrace();
                return -1.0f;
            }
            throw runtimeException;
        }
    }
}

