/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import com.jhlabs.image.ImageMath;
import com.jhlabs.image.MotionBlur;
import com.jhlabs.image.PixelUtils;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class MotionBlurFilter
extends AbstractBufferedImageOp
implements MotionBlur {
    private float angle = 0.0f;
    private float falloff = 1.0f;
    private float distance = 1.0f;
    private float zoom = 0.0f;
    private float rotation = 0.0f;
    private boolean wrapEdges = false;
    private boolean premultiplyAlpha = true;
    private float centreY = 0.5f;
    private float centreX = 0.5f;

    public MotionBlurFilter() {
    }

    public MotionBlurFilter(float f, float f2, float f3, float f4) {
        this.distance = f;
        this.angle = f2;
        this.rotation = f3;
        this.zoom = f4;
    }

    @Override
    public void setCentreX(float f) {
        this.centreX = f;
    }

    @Override
    public float getCentreX() {
        return this.centreX;
    }

    @Override
    public void setCentreY(float f) {
        this.centreY = f;
    }

    @Override
    public float getCentreY() {
        return this.centreY;
    }

    @Override
    public void setCentre(Point2D point2D) {
        this.centreX = (float)point2D.getX();
        this.centreY = (float)point2D.getY();
    }

    @Override
    public Point2D getCentre() {
        return new Point2D.Float(this.centreX, this.centreY);
    }

    @Override
    public void setAngle(float f) {
        this.angle = f;
    }

    @Override
    public float getAngle() {
        return this.angle;
    }

    @Override
    public void setDistance(float f) {
        this.distance = f;
    }

    @Override
    public float getDistance() {
        return this.distance;
    }

    @Override
    public void setRotation(float f) {
        this.rotation = f;
    }

    @Override
    public float getRotation() {
        return this.rotation;
    }

    @Override
    public void setZoom(float f) {
        this.zoom = f;
    }

    @Override
    public float getZoom() {
        return this.zoom;
    }

    public void setWrapEdges(boolean bl) {
        this.wrapEdges = bl;
    }

    public boolean getWrapEdges() {
        return this.wrapEdges;
    }

    public void setPremultiplyAlpha(boolean bl) {
        this.premultiplyAlpha = bl;
    }

    public boolean getPremultiplyAlpha() {
        return this.premultiplyAlpha;
    }

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        int[] nArray = new int[n * n2];
        int[] nArray2 = new int[n * n2];
        this.getRGB(bufferedImage, 0, 0, n, n2, nArray);
        int n3 = (int)((float)n * this.centreX);
        int n4 = (int)((float)n2 * this.centreY);
        int n5 = 0;
        float f = (float)Math.sqrt(n3 * n3 + n4 * n4);
        float f2 = (float)((double)this.distance * Math.cos(this.angle));
        float f3 = (float)((double)this.distance * -Math.sin(this.angle));
        float f4 = this.distance + Math.abs(this.rotation * f) + this.zoom * f;
        int n6 = (int)f4;
        AffineTransform affineTransform = new AffineTransform();
        Point2D.Float float_ = new Point2D.Float();
        if (this.premultiplyAlpha) {
            ImageMath.premultiply(nArray, 0, nArray.length);
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                for (int k = 0; k < n6; ++k) {
                    int n12 = j;
                    int n13 = i;
                    float f5 = (float)k / (float)n6;
                    float_.x = j;
                    float_.y = i;
                    affineTransform.setToIdentity();
                    affineTransform.translate((float)n3 + f5 * f2, (float)n4 + f5 * f3);
                    float f6 = 1.0f - this.zoom * f5;
                    affineTransform.scale(f6, f6);
                    if (this.rotation != 0.0f) {
                        affineTransform.rotate(-this.rotation * f5);
                    }
                    affineTransform.translate(-n3, -n4);
                    affineTransform.transform(float_, float_);
                    n12 = (int)float_.x;
                    n13 = (int)float_.y;
                    if (n12 < 0 || n12 >= n) {
                        if (!this.wrapEdges) break;
                        n12 = ImageMath.mod(n12, n);
                    }
                    if (n13 < 0 || n13 >= n2) {
                        if (!this.wrapEdges) break;
                        n13 = ImageMath.mod(n13, n2);
                    }
                    ++n11;
                    int n14 = nArray[n13 * n + n12];
                    n7 += n14 >> 24 & 0xFF;
                    n8 += n14 >> 16 & 0xFF;
                    n9 += n14 >> 8 & 0xFF;
                    n10 += n14 & 0xFF;
                }
                if (n11 == 0) {
                    nArray2[n5] = nArray[n5];
                } else {
                    n7 = PixelUtils.clamp(n7 / n11);
                    n8 = PixelUtils.clamp(n8 / n11);
                    n9 = PixelUtils.clamp(n9 / n11);
                    n10 = PixelUtils.clamp(n10 / n11);
                    nArray2[n5] = n7 << 24 | n8 << 16 | n9 << 8 | n10;
                }
                ++n5;
            }
        }
        if (this.premultiplyAlpha) {
            ImageMath.unpremultiply(nArray2, 0, nArray.length);
        }
        this.setRGB(bufferedImage2, 0, 0, n, n2, nArray2);
        return bufferedImage2;
    }

    public String toString() {
        return "Blur/Motion Blur...";
    }
}

