/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.error;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.SwingUtilities;

public class ErrorInfo {
    private String title;
    private String basicErrorMessage;
    private String detailedErrorMessage;
    private String category;
    private Throwable errorException;
    private Level errorLevel;
    private Map<String, String> state;

    public ErrorInfo(String string, String string2, String string3, String string4, Throwable throwable, Level level, Map<String, String> map) {
        this.title = string;
        this.basicErrorMessage = string2;
        this.detailedErrorMessage = string3;
        this.category = string4;
        this.errorException = throwable;
        this.errorLevel = level == null ? Level.SEVERE : level;
        this.state = new HashMap<String, String>();
        try {
            Properties properties = System.getProperties();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String string5;
                String string6 = entry.getKey() == null ? null : entry.getKey().toString();
                String string7 = string5 = entry.getKey() == null ? null : entry.getValue().toString();
                if (string6 == null) continue;
                this.state.put(string6, string5);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.state.put("System.currentTimeMillis", "" + System.currentTimeMillis());
        this.state.put("isOnEDT", "" + SwingUtilities.isEventDispatchThread());
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                this.state.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getBasicErrorMessage() {
        return this.basicErrorMessage;
    }

    public String getDetailedErrorMessage() {
        return this.detailedErrorMessage;
    }

    public String getCategory() {
        return this.category;
    }

    public Throwable getErrorException() {
        return this.errorException;
    }

    public Level getErrorLevel() {
        return this.errorLevel;
    }

    public Map<String, String> getState() {
        return new HashMap<String, String>(this.state);
    }
}

