/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.graphics;

import java.awt.Color;

public class ColorUtilities {
    private ColorUtilities() {
    }

    public static float[] RGBtoHSL(Color color) {
        return ColorUtilities.RGBtoHSL(color.getRed(), color.getGreen(), color.getBlue(), null);
    }

    public static float[] RGBtoHSL(Color color, float[] fArray) {
        return ColorUtilities.RGBtoHSL(color.getRed(), color.getGreen(), color.getBlue(), fArray);
    }

    public static float[] RGBtoHSL(int n, int n2, int n3) {
        return ColorUtilities.RGBtoHSL(n, n2, n3, null);
    }

    public static float[] RGBtoHSL(int n, int n2, int n3, float[] fArray) {
        float f;
        float f2;
        float f3;
        float f4;
        if (fArray == null) {
            fArray = new float[3];
        } else if (fArray.length < 3) {
            throw new IllegalArgumentException("hsl array must have a length of at least 3");
        }
        if (n < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 255) {
            n2 = 255;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > 255) {
            n3 = 255;
        }
        float f5 = (float)n / 255.0f;
        float f6 = (float)n2 / 255.0f;
        float f7 = (float)n3 / 255.0f;
        if (f5 > f6) {
            f4 = f6;
            f3 = f5;
        } else {
            f4 = f5;
            f3 = f6;
        }
        if (f7 > f3) {
            f3 = f7;
        }
        if (f7 < f4) {
            f4 = f7;
        }
        float f8 = f3 - f4;
        float f9 = (f3 + f4) / 2.0f;
        if (f8 - 0.01f <= 0.0f) {
            f2 = 0.0f;
            f = 0.0f;
        } else {
            f = f9 < 0.5f ? f8 / (f3 + f4) : f8 / (2.0f - f3 - f4);
            float f10 = ((f3 - f5) / 6.0f + f8 / 2.0f) / f8;
            float f11 = ((f3 - f6) / 6.0f + f8 / 2.0f) / f8;
            float f12 = ((f3 - f7) / 6.0f + f8 / 2.0f) / f8;
            f2 = f5 == f3 ? f12 - f11 : (f6 == f3 ? 0.33333334f + f10 - f12 : 0.6666667f + f11 - f10);
            if (f2 < 0.0f) {
                f2 += 1.0f;
            }
            if (f2 > 1.0f) {
                f2 -= 1.0f;
            }
        }
        fArray[0] = f2;
        fArray[1] = f;
        fArray[2] = f9;
        return fArray;
    }

    public static Color HSLtoRGB(float f, float f2, float f3) {
        int[] nArray = ColorUtilities.HSLtoRGB(f, f2, f3, null);
        return new Color(nArray[0], nArray[1], nArray[2]);
    }

    public static int[] HSLtoRGB(float f, float f2, float f3, int[] nArray) {
        int n;
        int n2;
        int n3;
        if (nArray == null) {
            nArray = new int[3];
        } else if (nArray.length < 3) {
            throw new IllegalArgumentException("rgb array must have a length of at least 3");
        }
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        } else if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        if (f2 - 0.01f <= 0.0f) {
            n3 = (int)(f3 * 255.0f);
            n2 = (int)(f3 * 255.0f);
            n = (int)(f3 * 255.0f);
        } else {
            float f4 = f3 < 0.5f ? f3 * (1.0f + f2) : f3 + f2 - f2 * f3;
            float f5 = 2.0f * f3 - f4;
            n3 = (int)(255.0f * ColorUtilities.hue2RGB(f5, f4, f + 0.33333334f));
            n2 = (int)(255.0f * ColorUtilities.hue2RGB(f5, f4, f));
            n = (int)(255.0f * ColorUtilities.hue2RGB(f5, f4, f - 0.33333334f));
        }
        nArray[0] = n3;
        nArray[1] = n2;
        nArray[2] = n;
        return nArray;
    }

    private static float hue2RGB(float f, float f2, float f3) {
        if (f3 < 0.0f) {
            f3 += 1.0f;
        }
        if (f3 > 1.0f) {
            f3 -= 1.0f;
        }
        if (6.0f * f3 < 1.0f) {
            return f + (f2 - f) * 6.0f * f3;
        }
        if (2.0f * f3 < 1.0f) {
            return f2;
        }
        if (3.0f * f3 < 2.0f) {
            return f + (f2 - f) * (0.6666667f - f3) * 6.0f;
        }
        return f;
    }
}

