/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.graphics;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.jdesktop.swingx.graphics.GraphicsUtilities;
import org.jdesktop.swingx.image.StackBlurFilter;

public class ReflectionRenderer {
    public static final String OPACITY_CHANGED_PROPERTY = "reflection_opacity";
    public static final String LENGTH_CHANGED_PROPERTY = "reflection_length";
    public static final String BLUR_ENABLED_CHANGED_PROPERTY = "reflection_blur";
    private float opacity;
    private float length;
    private boolean blurEnabled;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private StackBlurFilter stackBlurFilter = new StackBlurFilter(1);

    public ReflectionRenderer() {
        this(0.35f, 0.4f, false);
    }

    public ReflectionRenderer(float f) {
        this(f, 0.4f, false);
    }

    public ReflectionRenderer(float f, float f2, boolean bl) {
        this.setOpacity(f);
        this.setLength(f2);
        this.setBlurEnabled(bl);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float f) {
        float f2 = this.opacity;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        if (f2 != f) {
            this.opacity = f;
            this.changeSupport.firePropertyChange(OPACITY_CHANGED_PROPERTY, Float.valueOf(f2), Float.valueOf(this.opacity));
        }
    }

    public float getLength() {
        return this.length;
    }

    public void setLength(float f) {
        float f2 = this.length;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        if (f2 != f) {
            this.length = f;
            this.changeSupport.firePropertyChange(LENGTH_CHANGED_PROPERTY, Float.valueOf(f2), Float.valueOf(this.length));
        }
    }

    public boolean isBlurEnabled() {
        return this.blurEnabled;
    }

    public void setBlurEnabled(boolean bl) {
        if (bl != this.blurEnabled) {
            boolean bl2 = this.blurEnabled;
            this.blurEnabled = bl;
            this.changeSupport.firePropertyChange(BLUR_ENABLED_CHANGED_PROPERTY, bl2, this.blurEnabled);
        }
    }

    public int getEffectiveBlurRadius() {
        return this.stackBlurFilter.getEffectiveRadius();
    }

    public int getBlurRadius() {
        return this.stackBlurFilter.getRadius();
    }

    public void setBlurRadius(int n) {
        this.stackBlurFilter = new StackBlurFilter(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage appendReflection(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = this.createReflection(bufferedImage);
        BufferedImage bufferedImage3 = GraphicsUtilities.createCompatibleTranslucentImage(bufferedImage2.getWidth(), bufferedImage.getHeight() + bufferedImage2.getHeight());
        Graphics2D graphics2D = bufferedImage3.createGraphics();
        try {
            int n = this.isBlurEnabled() ? this.stackBlurFilter.getEffectiveRadius() : 0;
            graphics2D.drawImage((Image)bufferedImage, n, 0, null);
            graphics2D.drawImage((Image)bufferedImage2, 0, bufferedImage.getHeight() - n, null);
        }
        finally {
            graphics2D.dispose();
        }
        bufferedImage2.flush();
        return bufferedImage3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage createReflection(BufferedImage bufferedImage) {
        if (this.length == 0.0f) {
            return GraphicsUtilities.createCompatibleTranslucentImage(1, 1);
        }
        int n = this.isBlurEnabled() ? this.stackBlurFilter.getEffectiveRadius() : 0;
        int n2 = (int)((float)bufferedImage.getHeight() * this.length);
        BufferedImage bufferedImage2 = GraphicsUtilities.createCompatibleTranslucentImage(bufferedImage.getWidth() + n * 2, n2 + n * 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        try {
            graphics2D.translate(0, bufferedImage.getHeight());
            graphics2D.scale(1.0, -1.0);
            graphics2D.drawImage((Image)bufferedImage, n, -n, null);
            graphics2D.scale(1.0, -1.0);
            graphics2D.translate(0, -bufferedImage.getHeight());
            graphics2D.setComposite(AlphaComposite.DstIn);
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, new Color(0.0f, 0.0f, 0.0f, this.getOpacity()), 0.0f, bufferedImage2.getHeight(), new Color(0.0f, 0.0f, 0.0f, 0.0f), true));
            graphics2D.fillRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
        }
        finally {
            graphics2D.dispose();
        }
        return this.isBlurEnabled() ? this.stackBlurFilter.filter(bufferedImage2, null) : bufferedImage2;
    }
}

