/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.jdesktop.swingx.graphics.GraphicsUtilities;
import org.jdesktop.swingx.image.AbstractFilter;

public class ColorTintFilter
extends AbstractFilter {
    private final Color mixColor;
    private final float mixValue;
    private int[] preMultipliedRed;
    private int[] preMultipliedGreen;
    private int[] preMultipliedBlue;

    public ColorTintFilter(Color color, float f) {
        if (color == null) {
            throw new IllegalArgumentException("mixColor cannot be null");
        }
        this.mixColor = color;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        this.mixValue = f;
        int n = (int)((float)color.getRed() * f);
        int n2 = (int)((float)color.getGreen() * f);
        int n3 = (int)((float)color.getBlue() * f);
        float f2 = 1.0f - f;
        this.preMultipliedRed = new int[256];
        this.preMultipliedGreen = new int[256];
        this.preMultipliedBlue = new int[256];
        for (int i = 0; i < 256; ++i) {
            int n4 = (int)((float)i * f2);
            this.preMultipliedRed[i] = n4 + n;
            this.preMultipliedGreen[i] = n4 + n2;
            this.preMultipliedBlue[i] = n4 + n3;
        }
    }

    public float getMixValue() {
        return this.mixValue;
    }

    public Color getMixColor() {
        return this.mixColor;
    }

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[] nArray = new int[n * n2];
        GraphicsUtilities.getPixels(bufferedImage, 0, 0, n, n2, nArray);
        this.mixColor(nArray);
        GraphicsUtilities.setPixels(bufferedImage2, 0, 0, n, n2, nArray);
        return bufferedImage2;
    }

    private void mixColor(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            nArray[i] = n & 0xFF000000 | this.preMultipliedRed[n >> 16 & 0xFF] << 16 | this.preMultipliedGreen[n >> 8 & 0xFF] << 8 | this.preMultipliedBlue[n & 0xFF];
        }
    }
}

