/*
 * Decompiled with CFR 0.152.
 */
package pixelitor;

import java.awt.image.BufferedImage;
import pixelitor.AppLogic;
import pixelitor.Composition;
import pixelitor.history.FadeableEdit;
import pixelitor.history.History;
import pixelitor.layers.DeleteActiveLayerAction;
import pixelitor.layers.ImageLayer;
import pixelitor.menus.SelectionActions;

public final class ConsistencyChecks {
    private ConsistencyChecks() {
    }

    public static void checkAll() {
        Composition composition = AppLogic.getActiveComp();
        if (composition != null) {
            ConsistencyChecks.selectionCheck(composition);
            ConsistencyChecks.fadeCheck(composition);
            ConsistencyChecks.translationCheck(composition);
            ConsistencyChecks.layerDeleteActionEnabledCheck();
        }
    }

    public static boolean fadeCheck(Composition composition) {
        ImageLayer imageLayer;
        FadeableEdit fadeableEdit = History.getPreviousEditForFade(composition);
        if (fadeableEdit != null && (imageLayer = composition.getActiveImageLayer()) != null) {
            boolean bl;
            BufferedImage bufferedImage = imageLayer.getImageOrSubImageIfSelected(false, true);
            BufferedImage bufferedImage2 = fadeableEdit.getBackupImage();
            boolean bl2 = bufferedImage.getWidth() != bufferedImage2.getWidth();
            boolean bl3 = bl = bufferedImage.getHeight() != bufferedImage2.getHeight();
            if (bl2 || bl) {
                String string = History.getLastPresentationName();
                throw new IllegalStateException("'Fade " + string + "' would not work now: FadeableEdit class = " + fadeableEdit.getClass().getName() + " width = " + bufferedImage.getWidth() + ", previous width = " + bufferedImage2.getWidth() + ", height = " + bufferedImage.getHeight() + ", previous height = " + bufferedImage2.getHeight());
            }
        }
        return true;
    }

    private static void selectionCheck(Composition composition) {
        if (composition.hasSelection() && !SelectionActions.areEnabled()) {
            throw new IllegalStateException(composition.getName() + " has selection, but selections are disabled");
        }
    }

    public static boolean translationCheck(Composition composition) {
        ImageLayer imageLayer = composition.getActiveImageLayer();
        if (imageLayer != null) {
            int n;
            int n2;
            int n3;
            int n4;
            BufferedImage bufferedImage = imageLayer.getBufferedImage();
            int n5 = -imageLayer.getTranslationX();
            if (n5 + (n4 = composition.getCanvasWidth()) > (n3 = bufferedImage.getWidth())) {
                throw new IllegalStateException("x = " + n5 + ", canvasWidth = " + n4 + ", imageWidth = " + n3 + ", comp = " + composition.getName());
            }
            int n6 = -imageLayer.getTranslationY();
            if (n6 + (n2 = composition.getCanvasHeight()) > (n = bufferedImage.getHeight())) {
                throw new IllegalStateException("y = " + n6 + ", canvasHeight = " + n2 + ", imageHeight = " + n + ", comp = " + composition.getName());
            }
        }
        return true;
    }

    public static boolean layerDeleteActionEnabledCheck() {
        DeleteActiveLayerAction deleteActiveLayerAction = DeleteActiveLayerAction.INSTANCE;
        if (deleteActiveLayerAction == null) {
            return true;
        }
        Composition composition = AppLogic.getActiveComp();
        if (composition == null) {
            return true;
        }
        boolean bl = deleteActiveLayerAction.isEnabled();
        int n = composition.getNrLayers();
        if (bl ? n <= 1 : n >= 2) {
            throw new IllegalStateException("nrLayers = " + n);
        }
        return true;
    }
}

