/*
 * Decompiled with CFR 0.152.
 */
package pixelitor;

import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import pixelitor.AppLogic;
import pixelitor.Build;
import pixelitor.ImageComponent;
import pixelitor.PixelitorWindow;
import pixelitor.io.OpenSaveManager;

public class InternalImageFrame
extends JInternalFrame
implements InternalFrameListener {
    private static final int NIMBUS_HORIZONTAL_ADJUSTMENT = 18;
    private static final int NIMBUS_VERTICAL_ADJUSTMENT = 38;
    private final ImageComponent ic;

    public InternalImageFrame(ImageComponent imageComponent, int n, int n2) {
        super(imageComponent.createFrameTitle(), true, true, true, true);
        this.addInternalFrameListener(this);
        this.setFrameIcon(null);
        this.ic = imageComponent;
        this.setDefaultCloseOperation(0);
        JScrollPane jScrollPane = new JScrollPane(this.ic);
        this.add(jScrollPane);
        Dimension dimension = imageComponent.getPreferredSize();
        this.setNewSize((int)dimension.getWidth(), (int)dimension.getHeight(), n, n2);
        this.setVisible(true);
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        AppLogic.activeImageHasChanged(this.ic);
        this.ic.onActivation();
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        AppLogic.imageClosed(this.ic);
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        if (!Build.CURRENT.isRobotTest()) {
            OpenSaveManager.warnAndCloseImage(this.ic);
        }
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
    }

    public void setToNaturalSize(int n, int n2) {
        int n3 = this.ic.getZoomedCanvasWidth();
        int n4 = this.ic.getZoomedCanvasHeight();
        this.setNewSize(n3, n4, n, n2);
    }

    public void setNewSize(int n, int n2, int n3, int n4) {
        if (n3 == -1) {
            n3 = this.getLocation().x;
        }
        if (n4 == -1) {
            n4 = this.getLocation().y;
        }
        Dimension dimension = PixelitorWindow.getInstance().getDesktopSize();
        int n5 = Math.max(0, dimension.width - 20 - n3);
        int n6 = Math.max(0, dimension.height - 40 - n4);
        if (n > n5) {
            n = n5;
        }
        if (n2 > n6) {
            n2 = n6;
        }
        this.setSize(n + 18, n2 + 38);
    }

    public void updateTitle() {
        this.setTitle(this.ic.createFrameTitle());
    }

    public void makeSureItIsVisible() {
        Rectangle rectangle = this.getBounds();
        if (rectangle.x < 0 || rectangle.y < 0) {
            int n = rectangle.x < 0 ? 0 : rectangle.x;
            int n2 = rectangle.y < 0 ? 0 : rectangle.y;
            this.setBounds(n, n2, rectangle.width, rectangle.height);
        }
    }
}

