/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.automate;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import pixelitor.PixelitorWindow;
import pixelitor.automate.DirectoryChooser;
import pixelitor.automate.OutputFormatSelector;
import pixelitor.io.OpenSaveManager;
import pixelitor.io.OutputFormat;
import pixelitor.utils.GridBagHelper;
import pixelitor.utils.ValidatedDialog;
import pixelitor.utils.ValidatedForm;

public class SingleDirChooserPanel
extends ValidatedForm {
    private DirectoryChooser directoryChooser;
    private OutputFormatSelector outputFormatSelector;

    public SingleDirChooserPanel(String string, String string2, String string3, boolean bl) {
        this.directoryChooser = new DirectoryChooser(string3, string2);
        JLabel jLabel = new JLabel(string);
        JTextField jTextField = this.directoryChooser.getDirTF();
        JButton jButton = this.directoryChooser.getButton();
        if (bl) {
            this.setLayout(new GridBagLayout());
            GridBagHelper.addLabel((Container)this, jLabel, 0, 0);
            GridBagHelper.addControl(this, jTextField);
            GridBagHelper.addNextControl(this, jButton);
            this.outputFormatSelector = new OutputFormatSelector();
            GridBagHelper.addLabel((Container)this, this.outputFormatSelector.getLabelText(), 0, 1);
            GridBagHelper.addControlNoFill(this, this.outputFormatSelector.getFormatCombo());
        } else {
            this.setLayout(new FlowLayout(0));
            this.add(jLabel);
            this.add(jTextField);
            this.add(jButton);
        }
    }

    private OutputFormat getSelectedFormat() {
        OutputFormat outputFormat = this.outputFormatSelector.getSelectedFormat();
        return outputFormat;
    }

    private File getSelectedDir() {
        return this.directoryChooser.getSelectedDir();
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public boolean validateData() {
        return true;
    }

    public static boolean selectOutputDir(boolean bl) {
        Object object;
        SingleDirChooserPanel singleDirChooserPanel = new SingleDirChooserPanel("Output Directory:", "Select Output Directory", OpenSaveManager.getLastSaveDir().getAbsolutePath(), bl);
        ValidatedDialog validatedDialog = new ValidatedDialog(singleDirChooserPanel, (Frame)PixelitorWindow.getInstance(), "Select Output Folder");
        validatedDialog.setVisible(true);
        if (bl) {
            object = singleDirChooserPanel.getSelectedFormat();
            OutputFormat.setLastOutputFormat(object);
        }
        if (!validatedDialog.isOkPressed()) {
            return false;
        }
        object = singleDirChooserPanel.getSelectedDir();
        if (object != null) {
            OpenSaveManager.setLastSaveDir((File)object);
            return true;
        }
        return false;
    }
}

