/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.Color;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.AngleParam;
import pixelitor.filters.gui.ImagePositionParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.utils.ImageUtils;

public class FillWithColorWheel
extends FilterWithParametrizedGUI {
    private ImagePositionParam center = new ImagePositionParam("Center");
    private AngleParam hueShiftParam = new AngleParam("Hue Shift (degrees)", 0.0);
    private RangeParam brightnessParam = new RangeParam("Brightness (%)", 0, 100, 75);
    private RangeParam satParam = new RangeParam("Saturation (%)", 0, 100, 90);

    public FillWithColorWheel() {
        super("Color Wheel");
        this.paramSet = new ParamSet(this.center, this.hueShiftParam, this.brightnessParam, this.satParam);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int[] nArray = ImageUtils.getPixelsAsArray(bufferedImage2);
        int n = bufferedImage2.getWidth();
        int n2 = bufferedImage2.getHeight();
        int n3 = (int)((float)n * this.center.getRelativeX());
        int n4 = (int)((float)n2 * this.center.getRelativeY());
        float f = (float)this.hueShiftParam.getValueInRadians();
        float f2 = this.satParam.getValueAsPercentage();
        float f3 = this.brightnessParam.getValueAsPercentage();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d = n4 - j;
                double d2 = (double)i - (double)n3;
                float f4 = (float)Math.atan2(d, d2) + f;
                float f5 = (float)((double)f4 / (Math.PI * 2));
                nArray[i + j * n] = Color.HSBtoRGB(f5, f2, f3);
            }
        }
        return bufferedImage2;
    }
}

